/*
 * Decompiled with CFR 0.152.
 */
package coop.intergal.ui.views;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.polymertemplate.Id;
import com.vaadin.flow.component.polymertemplate.PolymerTemplate;
import com.vaadin.flow.component.polymertemplate.TemplateParser;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEnterObserver;
import com.vaadin.flow.router.HasDynamicTitle;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.server.RequestHandler;
import com.vaadin.flow.server.SynchronizedRequestHandler;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.templatemodel.TemplateModel;
import coop.intergal.ui.util.UtilSessionData;
import coop.intergal.ui.views.DynamicViewGrid;
import coop.intergal.vaadin.rest.utils.DynamicDBean;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

@Tag(value="dynamic-grid-only")
@JsModule(value="./src/views/generic/layout/dynamic-grid-only.js")
@CssImport(value="./styles/tysstyle.css", themeFor="dynamic-qry-grid")
public class DynamicGridOnly
extends PolymerTemplate<TemplateModel>
implements BeforeEnterObserver,
HasDynamicTitle {
    private ArrayList<String> rowsColList;
    private final Div thisIdText = new Div();
    private final Div log = new Div();
    private Hashtable<String, DynamicViewGrid> dvgIntheForm = new Hashtable();
    private static final long serialVersionUID = 1L;
    @Id(value="grid")
    private DynamicViewGrid grid;
    @Id(value="divGrid")
    private Div divGrid;
    private final Binder<DynamicDBean> binder = new Binder(DynamicDBean.class);
    private String resourceName;
    private String title;
    private String filter;
    private String apiname;
    private boolean cache = UtilSessionData.getCache();
    private Object divInDisplay;
    private String idMenu = null;
    private String queryFormClassName;

    public ArrayList<String> getRowsColList() {
        return this.rowsColList;
    }

    public void setRowsColList(ArrayList<String> rowsColList) {
        this.rowsColList = rowsColList;
    }

    public Hashtable<String, DynamicViewGrid> getDvgIntheForm() {
        return this.dvgIntheForm;
    }

    public void setDvgIntheForm(Hashtable<String, DynamicViewGrid> dvgIntheForm) {
        this.dvgIntheForm = dvgIntheForm;
    }

    public DynamicGridOnly() {
        this.setId("DQG");
    }

    public DynamicGridOnly(TemplateParser parser, VaadinService service) {
        super(parser, service);
    }

    public DynamicGridOnly(TemplateParser parser) {
        super(parser);
    }

    public DynamicViewGrid getGrid() {
        return this.grid;
    }

    public void setGrid(DynamicViewGrid grid) {
        this.grid = grid;
    }

    public Object getDivInDisplay() {
        return this.divInDisplay;
    }

    public void setDivInDisplay(Object divInDisplay) {
        this.divInDisplay = divInDisplay;
    }

    protected String getBasePage() {
        return "products";
    }

    public String getIdMenu() {
        return this.idMenu;
    }

    public void setIdMenu(String idMenu) {
        this.idMenu = idMenu;
    }

    protected Binder<DynamicDBean> getBinder() {
        return this.binder;
    }

    public Button showButtonClickedMessage() {
        return null;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getQueryFormClassName() {
        return this.queryFormClassName;
    }

    public void setQueryFormClassName(String queryFormClassName) {
        this.queryFormClassName = queryFormClassName;
    }

    public void beforeEnter(BeforeEnterEvent event) {
        List parIdMenu;
        QueryParameters queryParameters = event.getLocation().getQueryParameters();
        this.filter = null;
        List parFIlter = (List)queryParameters.getParameters().get("filter");
        if (parFIlter != null) {
            this.filter = (String)parFIlter.get(0);
            this.filter = this.filter.replace("EEQQ", "=");
            this.filter = this.filter.replace("GGTT", "%3E");
            this.filter = this.filter.replace("LLTT", "%3C");
        }
        this.title = "..";
        this.queryFormClassName = null;
        this.title = (String)((List)queryParameters.getParameters().get("title")).get(0);
        this.resourceName = (String)((List)queryParameters.getParameters().get("resourceName")).get(0);
        if (queryParameters.getParameters().get("apiname") != null) {
            this.apiname = (String)((List)queryParameters.getParameters().get("apiname")).get(0);
        }
        if (queryParameters.getParameters().get("cache") != null) {
            String cacheStr = (String)((List)queryParameters.getParameters().get("cache")).get(0);
            this.cache = !cacheStr.equals("false");
        }
        if ((parIdMenu = (List)queryParameters.getParameters().get("idMenu")) != null) {
            this.idMenu = (String)parIdMenu.get(0);
        }
        this.queryFormClassName = (String)((List)queryParameters.getParameters().get("queryFormClassName")).get(0);
        if (!this.queryFormClassName.startsWith("coop.intergal")) {
            this.queryFormClassName = "coop.intergal.tys.ui.views." + (String)((List)queryParameters.getParameters().get("queryFormClassName")).get(0);
        }
        this.createContent();
    }

    public Component createContent() {
        this.grid.setHasSideDisplay(false);
        this.grid.setResourceName(this.resourceName);
        if (!(this.apiname == null || this.apiname.length() == 0)) {
            this.filter = this.filter != null && this.filter.length() > 0 ? this.filter + "%20%AND%20APIname='" + this.apiname + "'" : "APIname='" + this.apiname + "'";
        }
        this.grid.setFilter(this.filter);
        System.out.println("DynamicQryGridDisplay.beforeEnter() CACHE " + this.cache);
        this.grid.setiAmRootGrid(true);
        this.grid.setCache(this.cache);
        this.grid.setupGrid(false, true, true);
        return this;
    }

    public String getPageTitle() {
        try {
            this.title = URLDecoder.decode(this.title, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return UtilSessionData.addCompanyToTitle(this.title);
    }

    @ClientCallable
    public void browserIsLeaving() {
        this.getUI().ifPresent(ui -> this.closeUi((UI)ui));
    }

    private Object closeUi(UI ui) {
        System.out.println("Called browserIsLeaving ->" + ui.getId());
        ui.close();
        return null;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        UI ui = attachEvent.getUI();
        int uiId = ui.getUIId();
        this.thisIdText.setText("This UI has id " + uiId);
        this.addLogMessage("Attached " + uiId);
        Registration beaconRegistration = BeaconHandler.addBeaconListener(ui, (ComponentEventListener<BeaconEvent>)(ComponentEventListener & Serializable)beaconEvent -> {
            this.addLogMessage("Browser close event for " + uiId);
            ui.close();
        });
        this.addDetachListener((ComponentEventListener & Serializable)detachEvent -> {
            detachEvent.unregisterListener();
            beaconRegistration.remove();
        });
    }

    private void addLogMessage(String message) {
        VaadinSession.getCurrent().setAttribute("log", (Object)(DynamicGridOnly.getLogValue() + "\n" + LocalTime.now() + " " + message));
        this.refreshLog();
    }

    private void refreshLog() {
        this.log.setText(DynamicGridOnly.getLogValue());
    }

    private static String getLogValue() {
        return Objects.toString(VaadinSession.getCurrent().getAttribute("log"), "");
    }

    public static class BeaconHandler
    extends SynchronizedRequestHandler {
        private final UI ui;
        private final String beaconPath = "/beacon/" + UUID.randomUUID().toString();

        public BeaconHandler(UI ui) {
            this.ui = ui;
        }

        protected boolean canHandleRequest(VaadinRequest request) {
            return this.beaconPath.equals(request.getPathInfo());
        }

        public boolean synchronizedHandleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
            ComponentUtil.fireEvent((Component)this.ui, (ComponentEvent)new BeaconEvent(this.ui, true));
            return true;
        }

        public static Registration addBeaconListener(UI ui, ComponentEventListener<BeaconEvent> listener) {
            BeaconHandler.ensureInstalledForUi(ui);
            return ComponentUtil.addListener((Component)ui, BeaconEvent.class, listener);
        }

        private static void ensureInstalledForUi(UI ui) {
            if (ComponentUtil.getData((Component)ui, BeaconHandler.class) != null) {
                return;
            }
            BeaconHandler beaconHandler = new BeaconHandler(ui);
            String relativeBeaconPath = "." + beaconHandler.beaconPath;
            ui.getElement().executeJs("window.addEventListener('unload', function() {navigator.sendBeacon && navigator.sendBeacon($0)})", new Serializable[]{relativeBeaconPath});
            VaadinSession session = ui.getSession();
            session.addRequestHandler((RequestHandler)beaconHandler);
            ui.addDetachListener((ComponentEventListener & Serializable)detachEvent -> session.removeRequestHandler((RequestHandler)beaconHandler));
            ComponentUtil.setData((Component)ui, BeaconHandler.class, (Object)((Object)beaconHandler));
        }
    }

    public static class BeaconEvent
    extends ComponentEvent<UI> {
        public BeaconEvent(UI source, boolean fromClient) {
            super((Component)source, fromClient);
        }
    }
}

