/*
 * Decompiled with CFR 0.152.
 */
package coop.intergal.ui.views;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.grid.ColumnTextAlign;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.polymertemplate.Id;
import com.vaadin.flow.component.polymertemplate.PolymerTemplate;
import com.vaadin.flow.component.splitlayout.SplitLayout;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.renderer.LocalDateRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TemplateRenderer;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.AfterNavigationEvent;
import com.vaadin.flow.router.AfterNavigationObserver;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEnterObserver;
import com.vaadin.flow.router.HasDynamicTitle;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.templatemodel.TemplateModel;
import coop.intergal.espresso.presutec.utils.JSonClient;
import coop.intergal.ui.util.UtilSessionData;
import coop.intergal.ui.utils.TranslateResource;
import coop.intergal.ui.utils.converters.CurrencyFormatter;
import coop.intergal.ui.views.DynamicQryGridDisplay;
import coop.intergal.vaadin.rest.utils.DdbDataBackEndProvider;
import coop.intergal.vaadin.rest.utils.DynamicDBean;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

@Tag(value="dynamic-view-grid")
@JsModule(value="./src/views/admin/products/dynamic-view-grid.js")
public class DynamicGridRowCard
extends PolymerTemplate<TemplateModel>
implements BeforeEnterObserver,
AfterNavigationObserver,
HasDynamicTitle {
    private ArrayList<String[]> rowsColList;
    private String preConfParam;
    private static final long serialVersionUID = 1L;
    @Id(value="grid")
    private Grid<DynamicDBean> grid;
    private final Binder<DynamicDBean> binder = new Binder(DynamicDBean.class);
    private CurrencyFormatter currencyFormatter = new CurrencyFormatter();
    private String resourceName;
    private String title;
    private String filter;
    private DynamicQryGridDisplay layout;
    private SplitLayout gridSplitDisplay;
    private Div divDisplay;
    private String className = "C1";
    private Div divSubGrid;
    @Id(value="newRow")
    private Button newRow;

    public ArrayList<String[]> getRowsColList() {
        return this.rowsColList;
    }

    public void setRowsColList(ArrayList<String[]> rowsColList) {
        this.rowsColList = rowsColList;
    }

    public void setupGrid() {
        DdbDataBackEndProvider dataProvider = new DdbDataBackEndProvider();
        dataProvider.setPreConfParam(UtilSessionData.getCompanyYear() + "TYSLac0");
        dataProvider.setResourceName(this.getResourceName());
        dataProvider.setFilter(this.getFilter());
        this.grid.setDataProvider((DataProvider)dataProvider);
        this.rowsColList = dataProvider.getRowsColList();
        int numberOFCols = this.rowsColList.size();
        this.grid.addColumn((Renderer)TemplateRenderer.of((String)"<div style='border: 1px solid gray; padding: 10px; width: 100%; box-sizing: border-box;'><div>Hi! My name is <b>[[item.firstName]]!</b></div><div>Hi! My second name is <b>[[item.lastname]]!</b></div><div><img style='height: 80px; width: 80px;' src='[[item.image]]'/></div></div>").withProperty("firstName", DynamicDBean::getCol0).withProperty("lastname", DynamicDBean::getCol1).withProperty("address", DynamicDBean::getCol2).withProperty("image", DynamicDBean::getCol3).withEventHandler("handleClick", (SerializableConsumer & Serializable)person -> this.grid.getDataProvider().refreshItem(person)));
    }

    public static TemplateRenderer<DynamicDBean> getTemplate() {
        return TemplateRenderer.of((String)"<order-card  header='[[item.header]]'  order-card='[[item.orderCard]]'  on-card-click='cardClick'></order-card>");
    }

    private void addFormatedColumn(int i) {
        String header = TranslateResource.getFieldLocale(this.rowsColList.get(i)[0], this.preConfParam);
        if (this.isDate(header)) {
            header = header.substring(2);
            this.grid.addColumn((Renderer)new LocalDateRenderer((ValueProvider & Serializable)d -> d.getColLocalDate(i + ""), "dd/MM/yyyy")).setHeader(header).setResizable(true);
        } else if (this.isCurrency(header)) {
            header = header.substring(2);
            ((Grid.Column)this.grid.addColumn((ValueProvider & Serializable)d -> this.currencyFormatter.encode(this.getCents(d.getCol(i + "")))).setHeader(header).setTextAlign(ColumnTextAlign.END)).setResizable(true);
        } else {
            this.grid.addColumn((ValueProvider & Serializable)d -> d.getCol(i + "")).setHeader(header).setResizable(true);
        }
    }

    private Integer getCents(String col) {
        String cents = col;
        if (col.indexOf(".") > -1) {
            cents = col.substring(0, col.indexOf(".")) + col.substring(col.indexOf(".") + 1);
        }
        return new Integer(cents);
    }

    private boolean isCurrency(String header) {
        return header.startsWith("C#");
    }

    private boolean isDate(String header) {
        return header.startsWith("D#");
    }

    public Grid<DynamicDBean> getGrid() {
        return this.grid;
    }

    protected String getBasePage() {
        return "products";
    }

    protected Binder<DynamicDBean> getBinder() {
        return this.binder;
    }

    public void afterNavigation(AfterNavigationEvent event) {
        QueryParameters queryParameters = event.getLocation().getQueryParameters();
        if (queryParameters != null && !queryParameters.getParameters().isEmpty()) {
            this.setResourceName((String)((List)queryParameters.getParameters().get("resourceName")).get(0));
        }
        this.grid.addSelectionListener((SelectionListener & Serializable)e -> {
            if (e.getFirstSelectedItem().isPresent()) {
                this.showBean((DynamicDBean)e.getFirstSelectedItem().get());
            }
        });
    }

    private Object nextRow() {
        UI.getCurrent().getPage().executeJavaScript("$0._scrollToIndex(1)", new Serializable[]{this.grid.getElement()});
        return null;
    }

    private void showBean(DynamicDBean bean) {
        try {
            Class<?> dynamicForm = Class.forName("coop.intergal.tys.ui.views.comprasyventas.compras.PedidoProveedorForm");
            Object display = dynamicForm.newInstance();
            Method setRowsColList = dynamicForm.getMethod("setRowsColList", ArrayList.class);
            Method setBinder = dynamicForm.getMethod("setBinder", Binder.class);
            Method setBean = dynamicForm.getMethod("setBean", DynamicDBean.class);
            setRowsColList.invoke(display, this.rowsColList);
            setBinder.invoke(display, this.binder);
            setBean.invoke(display, bean);
            this.divDisplay.removeAll();
            this.divDisplay.add(new Component[]{(Component)display});
            String resourceSubGrid = "CR-ped_proveed_cab.List-ped_proveed_lin";
            this.divSubGrid.removeAll();
            DynamicGridRowCard subDynamicViewGrid = new DynamicGridRowCard();
            subDynamicViewGrid.setResourceName(resourceSubGrid);
            if (resourceSubGrid.indexOf(".") > -1) {
                subDynamicViewGrid.setFilter(this.componFKFilter(bean, resourceSubGrid));
            }
            subDynamicViewGrid.setupGrid();
            this.divSubGrid.add(new Component[]{subDynamicViewGrid});
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public String componFKFilter(DynamicDBean bean, String resourceSubGrid) {
        int idXEqual;
        int lengthFKfilter;
        String fKfilter = JSonClient.getHt().get(resourceSubGrid);
        int step = 0;
        String componFilter = "";
        int leftLength = lengthFKfilter = fKfilter.length();
        while ((lengthFKfilter > 0 || fKfilter.length() > 0) && (idXEqual = fKfilter.indexOf("=")) != -1) {
            int idXMark = fKfilter.indexOf("]");
            step = fKfilter.startsWith("\n and") ? 6 : 0;
            String fKfieldName = fKfilter.substring(step + 1, idXEqual - 2);
            String parentfieldName = fKfilter.substring(4 + idXEqual, idXMark - 1);
            String parentValue = bean.getRowJSon().get(parentfieldName).asText();
            componFilter = componFilter + fKfieldName + "=" + parentValue + "%20and%20";
            lengthFKfilter -= idXMark;
            fKfilter = fKfilter.substring(idXMark + 1);
        }
        componFilter = componFilter.substring(0, componFilter.length() - 9);
        return componFilter;
    }

    public void beforeEnter(BeforeEnterEvent event) {
        QueryParameters queryParameters = event.getLocation().getQueryParameters();
        List parFIlter = (List)queryParameters.getParameters().get("filter");
        if (parFIlter != null) {
            this.setFilter((String)parFIlter.get(0));
            this.setFilter(this.getFilter().replace("EEQQ", "="));
        }
        this.title = "..";
        if (queryParameters != null && !queryParameters.getParameters().isEmpty()) {
            this.title = (String)((List)queryParameters.getParameters().get("title")).get(0);
        }
    }

    public String getPageTitle() {
        return this.title;
    }

    public void setQueryParameters(QueryParameters queryParameters) {
    }

    public void setDisplay(Div divDisplay) {
        this.divDisplay = divDisplay;
    }

    public void setLayout(DynamicQryGridDisplay layout) {
        this.layout = layout;
    }

    public void setGridSplitDisplay(SplitLayout gridSplitDisplay) {
        this.gridSplitDisplay = gridSplitDisplay;
    }

    public void setDivSubGrid(Div divSubGrid) {
        this.divSubGrid = divSubGrid;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }
}

