/*
 * Decompiled with CFR 0.152.
 */
package coop.intergal.ui.views;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H4;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.page.Push;
import com.vaadin.flow.component.polymertemplate.Id;
import com.vaadin.flow.component.polymertemplate.PolymerTemplate;
import com.vaadin.flow.component.polymertemplate.TemplateParser;
import com.vaadin.flow.component.splitlayout.SplitLayout;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEnterObserver;
import com.vaadin.flow.router.HasDynamicTitle;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.RequestHandler;
import com.vaadin.flow.server.SynchronizedRequestHandler;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.templatemodel.TemplateModel;
import coop.intergal.ui.components.FormButtonsBar;
import coop.intergal.ui.util.UtilSessionData;
import coop.intergal.ui.utils.Broadcaster;
import coop.intergal.ui.views.DynamicViewGrid;
import coop.intergal.ui.views.GeneratedQuery;
import coop.intergal.vaadin.rest.utils.DdbDataBackEndProvider;
import coop.intergal.vaadin.rest.utils.DynamicDBean;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

@Tag(value="dynamic-qry-grid-display")
@JsModule(value="./src/views/generic/layout/dynamic-qry-grid-display.js")
@CssImport.Container(value={@CssImport(value="./styles/tysstyle.css", themeFor="dynamic-qry-grid-display"), @CssImport(value="./styles/tysstyle-form-layout.css", themeFor="vaadin-form-layout")})
@Push
@Route(value="dynamicQGD")
public class DynamicQryGridDisplay
extends PolymerTemplate<TemplateModel>
implements BeforeEnterObserver,
HasDynamicTitle {
    private ArrayList<String> rowsColList;
    private final Div thisIdText = new Div();
    private final Div log = new Div();
    private Hashtable<String, DynamicViewGrid> dvgIntheForm = new Hashtable();
    private static final long serialVersionUID = 1L;
    @Id(value="grid")
    private DynamicViewGrid grid;
    @Id(value="divDisplay")
    private Div divDisplay;
    @Id(value="divSubGrid")
    private Div divSubGrid;
    private final Binder<DynamicDBean> binder = new Binder(DynamicDBean.class);
    private String resourceName;
    private String title;
    private String filter;
    @Id(value="querySplitGrid")
    private Div querySplitGrid;
    @Id(value="gridSplitDisplay")
    private SplitLayout gridSplitDisplay;
    @Id(value="displaySplitSubGrid")
    private SplitLayout displaySplitSubGrid;
    @Id(value="divTitle")
    private Div divTitle;
    @Id(value="divQuery")
    private Div divQuery;
    @Id(value="buttons")
    private FormButtonsBar buttons;
    private String apiname;
    private boolean cache = UtilSessionData.getCache();
    private Object divInDisplay;
    private String idMenu = null;
    private String displayFormClassName;
    private String addFormClassName;
    private String queryFormClassName;
    private String gridClassName;
    private Registration broadcasterRegistration;
    VerticalLayout messages = new VerticalLayout();

    public ArrayList<String> getRowsColList() {
        return this.rowsColList;
    }

    public void setRowsColList(ArrayList<String> rowsColList) {
        this.rowsColList = rowsColList;
    }

    public Hashtable<String, DynamicViewGrid> getDvgIntheForm() {
        return this.dvgIntheForm;
    }

    public void setDvgIntheForm(Hashtable<String, DynamicViewGrid> dvgIntheForm) {
        this.dvgIntheForm = dvgIntheForm;
    }

    public DynamicQryGridDisplay() {
        this.setId("DQGD");
    }

    public DynamicQryGridDisplay(TemplateParser parser, VaadinService service) {
        super(parser, service);
    }

    public DynamicQryGridDisplay(TemplateParser parser) {
        super(parser);
    }

    public Div getDivDisplay() {
        return this.divDisplay;
    }

    public void setDivDisplay(Div divDisplay) {
        this.divDisplay = divDisplay;
    }

    public DynamicViewGrid getGrid() {
        return this.grid;
    }

    public void setGrid(DynamicViewGrid grid) {
        this.grid = grid;
    }

    public Div getDivQuery() {
        return this.divQuery;
    }

    public SplitLayout getDisplaySplitSubGrid() {
        return this.displaySplitSubGrid;
    }

    public void setDisplaySplitSubGrid(SplitLayout displaySplitSubGrid) {
        this.displaySplitSubGrid = displaySplitSubGrid;
    }

    public Div getQuerySplitGrid() {
        return this.querySplitGrid;
    }

    public void setQuerySplitGrid(Div querySplitGrid) {
        this.querySplitGrid = querySplitGrid;
    }

    public SplitLayout getGridSplitDisplay() {
        return this.gridSplitDisplay;
    }

    public void setGridSplitDisplay(SplitLayout gridSplitDisplay) {
        this.gridSplitDisplay = gridSplitDisplay;
    }

    public Object getDivInDisplay() {
        return this.divInDisplay;
    }

    public void setDivInDisplay(Object divInDisplay) {
        this.divInDisplay = divInDisplay;
    }

    public void setDivQuery(Div divQuery) {
        this.divQuery = divQuery;
    }

    protected String getBasePage() {
        return "products";
    }

    public String getIdMenu() {
        return this.idMenu;
    }

    public void setIdMenu(String idMenu) {
        this.idMenu = idMenu;
    }

    protected Binder<DynamicDBean> getBinder() {
        return this.binder;
    }

    public Button showButtonClickedMessage() {
        return null;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getDisplayFormClassName() {
        return this.displayFormClassName;
    }

    public void setDisplayFormClassName(String displayFormClassName) {
        this.displayFormClassName = displayFormClassName;
    }

    public String getAddFormClassName() {
        return this.addFormClassName;
    }

    public void setAddFormClassName(String addFormClassName) {
        this.addFormClassName = addFormClassName;
    }

    public String getQueryFormClassName() {
        return this.queryFormClassName;
    }

    public void setQueryFormClassName(String queryFormClassName) {
        this.queryFormClassName = queryFormClassName;
    }

    public void beforeEnter(BeforeEnterEvent event) {
        this.setId("DQGD");
        QueryParameters queryParameters = event.getLocation().getQueryParameters();
        this.filter = null;
        List parFIlter = (List)queryParameters.getParameters().get("filter");
        if (parFIlter != null) {
            this.filter = (String)parFIlter.get(0);
            this.filter = this.filter.replace("EEQQ", "=");
            this.filter = this.filter.replace("GGTT", "%3E");
            this.filter = this.filter.replace("LLTT", "%3C");
        }
        this.title = "..";
        String queryFormClassName = null;
        String displayFormClassName = null;
        String addFormClassName = null;
        String gridClassName = null;
        if (queryParameters != null && !queryParameters.getParameters().isEmpty()) {
            List parIdMenu;
            this.title = (String)((List)queryParameters.getParameters().get("title")).get(0);
            this.resourceName = (String)((List)queryParameters.getParameters().get("resourceName")).get(0);
            if (queryParameters.getParameters().get("apiname") != null) {
                this.apiname = (String)((List)queryParameters.getParameters().get("apiname")).get(0);
            }
            if (queryParameters.getParameters().get("cache") != null) {
                String cacheStr = (String)((List)queryParameters.getParameters().get("cache")).get(0);
                this.cache = !cacheStr.equals("false");
            }
            if ((parIdMenu = (List)queryParameters.getParameters().get("idMenu")) != null) {
                this.idMenu = (String)parIdMenu.get(0);
            }
            queryFormClassName = (String)((List)queryParameters.getParameters().get("queryFormClassName")).get(0);
            displayFormClassName = (String)((List)queryParameters.getParameters().get("displayFormClassName")).get(0);
            if (queryParameters.getParameters().get("addFormClassName") != null && !(addFormClassName = (String)((List)queryParameters.getParameters().get("addFormClassName")).get(0)).startsWith("coop.intergal")) {
                addFormClassName = "coop.intergal.tys.ui.views." + (String)((List)queryParameters.getParameters().get("addFormClassName")).get(0);
            }
            if (!displayFormClassName.startsWith("coop.intergal")) {
                displayFormClassName = "coop.intergal.tys.ui.views." + (String)((List)queryParameters.getParameters().get("displayFormClassName")).get(0);
            }
            if (!queryFormClassName.startsWith("coop.intergal")) {
                queryFormClassName = "coop.intergal.tys.ui.views." + (String)((List)queryParameters.getParameters().get("queryFormClassName")).get(0);
            }
            if (queryParameters.getParameters().get("gridClassName") != null) {
                gridClassName = (String)((List)queryParameters.getParameters().get("gridClassName")).get(0);
            }
        }
        this.prepareLayout(queryFormClassName, displayFormClassName, addFormClassName, gridClassName);
    }

    public Component createContent() {
        this.prepareLayout(this.queryFormClassName, this.displayFormClassName, this.addFormClassName, this.gridClassName);
        return this;
    }

    public void prepareLayout(String queryFormClassName, String displayFormClassName, String addFormClassName, String gridClassName) {
        this.gridSplitDisplay.setOrientation(SplitLayout.Orientation.HORIZONTAL);
        this.displaySplitSubGrid.setOrientation(SplitLayout.Orientation.VERTICAL);
        try {
            Class<?> dynamicQuery = Class.forName(queryFormClassName);
            Object queryForm = dynamicQuery.newInstance();
            Method setGrid = dynamicQuery.getMethod("setGrid", DynamicViewGrid.class);
            setGrid.invoke(queryForm, new Object[]{this.grid});
            this.divQuery.removeAll();
            if (queryFormClassName.indexOf("Generated") > -1) {
                String titleByID;
                DdbDataBackEndProvider dataProvider = new DdbDataBackEndProvider();
                dataProvider.setPreConfParam(UtilSessionData.getCompanyYear() + "TYSLac0");
                dataProvider.setResourceName(this.resourceName);
                Method setDataProvider = dynamicQuery.getMethod("setDataProvider", DdbDataBackEndProvider.class);
                Method createDetails = dynamicQuery.getMethod("createDetails", new Class[0]);
                Method setRowsColList = dynamicQuery.getMethod("setRowsColList", ArrayList.class);
                setDataProvider.invoke(queryForm, new Object[]{dataProvider});
                setRowsColList.invoke(queryForm, this.rowsColList);
                this.divInDisplay = createDetails.invoke(queryForm, new Object[0]);
                if (((GeneratedQuery)((Object)this.divInDisplay)).getId().isPresent() && (titleByID = (String)((GeneratedQuery)((Object)this.divInDisplay)).getId().get()) != null && titleByID.length() > 2) {
                    H4 h4 = new H4(titleByID);
                    h4.getStyle().set("padding", "0");
                    h4.getStyle().set("margin", "0");
                    this.divTitle.add(new Component[]{h4});
                }
                this.divQuery.add(new Component[]{(Component)this.divInDisplay});
            } else {
                this.divQuery.add(new Component[]{(Component)queryForm});
            }
        }
        catch (ClassNotFoundException e2) {
            e2.printStackTrace();
        }
        catch (InstantiationException e3) {
            e3.printStackTrace();
        }
        catch (IllegalAccessException e4) {
            e4.printStackTrace();
        }
        catch (NoSuchMethodException e5) {
            e5.printStackTrace();
        }
        catch (SecurityException e6) {
            e6.printStackTrace();
        }
        catch (IllegalArgumentException e7) {
            e7.printStackTrace();
        }
        catch (InvocationTargetException e8) {
            e8.printStackTrace();
        }
        this.grid.setDisplayFormClassName(displayFormClassName);
        this.grid.setDisplay(this.divDisplay);
        this.grid.setDivSubGrid(this.divSubGrid);
        this.grid.setButtonsForm(this.buttons);
        this.grid.setHasSideDisplay(true);
        this.grid.setLayout(this);
        this.grid.setResourceName(this.resourceName);
        if (!(this.apiname == null || this.apiname.length() == 0)) {
            this.filter = this.filter != null && this.filter.length() > 0 ? this.filter + "%20%AND%20APIname='" + this.apiname + "'" : "APIname='" + this.apiname + "'";
        }
        this.grid.setFilter(this.filter);
        System.out.println("DynamicQryGridDisplay.beforeEnter() CACHE " + this.cache);
        this.grid.setiAmRootGrid(true);
        this.grid.setCache(this.cache);
        if (gridClassName != null && gridClassName.equals("TreeGrid")) {
            this.grid.setupTreeGrid(null);
        } else {
            this.grid.setupGrid(false, true, true);
        }
        this.grid.setAddFormClassName(addFormClassName);
        this.buttons.setVisible(false);
        this.buttons.addSaveListener((ComponentEventListener<FormButtonsBar.SaveEvent>)(ComponentEventListener & Serializable)e -> this.grid.saveSelectedRow(this.apiname));
        this.buttons.addCancelListener((ComponentEventListener<FormButtonsBar.CancelEvent>)(ComponentEventListener & Serializable)e -> this.grid.undoSelectedRow());
        this.buttons.addAddListener((ComponentEventListener<FormButtonsBar.AddEvent>)(ComponentEventListener & Serializable)e -> this.grid.insertANewRow(addFormClassName));
        this.buttons.addDeleteListener((ComponentEventListener<FormButtonsBar.DeleteEvent>)(ComponentEventListener & Serializable)e -> this.grid.DeleteARow());
        this.buttons.addPrintListener((ComponentEventListener<FormButtonsBar.PrintEvent>)(ComponentEventListener & Serializable)e -> this.grid.PrintARow());
    }

    public String getPageTitle() {
        try {
            this.title = URLDecoder.decode(this.title, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return UtilSessionData.addCompanyToTitle(this.title);
    }

    @ClientCallable
    public void browserIsLeaving() {
        this.getUI().ifPresent(ui -> this.closeUi((UI)ui));
    }

    private Object closeUi(UI ui) {
        System.out.println("Called browserIsLeaving ->" + ui.getId());
        ui.close();
        return null;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        UI ui = attachEvent.getUI();
        int uiId = ui.getUIId();
        this.thisIdText.setText("This UI has id " + uiId);
        this.addLogMessage("Attached " + uiId);
        Registration beaconRegistration = BeaconHandler.addBeaconListener(ui, (ComponentEventListener<BeaconEvent>)(ComponentEventListener & Serializable)beaconEvent -> {
            this.addLogMessage("Browser close event for " + uiId);
            ui.close();
        });
        this.broadcasterRegistration = Broadcaster.register(newMessage -> ui.access((Command & Serializable)() -> this.messages.add(new Component[]{new Span(newMessage)})));
        this.addDetachListener((ComponentEventListener & Serializable)detachEvent -> {
            detachEvent.unregisterListener();
            beaconRegistration.remove();
        });
    }

    protected void onDetach(DetachEvent detachEvent) {
        this.broadcasterRegistration.remove();
        this.broadcasterRegistration = null;
    }

    private void addLogMessage(String message) {
        VaadinSession.getCurrent().setAttribute("log", (Object)(DynamicQryGridDisplay.getLogValue() + "\n" + LocalTime.now() + " " + message));
        this.refreshLog();
    }

    private void refreshLog() {
        this.log.setText(DynamicQryGridDisplay.getLogValue());
    }

    private static String getLogValue() {
        return Objects.toString(VaadinSession.getCurrent().getAttribute("log"), "");
    }

    public static class BeaconHandler
    extends SynchronizedRequestHandler {
        private final UI ui;
        private final String beaconPath = "/beacon/" + UUID.randomUUID().toString();

        public BeaconHandler(UI ui) {
            this.ui = ui;
        }

        protected boolean canHandleRequest(VaadinRequest request) {
            return this.beaconPath.equals(request.getPathInfo());
        }

        public boolean synchronizedHandleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
            ComponentUtil.fireEvent((Component)this.ui, (ComponentEvent)new BeaconEvent(this.ui, true));
            return true;
        }

        public static Registration addBeaconListener(UI ui, ComponentEventListener<BeaconEvent> listener) {
            BeaconHandler.ensureInstalledForUi(ui);
            return ComponentUtil.addListener((Component)ui, BeaconEvent.class, listener);
        }

        private static void ensureInstalledForUi(UI ui) {
            if (ComponentUtil.getData((Component)ui, BeaconHandler.class) != null) {
                return;
            }
            BeaconHandler beaconHandler = new BeaconHandler(ui);
            String relativeBeaconPath = "." + beaconHandler.beaconPath;
            ui.getElement().executeJs("window.addEventListener('unload', function() {navigator.sendBeacon && navigator.sendBeacon($0)})", new Serializable[]{relativeBeaconPath});
            VaadinSession session = ui.getSession();
            session.addRequestHandler((RequestHandler)beaconHandler);
            ui.addDetachListener((ComponentEventListener & Serializable)detachEvent -> session.removeRequestHandler((RequestHandler)beaconHandler));
            ComponentUtil.setData((Component)ui, BeaconHandler.class, (Object)((Object)beaconHandler));
        }
    }

    public static class BeaconEvent
    extends ComponentEvent<UI> {
        public BeaconEvent(UI source, boolean fromClient) {
            super((Component)source, fromClient);
        }
    }
}

