/*
 * Decompiled with CFR 0.152.
 */
package coop.intergal.ui.views;

import com.fasterxml.jackson.databind.JsonNode;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.polymertemplate.Id;
import com.vaadin.flow.component.treegrid.TreeGrid;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEnterObserver;
import com.vaadin.flow.router.HasDynamicTitle;
import com.vaadin.flow.router.QueryParameters;
import coop.intergal.ui.components.FormButtonsBar;
import coop.intergal.ui.components.navigation.drawer.NaviMenu;
import coop.intergal.ui.util.UtilSessionData;
import coop.intergal.ui.utils.converters.CurrencyFormatter;
import coop.intergal.ui.views.DynamicQryGridDisplay;
import coop.intergal.ui.views.DynamicViewGrid;
import coop.intergal.vaadin.rest.utils.DdbHierarchicalDataProvider;
import coop.intergal.vaadin.rest.utils.DynamicDBean;
import coop.intergal.vaadin.rest.utils.RestData;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Tag(value="dynamic-tree-display")
@JsModule.Container(value={@JsModule(value="./src/views/generic/layout/dynamic-tree-display.js"), @JsModule(value="@vaadin/vaadin-lumo-styles/badge")})
public class DynamicTreeDisplay
extends DynamicViewGrid
implements BeforeEnterObserver,
HasDynamicTitle {
    private ArrayList<String> rowsColList;
    private DynamicQryGridDisplay layoutQGD;
    private static final long serialVersionUID = 1L;
    @Id(value="divTree")
    private Div divTree;
    @Id(value="divDisplay")
    private Div divDisplay;
    @Id(value="divSubGrid")
    private Div divSubGrid;
    private final Binder<DynamicDBean> binder = new Binder(DynamicDBean.class);
    private CurrencyFormatter currencyFormatter = new CurrencyFormatter();
    private String resourceName;
    private String title;
    private String filter;
    @Id(value="buttons")
    private FormButtonsBar buttons;
    private FormButtonsBar buttonsForm;
    private String apiname;
    private TreeGrid<DynamicDBean> treeGrid = new TreeGrid();
    private DdbHierarchicalDataProvider dataProvider;
    private ArrayList<String[]> rowsColListGrid;
    private NaviMenu menu;
    private int firstShowCol;
    private DynamicDBean selectedRow;
    private String displayFormClassName;
    private DynamicDBean keepRowBeforChanges;
    private Object display;
    private Method setBean;
    private Object divInDisplay;
    private boolean isResourceReadOnly;
    private static final String CLASS_NAME = "root";

    public ArrayList<String> getRowsColList() {
        return this.rowsColList;
    }

    @Override
    protected String getBasePage() {
        return "products";
    }

    @Override
    protected Binder<DynamicDBean> getBinder() {
        return this.binder;
    }

    public Button showButtonClickedMessage() {
        return null;
    }

    public void beforeEnter(BeforeEnterEvent event) {
        QueryParameters queryParameters = event.getLocation().getQueryParameters();
        this.filter = null;
        List parFIlter = (List)queryParameters.getParameters().get("filter");
        if (parFIlter != null) {
            this.filter = (String)parFIlter.get(0);
            this.filter = this.filter.replace("EEQQ", "=");
        }
        this.title = "..";
        String queryFormClassName = null;
        if (queryParameters != null && !queryParameters.getParameters().isEmpty()) {
            this.title = (String)((List)queryParameters.getParameters().get("title")).get(0);
            this.resourceName = (String)((List)queryParameters.getParameters().get("resourceName")).get(0);
            if (queryParameters.getParameters().get("apiname") != null) {
                this.apiname = (String)((List)queryParameters.getParameters().get("apiname")).get(0);
            }
            queryFormClassName = "coop.intergal.tys.ui.views." + (String)((List)queryParameters.getParameters().get("queryFormClassName")).get(0);
            this.displayFormClassName = "coop.intergal.tys.ui.views." + (String)((List)queryParameters.getParameters().get("displayFormClassName")).get(0);
        }
        this.setupGrid();
        this.divTree.add(new Component[]{this.treeGrid});
        this.buttons.setVisible(false);
    }

    @Override
    public String getPageTitle() {
        return this.title;
    }

    @Override
    public void setupGrid() {
        this.dataProvider = new DdbHierarchicalDataProvider();
        this.dataProvider.setPreConfParam(UtilSessionData.getCompanyYear() + "TYSLac0");
        this.dataProvider.setResourceName(this.resourceName);
        List<DynamicDBean> rootList = RestData.getResourceData(0, 0, this.resourceName, UtilSessionData.getCompanyYear() + "TYSLac0", this.dataProvider.getRowsColList(), null, true, false, null);
        this.treeGrid.setMultiSort(true);
        this.treeGrid.setItems(rootList, this::getSubList);
        this.rowsColListGrid = this.dataProvider.getRowsColList();
        int numberOFCols = this.rowsColListGrid.size();
        System.out.println("DynamicTreeDisplay.setupGrid() " + numberOFCols);
        this.firstShowCol = 0;
        for (int i = 1; i < numberOFCols; ++i) {
            Grid.Column<DynamicDBean> col = this.addTreeColumn(i);
            if (col == null) continue;
            col.setAutoWidth(true);
        }
        this.treeGrid.addSelectionListener((SelectionListener & Serializable)e -> {
            if (e.getFirstSelectedItem().isPresent()) {
                this.selectedRow = (DynamicDBean)e.getFirstSelectedItem().get();
            }
            System.out.println("Registro seleccionado " + this.selectedRow.getCol0());
            this.methodForRowSelected(this.selectedRow);
        });
    }

    private Grid.Column<DynamicDBean> addTreeColumn(int i) {
        String[] colData = this.rowsColListGrid.get(i);
        String colName = colData[2];
        String colType = colData[3];
        String colHeader = colData[6];
        Grid.Column col = null;
        if (colData[1].indexOf("#SIG#") > -1) {
            System.out.println("DynamicTreeDisplay.addTreeColumn() " + colName);
            String header = colHeader;
            col = this.firstShowCol == 0 ? ((Grid.Column)this.treeGrid.addHierarchyColumn((ValueProvider & Serializable)d -> d.getCol(colName)).setHeader(header).setResizable(true)).setSortProperty(new String[]{colData[0]}) : ((Grid.Column)this.treeGrid.addColumn((ValueProvider & Serializable)d -> d.getCol(colName)).setHeader(header).setResizable(true)).setSortProperty(new String[]{colData[0]});
            ++this.firstShowCol;
        }
        return col;
    }

    @Override
    public Collection<DynamicDBean> getSubList(DynamicDBean bean) {
        if (bean.getRowJSon().get("subLevel") == null) {
            return new ArrayList<DynamicDBean>();
        }
        String subLevel = bean.getRowJSon().get("subLevel").asText();
        JsonNode rowJson = bean.getRowJSon().get(subLevel);
        String resourceNameRoot = bean.getResourceName() + "." + subLevel;
        DdbHierarchicalDataProvider subDataProvider = new DdbHierarchicalDataProvider();
        subDataProvider.setPreConfParam(UtilSessionData.getCompanyYear() + "TYSLac0");
        subDataProvider.setResourceName(this.resourceName);
        List<DynamicDBean> subList = RestData.getResourceData(rowJson, resourceNameRoot, UtilSessionData.getCompanyYear() + "TYSLac0", subDataProvider.getRowsColList(), true, false, null);
        return subList;
    }

    private void methodForRowSelected(DynamicDBean selectedRow2) {
        String method = selectedRow2.getMethodForRowSelected();
        if (method != null) {
            this.runMethodFor(method, selectedRow2);
        } else {
            this.showBean(selectedRow2);
            System.out.println("DynamicViewGrid.methodForRowSelected() NOT method assigned using ShowBean if configure as hasSideDisplay");
        }
    }

    private void runMethodFor(String methodName, DynamicDBean selectedRow2) {
        System.out.println("method to run " + methodName);
        try {
            Class<?> classForMethods = Class.forName("coop.intergal.tys.ui.util.ClassForMethods");
            Object oClassForMethods = classForMethods.newInstance();
            Method method = classForMethods.getMethod(methodName, DynamicDBean.class, DynamicViewGrid.class);
            method.invoke(oClassForMethods, new Object[]{selectedRow2, this});
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }
}

