/*
 * Decompiled with CFR 0.152.
 */
package coop.intergal.ui.views;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Label;
import com.vaadin.flow.component.polymertemplate.PolymerTemplate;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.templatemodel.TemplateModel;
import coop.intergal.ui.components.FlexBoxLayout;
import coop.intergal.ui.components.FormButtonsBar;
import coop.intergal.ui.components.detailsdrawer.DetailsDrawer;
import coop.intergal.ui.util.FontSize;
import coop.intergal.ui.util.GenericClassForMethods;
import coop.intergal.ui.util.TextColor;
import coop.intergal.ui.util.UIUtils;
import coop.intergal.ui.util.UtilSessionData;
import coop.intergal.ui.utils.converters.CurrencyFormatter;
import coop.intergal.ui.views.DynamicViewGrid;
import coop.intergal.ui.views.GeneratedUtil;
import coop.intergal.vaadin.rest.utils.DdbDataBackEndProvider;
import coop.intergal.vaadin.rest.utils.DynamicDBean;
import coop.intergal.vaadin.rest.utils.RestData;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

@Tag(value="generated-details")
@CssImport.Container(value={@CssImport(value="./styles/tysstyle.css", themeFor="dynamic-grid-display"), @CssImport(value="./styles/tysstyle-form-item.css", themeFor="vaadin-form-item"), @CssImport(value="./styles/tysstyle-form-layout.css", themeFor="vaadin-form-layout")})
@JsModule(value="./src/views/generic/forms/generated-details.js")
public class GeneratedDetails
extends PolymerTemplate<TemplateModel> {
    private static final long serialVersionUID = 1L;
    private Grid<DynamicDBean> grid;
    private DynamicViewGrid dVGrid;
    private DdbDataBackEndProvider dataProvider;
    private DetailsDrawer detailsDrawer;
    private Binder<DynamicDBean> binder;
    private FormLayout form;
    private ArrayList<String[]> rowsColList;
    private ArrayList<String[]> rowsFieldList;
    private CurrencyFormatter currencyFormatter = new CurrencyFormatter();
    private Hashtable<String, DynamicDBean> beansToSaveAndRefresh = new Hashtable();
    private String title;
    private String resource;
    private boolean cache = true;
    private DynamicDBean bean;
    private Div divSubGrid;
    GeneratedUtil generatedUtil = new GeneratedUtil();
    private FormButtonsBar buttonsForm;
    private GenericClassForMethods genericClassForMethods;

    public DynamicDBean getBean() {
        return this.bean;
    }

    public void setBean(DynamicDBean bean) {
        this.bean = bean;
    }

    public DdbDataBackEndProvider getDataProvider() {
        return this.dataProvider;
    }

    public void setDataProvider(DdbDataBackEndProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    public Binder<DynamicDBean> getBinder() {
        return this.binder;
    }

    public void setBinder(Binder<DynamicDBean> binder) {
        this.binder = binder;
    }

    public ArrayList<String[]> getRowsColList() {
        return this.rowsColList;
    }

    public void setRowsColList(ArrayList<String[]> rowsColList) {
        this.rowsColList = rowsColList;
    }

    public FormButtonsBar getButtonsForm() {
        return this.buttonsForm;
    }

    public void setButtonsForm(FormButtonsBar buttonsForm) {
        this.buttonsForm = buttonsForm;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
    }

    public DynamicViewGrid getDVGrid() {
        return this.dVGrid;
    }

    public void setDVGrid(DynamicViewGrid dVGrid) {
        this.dVGrid = dVGrid;
    }

    public Div getDivSubGrid() {
        return this.divSubGrid;
    }

    public void setDivSubGrid(Div divSubGrid) {
        this.divSubGrid = divSubGrid;
        this.generatedUtil.setDivSubGrid(divSubGrid);
    }

    private boolean isCurrency(String header, String colType) {
        if (header.startsWith("C#")) {
            return true;
        }
        return colType.equals("3");
    }

    private boolean isDate(String header, String colType) {
        if (header.startsWith("D#")) {
            return true;
        }
        return colType.equals("1");
    }

    private boolean isBoolean(String header, String colType) {
        return colType.equals("4");
    }

    private Object detailsDrawerHide() {
        this.detailsDrawer.setMaxWidth("0px");
        this.detailsDrawer.hide();
        return null;
    }

    private void showDetails(DynamicDBean dynamicDBean) {
        this.beansToSaveAndRefresh.clear();
        this.beansToSaveAndRefresh.put(dynamicDBean.getResourceName(), dynamicDBean);
        this.detailsDrawer.setContent(this.createDetails());
        this.detailsDrawer.setWidthFull();
        this.detailsDrawer.setMaxWidth("1150px");
        this.detailsDrawer.show();
    }

    public Component createContent(FormButtonsBar buttonsForm) {
        return this.createContent(buttonsForm, null);
    }

    public Component createContent(FormButtonsBar buttonsForm, GenericClassForMethods genericClassForMethods) {
        this.setId("GeneratedDetails");
        this.buttonsForm = buttonsForm;
        if (genericClassForMethods != null) {
            this.genericClassForMethods = genericClassForMethods;
        }
        FlexBoxLayout content = new FlexBoxLayout(this.createDetails());
        content.getElement().getStyle().set("display", "block");
        content.getElement().getStyle().set("width", "1360px");
        Div header = new Div();
        header.setClassName("formTitle");
        header.add(new Component[]{UIUtils.createH3Label(this.title)});
        Div headearAndForm = new Div();
        headearAndForm.add(new Component[]{header});
        headearAndForm.add(new Component[]{content});
        return headearAndForm;
    }

    private Component createDetails() {
        if (this.binder == null) {
            this.binder = new Binder(DynamicDBean.class);
        }
        this.generatedUtil.setGrid(this.dVGrid);
        this.generatedUtil.setBean(this.bean);
        this.generatedUtil.setButtonsForm(this.buttonsForm);
        this.generatedUtil.setGenericClassForMethods(this.genericClassForMethods);
        this.rowsFieldList = this.dataProvider.getResourceName().equals(this.bean.getResourceName()) ? this.dataProvider.getRowsFieldList() : RestData.getRowsFieldList(null, this.bean.getResourceName(), UtilSessionData.getCompanyYear() + "TYSLac0", this.cache);
        String tabs = "";
        if (this.rowsFieldList != null) {
            tabs = this.rowsFieldList.get(0)[17];
        }
        if (tabs.isEmpty()) {
            Component generateComponent = this.generatedUtil.createDetails(this.bean.getResourceName(), this.rowsFieldList, false, this.cache, "noTAB");
            this.setBinder(this.generatedUtil.getBinder());
            return generateComponent;
        }
        Component generateComponent = this.generatedUtil.createTabs(this.bean.getResourceName(), this.rowsFieldList, false, this.cache, tabs);
        this.setBinder(this.generatedUtil.getBinder());
        return generateComponent;
    }

    private FormLayout addClassNames(FormLayout formLayout, String classNames) {
        StringTokenizer tokens = new StringTokenizer(classNames, ".");
        while (tokens.hasMoreElements()) {
            String eachClass = tokens.nextToken();
            formLayout.addClassName(eachClass);
        }
        return formLayout;
    }

    private Div alingLabel(String label) {
        Div l = new Div();
        l.add(label);
        if (label.endsWith("#")) {
            l.addClassName("labelright");
            label = label.substring(0, label.length() - 1);
            l.setText(label);
        }
        return l;
    }

    private boolean isReadOnly(String params) {
        if (params == null) {
            return false;
        }
        return params.indexOf("#CNoEDT#") > -1;
    }

    private Component createAttachments() {
        Label message = UIUtils.createLabel(FontSize.S, TextColor.SECONDARY, "Not implemented yet.");
        message.addClassNames(new String[]{"padding-r-h-l", "padding-v-l"});
        return message;
    }

    private Component createHistory() {
        Label message = UIUtils.createLabel(FontSize.S, TextColor.SECONDARY, "Not implemented yet.");
        message.addClassNames(new String[]{"padding-r-h-l", "padding-v-l"});
        return message;
    }
}

