/*
 * Decompiled with CFR 0.152.
 */
package coop.intergal.ui.views;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H3;
import com.vaadin.flow.component.polymertemplate.Id;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEnterObserver;
import com.vaadin.flow.router.HasDynamicTitle;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.spring.annotation.SpringComponent;
import coop.intergal.ui.components.QueryButtonsBar;
import coop.intergal.ui.util.UtilSessionData;
import coop.intergal.ui.views.DynamicViewGrid;
import coop.intergal.ui.views.GeneratedUtil;
import coop.intergal.ui.views.GenericDynamicQuery;
import coop.intergal.vaadin.rest.utils.DdbDataBackEndProvider;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Scope;

@Tag(value="generated-query")
@JsModule(value="./src/views/generic/forms/generated-query.js")
@SpringComponent
@Scope(value="prototype")
@Route(value="qG")
@CssImport.Container(value={@CssImport(value="./styles/tysstyle.css", themeFor="generated-query"), @CssImport(value="./styles/tysstyle-form-item.css", themeFor="vaadin-form-item")})
public class GeneratedQuery
extends GenericDynamicQuery
implements HasDynamicTitle,
BeforeEnterObserver {
    private static final long serialVersionUID = 1L;
    private DynamicViewGrid grid;
    private DdbDataBackEndProvider dataProvider;
    private ArrayList<String[]> rowsQueryFieldList;
    private String title;
    private Boolean cache = true;
    @Id(value="form")
    private FormLayout form;
    @Id(value="queryButtonsBar")
    private QueryButtonsBar queryButtonsBar;
    private String filter = null;

    public boolean isCache() {
        return this.cache;
    }

    public void setCache(Boolean cache) {
        this.cache = cache;
    }

    @Override
    public String getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(String filter) {
        this.filter = filter;
    }

    public GeneratedQuery() {
        this.preConfParam = UtilSessionData.getCompanyYear() + "TYSLac0";
        this.queryButtonsBar.addSearchListener((ComponentEventListener<QueryButtonsBar.SearchEvent>)(ComponentEventListener & Serializable)e -> this.createFilterFromQryForm());
        this.queryButtonsBar.addClearSearchListener((ComponentEventListener<QueryButtonsBar.ClearSearchEvent>)(ComponentEventListener & Serializable)e -> this.cleanQryForm());
    }

    private Object cleanQryForm() {
        this.cleanForm(GeneratedQuery.class, (Object)this, this.dataProvider.getResourceName(), true);
        return null;
    }

    private Object createFilterFromQryForm() {
        this.stringFilter = "";
        this.keysFromParent = "";
        String filter = this.getFieldsDataForFilter(GeneratedQuery.class, this.form, this.dataProvider.getResourceName());
        System.out.println("GeneratedQuery.createFilter()...." + filter);
        if (this.grid != null) {
            this.dataProvider = this.grid.getDataProvider();
        }
        this.dataProvider.setFilter(filter);
        this.dataProvider.refreshAll();
        return null;
    }

    public DynamicViewGrid getGrid() {
        return this.grid;
    }

    public void setGrid(DynamicViewGrid grid) {
        this.grid = grid;
    }

    public DdbDataBackEndProvider getDataProvider() {
        return this.dataProvider;
    }

    public void setDataProvider(DdbDataBackEndProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    public Component createDetails() {
        GeneratedUtil generatedUtil = new GeneratedUtil();
        this.rowsQueryFieldList = this.dataProvider.getRowsQueryFieldList();
        String tabs = "";
        if (this.rowsQueryFieldList != null) {
            tabs = this.rowsQueryFieldList.get(0)[17];
        }
        if (tabs.isEmpty()) {
            Component generatedForm = generatedUtil.createDetails(this.dataProvider.getResourceName(), this.rowsQueryFieldList, true, this.cache, "noTAB");
            Div content = new Div(new Component[]{generatedForm});
            this.form.setMinWidth("1360px");
            this.form.getElement().getStyle().set("overflow", "hidden");
            content.setMinWidth("1360px");
            content.setHeight("98%");
            this.form.add(new Component[]{content});
            if (generatedForm.getId().isPresent()) {
                this.setId((String)generatedForm.getId().get());
            }
            return this;
        }
        Component generatedForm = generatedUtil.createTabs(this.dataProvider.getResourceName(), this.rowsQueryFieldList, true, this.cache, tabs);
        Div content = new Div(new Component[]{generatedForm});
        this.form.setMinWidth("1360px");
        content.setMinWidth("1360px");
        content.setHeight("100%");
        this.form.add(new Component[]{content});
        if (generatedForm.getId().isPresent()) {
            this.setId((String)generatedForm.getId().get());
        }
        return this;
    }

    public String getPageTitle() {
        if (this.title == null) {
            return "SIN TITULO";
        }
        return this.title;
    }

    public void beforeEnter(BeforeEnterEvent event) {
        String addFormClassName;
        System.out.println("GenericGridDetails.beforeEnter()");
        Location location = event.getLocation();
        QueryParameters queryParameters = location.getQueryParameters();
        Map parametersMap = queryParameters.getParameters();
        System.out.println("beforeEnter.....parametersMap.get(\"resource\")" + parametersMap.get("resource"));
        this.title = (String)((List)parametersMap.get("title")).get(0);
        String queryFormClassName = (String)((List)queryParameters.getParameters().get("queryFormClassName")).get(0);
        String displayFormClassName = (String)((List)queryParameters.getParameters().get("displayFormClassName")).get(0);
        String resourceName = (String)((List)queryParameters.getParameters().get("resourceName")).get(0);
        if (queryParameters.getParameters().get("addFormClassName") != null && !(addFormClassName = (String)((List)queryParameters.getParameters().get("addFormClassName")).get(0)).startsWith("coop.intergal")) {
            addFormClassName = "coop.intergal.tys.ui.views." + (String)((List)queryParameters.getParameters().get("addFormClassName")).get(0);
        }
        if (!displayFormClassName.startsWith("coop.intergal")) {
            displayFormClassName = "coop.intergal.tys.ui.views." + (String)((List)queryParameters.getParameters().get("displayFormClassName")).get(0);
        }
        if (!queryFormClassName.startsWith("coop.intergal")) {
            queryFormClassName = "coop.intergal.tys.ui.views." + (String)((List)queryParameters.getParameters().get("queryFormClassName")).get(0);
        }
        this.prepareLayout(queryFormClassName, resourceName);
    }

    public void prepareLayout(String queryFormClassName, String resourceName) {
        try {
            Class<?> dynamicQuery = Class.forName(queryFormClassName);
            Object queryForm = dynamicQuery.newInstance();
            Method setGrid = dynamicQuery.getMethod("setGrid", DynamicViewGrid.class);
            setGrid.invoke(queryForm, new Object[]{this.grid});
            if (queryFormClassName.indexOf("Generated") > -1) {
                String titleByID;
                DdbDataBackEndProvider dataProvider = new DdbDataBackEndProvider();
                dataProvider.setPreConfParam(UtilSessionData.getCompanyYear() + "TYSLac0");
                dataProvider.setResourceName(resourceName);
                Method setDataProvider = dynamicQuery.getMethod("setDataProvider", DdbDataBackEndProvider.class);
                Method createDetails = dynamicQuery.getMethod("createDetails", new Class[0]);
                Method setRowsColList = dynamicQuery.getMethod("setRowsColList", ArrayList.class);
                setDataProvider.invoke(queryForm, new Object[]{dataProvider});
                Object rowsColList = null;
                setRowsColList.invoke(queryForm, rowsColList);
                Object divInDisplay = createDetails.invoke(queryForm, new Object[0]);
                if (((GeneratedQuery)((Object)divInDisplay)).getId().isPresent() && (titleByID = (String)((GeneratedQuery)((Object)divInDisplay)).getId().get()) != null && titleByID.length() > 2) {
                    this.form.add(new Component[]{new H3(titleByID)});
                }
                this.form.add(new Component[]{(Component)divInDisplay});
            } else {
                this.form.add(new Component[]{(Component)queryForm});
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

