/*
 * Decompiled with CFR 0.152.
 */
package coop.intergal.ui.views.login;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.html.Label;
import com.vaadin.flow.component.html.NativeButton;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.login.LoginI18n;
import com.vaadin.flow.component.login.LoginOverlay;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.router.AfterNavigationEvent;
import com.vaadin.flow.router.AfterNavigationObserver;
import com.vaadin.flow.router.Route;
import coop.intergal.ui.security.ldap.LdapClient;
import coop.intergal.ui.util.SendEmail;
import coop.intergal.ui.utils.TranslateResource;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingException;

@Route(value="login")
public class LoginView
extends FlexLayout
implements AfterNavigationObserver {
    private final LoginOverlay login;
    String CARACTERES = "23456789abcdekrsxyz";
    private String usuario;
    private String psw;
    private TextField user;
    private String elUser;

    public LoginView() {
        UI.getCurrent().setLocale(new Locale("es", "ES"));
        this.login = new LoginOverlay();
        this.login.setI18n(this.translateSpanish());
        this.login.setForgotPasswordButtonVisible(true);
        this.login.addForgotPasswordListener((ComponentEventListener & Serializable)ev -> this.olvidePassword());
        this.login.setAction("login");
        this.login.setTitle("Torres & S\u00e1ez");
        this.login.setDescription("Aplicaci\u00f3n de Gesti\u00f3n");
        this.add(new Component[]{this.login});
    }

    private void olvidePassword() {
        Span content = new Span("Contrase\u00f1a olvidada");
        content.getStyle().set("font-size", "small");
        this.user = new TextField();
        this.user.setLabel("Tu email");
        this.user.getStyle().set("width", "100%");
        Button button = new Button("Enviar");
        button.addThemeVariants(new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        Button buttonCancel = new Button("Cancelar");
        buttonCancel.addThemeVariants(new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY});
        Notification notification = new Notification(new Component[]{content, this.user, button, buttonCancel});
        button.addClickListener((ComponentEventListener & Serializable)event -> this.aceptar(notification));
        buttonCancel.addClickListener((ComponentEventListener & Serializable)e -> notification.close());
        notification.setPosition(Notification.Position.MIDDLE);
        notification.open();
    }

    private void aceptar(Notification notification) {
        if (!this.user.isEmpty()) {
            this.elUser = this.user.getValue().replace(" ", "");
            this.elUser = this.elUser.toLowerCase();
            if (this.compruebaEmail(this.elUser)) {
                this.usuario = "uid=" + this.elUser + ",ou=central,ou=gfer,ou=tys,ou=groups";
                this.psw = this.getPassword(this.CARACTERES, 5);
                try {
                    String estado = LdapClient.changePassword(this.usuario, "", this.psw, true, true);
                    if (estado == "OK") {
                        notification.close();
                        this.user.clear();
                        this.enviarEmail();
                    } else {
                        Notification notification2 = new Notification("LOGIN_FORGETPASS_ERROR", 8000, Notification.Position.MIDDLE);
                        notification2.open();
                        notification.close();
                        this.user.clear();
                    }
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                catch (NamingException e) {
                    Notification notification2 = new Notification("LOGIN_FORGETPASS_ERROR", 8000, Notification.Position.MIDDLE);
                    notification2.open();
                }
            }
        }
    }

    private void enviarEmail() {
        String destinatario = this.elUser;
        String asunto = "Nueva contrase\u00f1a";
        String cuerpo = "<p>Esta es tu nueva contrase\u00f1a:</p><p style=\"font-size:16px;\">" + this.psw + "</p><p>Puedes cambiarla una vez que entres en la aplicaci\u00f3n.</p>";
        SendEmail.SendEmail(destinatario, asunto, cuerpo);
        Notification notification = new Notification("Te hemos enviado un email con tu nueva contrase\u00f1a. Si no aparece en la carpeta de \"entrada\" revisa la de \"correo no deseado\" (spam)", 8000, Notification.Position.MIDDLE);
        notification.open();
    }

    private boolean compruebaEmail(String email) {
        Pattern pattern = Pattern.compile("^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$");
        Matcher mather = pattern.matcher(email);
        if (mather.find()) {
            return true;
        }
        NativeButton buttonInside = new NativeButton(TranslateResource.getFieldLocale("CERRAR"));
        Label content = new Label(this.elUser + "LOGIN_FORGETPASS_NOTEMAIL");
        content.getStyle().set("font-size", "small");
        Notification notification = new Notification(new Component[]{content, buttonInside});
        notification.setPosition(Notification.Position.MIDDLE);
        notification.open();
        buttonInside.addClickListener((ComponentEventListener & Serializable)event -> notification.close());
        return false;
    }

    public String getPassword(String key, int length) {
        String pswd = "";
        for (int i = 0; i < length; ++i) {
            pswd = pswd + key.charAt((int)(Math.random() * (double)key.length()));
        }
        return pswd;
    }

    private LoginI18n translateSpanish() {
        LoginI18n i18n = LoginI18n.createDefault();
        i18n.setHeader(new LoginI18n.Header());
        i18n.getForm().setUsername("Usuario");
        i18n.getForm().setTitle("Entra a tu cuenta");
        i18n.getForm().setSubmit("Entrar");
        i18n.getForm().setPassword("Contrase\u00f1a");
        i18n.getForm().setForgotPassword("Olvid\u00e9 mi contrase\u00f1a");
        i18n.getErrorMessage().setTitle("Usuario o contrase\u00f1a incorrectos.");
        i18n.getErrorMessage().setMessage("Revisa tu usuario y contrase\u00f1a y vuelve a intentarlo.");
        i18n.getHeader().setTitle("Torres & S\u00e1ez");
        i18n.getHeader().setDescription("Aplicaci\u00f3n de Gesti\u00f3n");
        i18n.setAdditionalInformation("");
        return i18n;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.login.setOpened(true);
    }

    public void afterNavigation(AfterNavigationEvent event) {
        this.login.setError(event.getLocation().getQueryParameters().getParameters().containsKey("error"));
    }
}

