/*
 * Decompiled with CFR 0.152.
 */
package coop.intergal.vaadin.rest.utils;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.crud.CrudFilter;
import com.vaadin.flow.component.html.Label;
import com.vaadin.flow.component.html.NativeButton;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.data.provider.AbstractBackEndDataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.provider.SortDirection;
import coop.intergal.vaadin.rest.utils.DataService;
import coop.intergal.vaadin.rest.utils.DynamicDBean;
import coop.intergal.vaadin.rest.utils.RestData;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class DdbDataBackEndProvider
extends AbstractBackEndDataProvider<DynamicDBean, CrudFilter> {
    private ArrayList<String[]> rowsColList;
    private ArrayList<String[]> rowsFieldList;
    private ArrayList<String[]> rowsFIeldQueryList;
    private static final long serialVersionUID = 1L;
    private String resourceName;
    private String filter;
    private String preConfParam;
    private Boolean cache = true;
    private Boolean hasNewRow = false;
    private String variant = "";
    private Consumer<Long> sizeChangeListener;
    private Boolean isMultiSelect = false;
    private long sizeBE;
    private Collection<DynamicDBean> keepRows;

    public Boolean getIsMultiSelect() {
        return this.isMultiSelect;
    }

    public void setIsMultiSelect(Boolean isMultiSelect) {
        this.isMultiSelect = isMultiSelect;
    }

    public String getVariant() {
        return this.variant;
    }

    public void setVariant(String variant) {
        this.variant = variant;
    }

    public String getPreConfParam() {
        return this.preConfParam;
    }

    public void setPreConfParam(String preConfParam) {
        this.preConfParam = preConfParam;
    }

    public Boolean getCache() {
        return this.cache;
    }

    public void setCache(Boolean cache) {
        this.cache = cache;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public ArrayList<String[]> getRowsColList() {
        return RestData.getRowsColList(this.rowsColList, this.resourceName, this.preConfParam, null);
    }

    public ArrayList<String[]> getRowsColList(String variant) {
        return RestData.getRowsColList(this.rowsColList, this.resourceName, this.preConfParam, variant);
    }

    public ArrayList<String> getRowsColListOnlyNames(String resourceName, String preConfParam, String variant) {
        return RestData.getRowsColList(resourceName, preConfParam, variant);
    }

    public ArrayList<String[]> getRowsFieldList() {
        return RestData.getRowsFieldList(this.rowsFieldList, this.resourceName, this.preConfParam, null);
    }

    public ArrayList<String[]> getRowsQueryFieldList() {
        return RestData.getRowsQueryFieldList(this.rowsFIeldQueryList, this.resourceName, this.preConfParam);
    }

    public void setRowsColList(ArrayList<String[]> rowsColList) {
        this.rowsColList = rowsColList;
    }

    public void setRowsFieldList(ArrayList<String[]> rowsFieldList) {
        this.rowsFieldList = rowsFieldList;
    }

    public void setRowsFIeldQueryList(ArrayList<String[]> rowsFIeldQueryList) {
        this.rowsFIeldQueryList = rowsFIeldQueryList;
    }

    public Boolean getHasNewRow() {
        return this.hasNewRow;
    }

    public void setHasNewRow(Boolean hasNewRow) {
        this.hasNewRow = hasNewRow;
    }

    private String getTableDbForCount(String resourceName2) {
        int postPoint;
        if (resourceName2.startsWith("@")) {
            return resourceName2;
        }
        int startIdx = 3;
        if (!resourceName2.startsWith("CR-")) {
            startIdx = 0;
        }
        int endIdx = resourceName2.indexOf("__");
        int idxSpecialFilter = resourceName2.indexOf("_SF");
        if (endIdx < 0 || idxSpecialFilter > -1) {
            endIdx = resourceName2.length();
        }
        if ((postPoint = resourceName2.indexOf(".")) > 0) {
            startIdx = postPoint + 1;
            endIdx = resourceName2.length();
        }
        return resourceName2.substring(startIdx, endIdx);
    }

    public boolean isInMemory() {
        return false;
    }

    protected Stream<DynamicDBean> fetchFromBackEnd(Query<DynamicDBean, CrudFilter> query) {
        int offset = query.getOffset();
        int limit = query.getLimit();
        List sortOrdersFields = query.getSortOrders();
        if (this.isMultiSelect.booleanValue() && this.keepRows != null) {
            return this.keepRows.stream();
        }
        Collection<DynamicDBean> rows = DataService.get().getAllDynamicDBean(offset, limit, this.cache, this.resourceName, this.preConfParam, this.getRowsColList(this.variant), this.filter, sortOrdersFields, this.hasNewRow, this.variant);
        if (rows.size() == 1 && this.sizeBE > 1L) {
            DynamicDBean row = rows.iterator().next();
            rows = this.fillDummy(this.sizeBE, limit, row.getCol0());
            return rows.stream();
        }
        Stream<DynamicDBean> stream = rows.stream();
        if (query.getFilter().isPresent()) {
            stream = stream.filter(DdbDataBackEndProvider.predicate((CrudFilter)query.getFilter().get())).sorted(DdbDataBackEndProvider.comparator((CrudFilter)query.getFilter().get()));
        }
        if (this.isMultiSelect.booleanValue()) {
            this.keepRows = rows;
        }
        return stream;
    }

    private Collection<DynamicDBean> fillDummy(long sizeBE2, int limit, String error) {
        ArrayList<DynamicDBean> dummyRows = new ArrayList<DynamicDBean>();
        for (int i = 0; (long)i < sizeBE2 && i < limit; ++i) {
            DynamicDBean d = new DynamicDBean();
            d.setCol0(error);
            d.setCol1(error);
            d.setCol2(error);
            d.setCol3(error);
            dummyRows.add(d);
        }
        return dummyRows;
    }

    protected int sizeInBackEnd(Query<DynamicDBean, CrudFilter> query) {
        long count;
        this.sizeBE = count = (long)RestData.getCountRows(this.getTableDbForCount(this.resourceName), this.preConfParam, this.filter, false, this.hasNewRow);
        if (this.sizeChangeListener != null) {
            this.sizeChangeListener.accept(count);
        }
        return (int)count;
    }

    public long getSizeBE() {
        return this.sizeBE;
    }

    void setSizeChangeListener(Consumer<Long> listener) {
        this.sizeChangeListener = listener;
    }

    private static Predicate<DynamicDBean> predicate(CrudFilter filter) {
        return filter.getConstraints().entrySet().stream().map(constraint -> person -> {
            try {
                Object value = DdbDataBackEndProvider.valueOf((String)constraint.getKey(), person);
                return value != null && value.toString().toLowerCase().contains(((String)constraint.getValue()).toLowerCase());
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }).reduce(Predicate::and).orElse(e -> true);
    }

    private static Object valueOf(String fieldName, DynamicDBean dynamicDBean) {
        try {
            Field field = DynamicDBean.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(dynamicDBean);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static Comparator<DynamicDBean> comparator(CrudFilter filter) {
        return filter.getSortOrders().entrySet().stream().map(sortClause -> {
            try {
                Comparator<DynamicDBean> comparator = Comparator.comparing(dynamicDBean -> (Comparable)DdbDataBackEndProvider.valueOf((String)sortClause.getKey(), dynamicDBean));
                if (sortClause.getValue() == SortDirection.DESCENDING) {
                    comparator = comparator.reversed();
                }
                return comparator;
            }
            catch (Exception ex) {
                return (o1, o2) -> 0;
            }
        }).reduce(Comparator::thenComparing).orElse((o1, o2) -> 0);
    }

    public boolean save(String ResourceTobeSave, Hashtable<String, DynamicDBean> beansToSaveAndRefresh) {
        return this.save(ResourceTobeSave, beansToSaveAndRefresh, null);
    }

    public boolean save(String ResourceTobeSave, Hashtable<String, DynamicDBean> beansToSaveAndRefresh, DdbDataBackEndProvider parentDP) {
        DynamicDBean firstBean = beansToSaveAndRefresh.get(ResourceTobeSave);
        boolean newRow = firstBean.getRowJSon() == null;
        DataService.get().updateDynamicDBean(ResourceTobeSave, beansToSaveAndRefresh, this);
        boolean hashasError = false;
        if (beansToSaveAndRefresh.get("ERROR") != null) {
            hashasError = true;
        } else if (newRow) {
            this.refreshAll();
        } else if (!hashasError) {
            this.refreshItem(firstBean);
            if (parentDP != null) {
                DynamicDBean parentbean = beansToSaveAndRefresh.get(parentDP.getResourceName());
                parentDP.refreshItem(parentbean);
            }
        }
        return hashasError;
    }

    public void delete(String ResourceTobeSave, Hashtable<String, DynamicDBean> beansToSaveAndRefresh) {
        DynamicDBean firstBean = beansToSaveAndRefresh.get(ResourceTobeSave);
        boolean newProduct = firstBean.getCol0() == null;
        DataService.get().deleteDynamicDBean(ResourceTobeSave, beansToSaveAndRefresh);
        this.refreshAll();
    }

    public void refresh(DynamicDBean selectedRow) {
        this.refreshItem(selectedRow);
    }

    public void insertANewRow() {
    }

    public static void showError(String error) {
        Label content = new Label(error);
        NativeButton buttonInside = new NativeButton("Cerrar");
        Notification notification = new Notification(new Component[]{content, buttonInside});
        buttonInside.addClickListener((ComponentEventListener & Serializable)event -> notification.close());
        notification.setPosition(Notification.Position.MIDDLE);
        notification.open();
    }
}

