/*
 * Decompiled with CFR 0.152.
 */
package coop.intergal.vaadin.rest.utils;

import com.vaadin.flow.component.crud.CrudFilter;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.provider.SortDirection;
import com.vaadin.flow.data.provider.hierarchy.AbstractBackEndHierarchicalDataProvider;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalQuery;
import coop.intergal.vaadin.rest.utils.DataService;
import coop.intergal.vaadin.rest.utils.DynamicDBean;
import coop.intergal.vaadin.rest.utils.RestData;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class DdbHierarchicalDataProvider
extends AbstractBackEndHierarchicalDataProvider<DynamicDBean, CrudFilter> {
    private ArrayList<String[]> rowsColList;
    private static final long serialVersionUID = 1L;
    private String resourceName;
    private String filter;
    private String preConfParam;
    private Boolean cache = true;
    private Boolean hasNewRow = false;
    private Consumer<Long> sizeChangeListener;

    public String getPreConfParam() {
        return this.preConfParam;
    }

    public void setPreConfParam(String preConfParam) {
        this.preConfParam = preConfParam;
    }

    public Boolean getCache() {
        return this.cache;
    }

    public void setCache(Boolean cache) {
        this.cache = cache;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public ArrayList<String[]> getRowsColList() {
        return RestData.getRowsColList(this.rowsColList, this.resourceName, this.preConfParam, null);
    }

    public ArrayList<String[]> getRowsFieldList() {
        return RestData.getRowsFieldList(this.rowsColList, this.resourceName, this.preConfParam, null);
    }

    public void setRowsColList(ArrayList<String[]> rowsColList) {
        this.rowsColList = rowsColList;
    }

    public Boolean getHasNewRow() {
        return this.hasNewRow;
    }

    public void setHasNewRow(Boolean hasNewRow) {
        this.hasNewRow = hasNewRow;
    }

    private String getTableDbForCount(String resourceName2) {
        int postPoint;
        int endIdx;
        System.out.println("DdbHierarchicalDataProvider.getTableDbForCount() resourceName2 " + resourceName2);
        if (resourceName2.startsWith("@")) {
            return resourceName2;
        }
        int startIdx = 3;
        if (!resourceName2.startsWith("CR-")) {
            startIdx = 0;
        }
        if ((endIdx = resourceName2.indexOf("__")) < 0) {
            endIdx = resourceName2.length();
        }
        if ((postPoint = resourceName2.indexOf(".")) > 0) {
            startIdx = postPoint + 1;
            endIdx = resourceName2.length();
        }
        return resourceName2.substring(startIdx, endIdx);
    }

    public boolean isInMemory() {
        return false;
    }

    protected Stream<DynamicDBean> fetchChildrenFromBackEnd(HierarchicalQuery<DynamicDBean, CrudFilter> query) {
        int offset = query.getOffset();
        int limit = query.getLimit();
        List sortOrdersFields = query.getSortOrders();
        Stream<DynamicDBean> stream = DataService.get().getAllDynamicDBean(query.getOffset(), query.getLimit(), this.cache, this.resourceName, this.preConfParam, this.getRowsColList(), this.filter, sortOrdersFields, this.hasNewRow, null).stream();
        if (query.getFilter().isPresent()) {
            stream = stream.filter(DdbHierarchicalDataProvider.predicate((CrudFilter)query.getFilter().get())).sorted(DdbHierarchicalDataProvider.comparator((CrudFilter)query.getFilter().get()));
        }
        return stream;
    }

    protected int sizeInBackEnd(Query<DynamicDBean, CrudFilter> query) {
        long count = RestData.getCountRows(this.getTableDbForCount(this.resourceName), this.preConfParam, this.filter, false, this.hasNewRow);
        if (this.sizeChangeListener != null) {
            this.sizeChangeListener.accept(count);
        }
        return (int)count;
    }

    void setSizeChangeListener(Consumer<Long> listener) {
        this.sizeChangeListener = listener;
    }

    private static Predicate<DynamicDBean> predicate(CrudFilter filter) {
        return filter.getConstraints().entrySet().stream().map(constraint -> person -> {
            try {
                Object value = DdbHierarchicalDataProvider.valueOf((String)constraint.getKey(), person);
                return value != null && value.toString().toLowerCase().contains(((String)constraint.getValue()).toLowerCase());
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }).reduce(Predicate::and).orElse(e -> true);
    }

    private static Object valueOf(String fieldName, DynamicDBean dynamicDBean) {
        try {
            Field field = DynamicDBean.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(dynamicDBean);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static Comparator<DynamicDBean> comparator(CrudFilter filter) {
        return filter.getSortOrders().entrySet().stream().map(sortClause -> {
            try {
                Comparator<DynamicDBean> comparator = Comparator.comparing(dynamicDBean -> (Comparable)DdbHierarchicalDataProvider.valueOf((String)sortClause.getKey(), dynamicDBean));
                if (sortClause.getValue() == SortDirection.DESCENDING) {
                    comparator = comparator.reversed();
                }
                return comparator;
            }
            catch (Exception ex) {
                return (o1, o2) -> 0;
            }
        }).reduce(Comparator::thenComparing).orElse((o1, o2) -> 0);
    }

    public void save(String ResourceTobeSave, Hashtable<String, DynamicDBean> beansToSaveAndRefresh) {
        DynamicDBean firstBean = beansToSaveAndRefresh.get(ResourceTobeSave);
        boolean newProduct = firstBean.getCol0() == null;
        DataService.get().updateDynamicDBean(ResourceTobeSave, beansToSaveAndRefresh, null);
        if (newProduct) {
            this.refreshAll();
        } else {
            this.refreshItem(firstBean);
        }
    }

    public void delete(String ResourceTobeSave, Hashtable<String, DynamicDBean> beansToSaveAndRefresh) {
        DynamicDBean firstBean = beansToSaveAndRefresh.get(ResourceTobeSave);
        boolean newProduct = firstBean.getCol0() == null;
        DataService.get().deleteDynamicDBean(ResourceTobeSave, beansToSaveAndRefresh);
        this.refreshAll();
    }

    public void refresh(DynamicDBean selectedRow) {
        this.refreshItem(selectedRow);
    }

    public void insertANewRow() {
    }

    public int getChildCount(HierarchicalQuery<DynamicDBean, CrudFilter> query) {
        DynamicDBean parent = (DynamicDBean)query.getParent();
        long count = RestData.getCountRows(this.getTableDbForCount(this.resourceName), this.preConfParam, this.filter, false, this.hasNewRow);
        if (this.sizeChangeListener != null) {
            this.sizeChangeListener.accept(count);
        }
        return (int)count;
    }

    public boolean hasChildren(DynamicDBean item) {
        return false;
    }
}

