/*
 * Decompiled with CFR 0.152.
 */
package coop.intergal.vaadin.rest.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.html.Label;
import com.vaadin.flow.component.html.NativeButton;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.data.provider.QuerySortOrder;
import coop.intergal.espresso.presutec.utils.JSonClient;
import coop.intergal.ui.security.SecurityUtils;
import coop.intergal.ui.util.UtilSessionData;
import coop.intergal.vaadin.rest.utils.DataService;
import coop.intergal.vaadin.rest.utils.DdbDataBackEndProvider;
import coop.intergal.vaadin.rest.utils.DynamicDBean;
import coop.intergal.vaadin.rest.utils.RestData;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class MockDataService
extends DataService {
    private static final long serialVersionUID = 1L;
    private static MockDataService INSTANCE;
    private List<DynamicDBean> rows;
    private int nextProductId = 0;
    private JsonNode lTxsumary;
    private JsonNode allSaveSata;
    private boolean errorSaving;
    private Boolean aceptOrCancel;

    private MockDataService() {
    }

    public static synchronized DataService getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MockDataService();
        }
        return INSTANCE;
    }

    @Override
    public Collection<DynamicDBean> getAllDynamicDBean(int offset, int limit, boolean refreshFromServer, String resourceName, String preConfParam, ArrayList<String[]> rowsColList, String filtro, List<QuerySortOrder> sortOrdersFields, Boolean hasNewRow, String variant) {
        if (!sortOrdersFields.isEmpty()) {
            Iterator<QuerySortOrder> itSortOrdersFields = sortOrdersFields.iterator();
            filtro = filtro != null ? filtro + "&order=" : "order=";
            int nFields = 0;
            while (itSortOrdersFields.hasNext()) {
                QuerySortOrder sortOrdersField = itSortOrdersFields.next();
                String QuerySortOrderDir = "DESC";
                if (sortOrdersField.getDirection().toString().startsWith("ASC")) {
                    QuerySortOrderDir = "ASC";
                }
                filtro = nFields > 0 ? filtro + ",%20" + (String)sortOrdersField.getSorted() + "%20" + QuerySortOrderDir : filtro + (String)sortOrdersField.getSorted() + "%20" + QuerySortOrderDir;
                ++nFields;
            }
        }
        this.rows = RestData.getResourceData(offset, limit, resourceName, preConfParam, rowsColList, filtro, refreshFromServer, hasNewRow, variant);
        if (this.rows != null) {
            System.out.println("MockDataService.getAllDynamicDBean()-----" + this.rows.size() + ".....resourceName " + resourceName + " offset " + offset + " limit " + limit);
        } else {
            System.out.println("MockDataService.getAllDynamicDBean()----- ROWS NULL");
        }
        return this.rows;
    }

    @Override
    public DynamicDBean getDynamicDBeanById(int productId) {
        for (int i = 0; i < this.rows.size(); ++i) {
            if (new Integer(this.rows.get(i).getCol0()) != productId) continue;
            return this.rows.get(i);
        }
        return null;
    }

    @Override
    public void updateDynamicDBean(DynamicDBean dB) {
        block12: {
            try {
                JsonNodeFactory nodeFactory = JsonNodeFactory.instance;
                JsonNode rowJson = dB.getRowJSon();
                String resourceName = dB.getResourceName();
                String preConfParam = dB.getPreConfParam();
                if (rowJson == null) {
                    ObjectNode newEntityinfo = this.putValuesOnObject(true, nodeFactory, dB, resourceName);
                    newEntityinfo = this.addImagenIfExist(dB, newEntityinfo);
                    newEntityinfo = this.addUserIfCorresponds(resourceName, newEntityinfo);
                    try {
                        JsonNode postResult = JSonClient.post(resourceName, (JsonNode)newEntityinfo, preConfParam);
                        if (postResult.get("statusCode").intValue() != 201) {
                            this.errorSaving = true;
                            this.showError(postResult.get("errorMessage").asText());
                            break block12;
                        }
                        this.errorSaving = false;
                        this.allSaveSata = this.lTxsumary = postResult.get("txsummary");
                        this.lTxsumary = this.getResourceFromResult(this.lTxsumary, preConfParam, resourceName);
                        dB.setRowJSon(this.lTxsumary);
                        JsonNode eachRow = this.lTxsumary.get(0);
                        this.putJSonData(eachRow, dB, false);
                        if (this.rows != null) {
                            this.rows.add(dB);
                        }
                        this.showConfirmationSave("Registro salvado con \u00e9xito!");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block12;
                }
                try {
                    ObjectNode rowJsonChanged = this.putValuesOnObject(false, nodeFactory, dB, resourceName);
                    rowJsonChanged = this.addImagenIfExist(dB, rowJsonChanged);
                    rowJsonChanged = this.addUserIfCorresponds(resourceName, rowJsonChanged);
                    JsonNode postResult = JSonClient.put(resourceName, (JsonNode)rowJsonChanged, preConfParam);
                    if (postResult.get("statusCode").intValue() != 200) {
                        this.errorSaving = true;
                        this.showError(postResult.get("errorMessage").asText());
                        break block12;
                    }
                    this.errorSaving = false;
                    this.allSaveSata = this.lTxsumary = postResult.get("txsummary");
                    if (this.lTxsumary.size() > 0) {
                        this.lTxsumary = this.getResourceFromResult(this.lTxsumary, preConfParam, resourceName);
                        JsonNode eachRow = this.lTxsumary.get(0);
                        this.putJSonData(eachRow, dB, true);
                    }
                    System.err.println(" result  " + this.lTxsumary);
                    this.showConfirmationSave("Registro salvado con \u00e9xito!");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (NullPointerException nullE) {
                System.err.println(" Paso por el Segundo Catch :");
                nullE.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private ObjectNode addImagenIfExist(DynamicDBean dB, ObjectNode newEntityinfo) {
        if (dB.getBytes() != null && dB.getBytes().toString().length() > 0) {
            String encoded = "0x" + MockDataService.bytesToHex(dB.getBytes());
            newEntityinfo.put("Imagen", encoded);
        }
        return newEntityinfo;
    }

    private ObjectNode addUserIfCorresponds(String resourceName, ObjectNode newEntityinfo) {
        if ("CR-ARTICULOS,CR-PED_PROVEED_CAB".indexOf(resourceName) > -1) {
            newEntityinfo.put("USERUPDATE", SecurityUtils.getUsername());
        }
        return newEntityinfo;
    }

    public static String bytesToHex(byte[] in) {
        StringBuilder builder = new StringBuilder();
        for (byte b : in) {
            builder.append(String.format("%02x", b));
        }
        return builder.toString();
    }

    @Override
    public void showError(String error) {
        if (error.indexOf("#E#") > -1) {
            int idxStart = error.indexOf("#E#") + 3;
            int idxEnd = error.indexOf("#EEnd#");
            error = error.substring(idxStart, idxEnd);
        }
        Label content = new Label(this.transalateError(error) + " ");
        System.out.println("MockDataService.showError()" + error);
        NativeButton buttonInside = new NativeButton(" Cerrar ");
        Notification notification = new Notification(new Component[]{content, buttonInside});
        buttonInside.addClickListener((ComponentEventListener & Serializable)event -> notification.close());
        notification.setPosition(Notification.Position.MIDDLE);
        notification.open();
    }

    private Boolean closeAndSet(Notification notification, boolean b) {
        notification.close();
        return b;
    }

    private String transalateError(String error) {
        if (error.startsWith("Parent main:")) {
            return this.transErrorParentMIssing(error);
        }
        if (error.indexOf("Duplicate entry") > 1) {
            return "Registro duplicado";
        }
        if (error.startsWith("Validation violation:")) {
            return error.substring(21);
        }
        if (error.startsWith("Unable to delete entity") && error.indexOf("has at least one child on relationship") > -1) {
            return "No es posible borrar este registro. Existen otros que dependen de \u00e9l.";
        }
        return error;
    }

    private String transErrorParentMIssing(String error) {
        try {
            int idxStar = error.indexOf("child main:") + 11;
            String parentTable = error.substring(idxStar);
            String filter = "tableName%20like%20('CR-" + parentTable + "%25')";
            boolean cache = UtilSessionData.getCache();
            JsonNode rowsList = JSonClient.get("FormTemplate", filter, cache, "metadataLac0", "1");
            for (JsonNode eachRow : rowsList) {
                String name = eachRow.get("name").asText();
                int idxTitle = name.indexOf("-") + 2;
                if (idxTitle <= -1) continue;
                int idxSpace = (name = name.substring(idxTitle)).indexOf(" ");
                if (idxSpace == -1) {
                    idxSpace = name.length();
                }
                return "El valor introducido no existe en " + name;
            }
            return "El valor introducido no existe en" + parentTable;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void showConfirmationSave(String error) {
        Label content = new Label(error);
        Notification notification = new Notification(new Component[]{content});
        notification.setDuration(3000);
        notification.setPosition(Notification.Position.TOP_STRETCH);
        notification.open();
    }

    private String getTableName(JsonNode rowJson) {
        String href = rowJson.get("@metadata").get("href").asText();
        return null;
    }

    private ObjectNode putValuesOnObject(boolean isInsert, JsonNodeFactory nodeFactory, DynamicDBean dB, String resourceName) {
        ObjectNode newEntityinfo = new ObjectNode(nodeFactory);
        JsonNode rowJSon = dB.getRowJSon();
        String tableName = resourceName;
        if (resourceName.startsWith("CR-")) {
            tableName = resourceName.substring(3);
        }
        if (!isInsert) {
            ObjectNode metadata = new ObjectNode(nodeFactory);
            metadata.put("checksum", rowJSon.get("@metadata").get("checksum").asText());
            if (rowJSon.get("@metadata").get("href") == null) {
                System.err.println("href Doesn' existe, probably PK is missing !!!!!!!!!!");
            }
            metadata.put("href", rowJSon.get("@metadata").get("href").asText());
            newEntityinfo.put("@metadata", (JsonNode)metadata);
            int i = 0;
            if (JSonClient.getResourceHtPK().get(tableName) != null) {
                String pkfield;
                while ((pkfield = JSonClient.getResourceHtPK().get(tableName).get("pkField" + i)) != null) {
                    newEntityinfo.put(pkfield, rowJSon.get(pkfield));
                    ++i;
                }
            }
        } else {
            String fKfilter = dB.getFilter();
            if (fKfilter != null && !fKfilter.isEmpty()) {
                int beginIndex = 0;
                int endIndex = fKfilter.indexOf("=");
                while (true) {
                    String fieldName = fKfilter.substring(beginIndex, endIndex);
                    beginIndex = fKfilter.indexOf("'") + 1;
                    fKfilter = fKfilter.substring(beginIndex);
                    endIndex = fKfilter.indexOf("'");
                    String fieldValue = fKfilter.substring(0, endIndex);
                    newEntityinfo.put(fieldName, fieldValue);
                    beginIndex = fKfilter.indexOf("%20and%20") + 9;
                    if (beginIndex < 9) {
                        beginIndex = fKfilter.indexOf("%20AND%20") + 9;
                    }
                    if (beginIndex < 9) break;
                    fKfilter = fKfilter.substring(beginIndex);
                    endIndex = fKfilter.indexOf("=");
                    beginIndex = 0;
                }
            }
        }
        Field[] fields = dB.getClass().getDeclaredFields();
        ArrayList<String[]> rowsColList = dB.getRowsColList();
        int i = 0;
        int maxColNumber = dB.getMaxColNumber();
        if (maxColNumber == 0) {
            maxColNumber = 200;
        }
        for (Field field : fields) {
            if (i > maxColNumber) break;
            Field o = field;
            try {
                field.setAccessible(true);
                Object value = field.get(dB);
                if (value != null && value.equals("M-2")) {
                    System.out.println("MockDataService.putValuesOnObject() DEBUG");
                }
                if (!(o instanceof Field)) continue;
                System.err.println("FIELD......." + field.getName() + " VALUE.... " + value);
                int colType = 0;
                String colNameInUI = field.getName();
                String colNameInTable = null;
                String[] colNameAndType = new String[2];
                boolean isAlreadyFill = false;
                if (colNameInUI.startsWith("col") && colNameInUI.length() > 3) {
                    int iFromColname = new Integer(colNameInUI.substring(3));
                    colNameAndType = this.getColNameAndType(rowsColList, iFromColname);
                    if (MockDataService.isNumeric(colNameAndType[0])) {
                        colType = new Integer(colNameAndType[0]);
                    }
                    boolean bl = isAlreadyFill = newEntityinfo.get(colNameInTable = colNameAndType[1]) != null;
                }
                if (!(colNameInUI == null || colNameInTable == null || value == null || value.equals("null") || value.toString().equals("") || value.toString().length() <= 0 || isAlreadyFill)) {
                    if (!colNameInUI.startsWith("col") || colNameInUI != null && colNameInTable.startsWith("FK-")) continue;
                    if (colType == 1) {
                        String valueStr = "" + value;
                        newEntityinfo.put(colNameInTable, valueStr);
                    } else if (colType == 4 || value.equals("true") || value.equals("false")) {
                        System.out.println("MockDataService.putValuesOnObject()  IS CHECKBOX");
                        if (value.equals("true")) {
                            newEntityinfo.put(colNameInTable, Boolean.valueOf(true));
                        } else if (value.equals("false")) {
                            newEntityinfo.put(colNameInTable, Boolean.valueOf(false));
                        } else {
                            newEntityinfo.put(colNameInTable, Integer.valueOf(Integer.parseInt((String)value)));
                        }
                    } else if (this.isInteger(o)) {
                        newEntityinfo.put(colNameInTable, this.delPoints(rowsColList.get(i)[0]));
                    } else if (!"null".equals(colNameInTable)) {
                        if (colType == 3 || colType > 100) {
                            value = this.cleanCurrencySymbolsAndChangeCommaXPoint(value);
                        }
                        newEntityinfo.put(colNameInTable, "" + value);
                    } else {
                        newEntityinfo.put(colNameInTable, "");
                    }
                    ++i;
                    continue;
                }
                if (colNameInUI == null || colNameInTable == null || colNameInTable.startsWith("FK-") || !colNameInUI.startsWith("col") || isAlreadyFill) continue;
                if ((value == null || value.toString().equals("") || value.toString().equals("null")) && !colNameInUI.equals("null") && !colNameInUI.startsWith("FK-")) {
                    newEntityinfo.put(colNameInTable, (JsonNode)NullNode.getInstance());
                }
                ++i;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return newEntityinfo;
    }

    private Object cleanCurrencySymbolsAndChangeCommaXPoint(Object value) {
        String valueStr = (String)value;
        int idxE = (valueStr = valueStr.replace(",", ".")).indexOf("\u20ac");
        if (idxE > -1) {
            valueStr = valueStr.substring(0, idxE - 1);
        }
        return valueStr;
    }

    private String[] getColNameAndType(ArrayList<String[]> rowsColList, int i) {
        String colNameInUIinColList = "null";
        String colNameInUIGenByI = "col" + i;
        if (rowsColList.size() > i) {
            colNameInUIinColList = rowsColList.get(i)[2];
        }
        String[] data = new String[2];
        if (colNameInUIinColList.equals(colNameInUIGenByI) || colNameInUIinColList.isEmpty()) {
            data[1] = rowsColList.get(i)[0];
            data[0] = rowsColList.get(i)[3];
            return data;
        }
        for (String[] row : rowsColList) {
            if (!row[2].equals(colNameInUIGenByI)) continue;
            data[1] = row[0];
            data[0] = row[3];
            return data;
        }
        return data;
    }

    private static boolean isNumeric(String strNum) {
        if (strNum == null) {
            return false;
        }
        try {
            double d = Double.parseDouble(strNum);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    private boolean isDate(Object o) {
        return false;
    }

    private boolean isCheckBox(Object o) {
        return false;
    }

    private boolean isInteger(Object o) {
        return false;
    }

    private Integer delPoints(String value) {
        while (value.indexOf(".") > -1) {
            value = value.substring(0, value.indexOf(".")) + value.substring(value.indexOf(".") + 1);
            System.err.println("VALUE .... sin puntos " + value);
        }
        return Integer.parseInt(value);
    }

    public void putJSonData(JsonNode eachRow, DynamicDBean dB, boolean isUpdate) {
        boolean isNewItem = false;
        Field[] fields = dB.getClass().getDeclaredFields();
        int i = 0;
        ArrayList<String[]> rowsColList = dB.getRowsColList();
        if (dB.getMaxColNumber() == 0) {
            int maxNumberOfFields = 200;
            String maxNumberOfFieldsSTR = "";
            if (rowsColList.size() > 15) {
                maxNumberOfFieldsSTR = rowsColList.get(0)[15];
            }
            System.out.println("RestData.fillRow() maxNumberOfFieldsSTR <<" + maxNumberOfFieldsSTR + ">>");
            if (maxNumberOfFieldsSTR.length() > 0) {
                maxNumberOfFields = new Integer(maxNumberOfFieldsSTR);
            }
            dB.setMaxColNumber(maxNumberOfFields);
        }
        dB.setRowJSon(eachRow);
        for (Field field : fields) {
            try {
                if (field.getName().equals("col" + i) && i < dB.getMaxColNumber()) {
                    field.setAccessible(true);
                    String colName = "";
                    String[] colNameAndType = new String[2];
                    if (field.getName().startsWith("col")) {
                        colNameAndType = this.getColNameAndType(rowsColList, i);
                        colName = colNameAndType[1];
                    }
                    if (eachRow.get(colName) != null) {
                        if (!eachRow.get(colName).asText().equals("null")) {
                            field.set(dB, eachRow.get(colName).asText());
                        } else {
                            field.set(dB, "");
                        }
                    }
                    ++i;
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
            if (i > dB.getMaxColNumber()) break;
        }
    }

    private JsonNode getResourceFromResult(JsonNode lTxsumary, String preConfParam, String resourceName) {
        String href;
        String url = href = this.searchRootResource(lTxsumary, resourceName);
        try {
            return JSonClient.get(url, preConfParam);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String searchRootResource(JsonNode lTxsumary, String resourceName) {
        for (int i = 0; i < lTxsumary.size(); ++i) {
            String resource = lTxsumary.get(i).get("@metadata").get("resource").asText();
            if (resource.indexOf(":") > -1) {
                resource = resource.substring(resource.indexOf(":") + 1);
            }
            if (!resource.equals(resourceName) && !this.sameTableName(resourceName, resource)) continue;
            return lTxsumary.get(i).get("@metadata").get("href").asText();
        }
        return null;
    }

    private boolean sameTableName(String resourceName, String resource) {
        if (resourceName.indexOf(".") == -1) {
            return false;
        }
        String tableName1 = this.getTableName(resourceName);
        String tableName2 = this.getTableName(resource);
        return tableName1.equals(tableName2);
    }

    private String getTableName(String resourceName) {
        int idxLastPoint = resourceName.lastIndexOf(".") + 1;
        String tablename = resourceName.substring(idxLastPoint);
        int idxList = tablename.indexOf("List-") + 5;
        int idx__ = tablename.indexOf("__");
        if (idx__ == -1) {
            return tablename.substring(idxList);
        }
        return tablename.substring(idxList, idx__);
    }

    @Override
    public void updateDynamicDBean(String resourceTobeSave, Hashtable<String, DynamicDBean> beansToSaveAndRefresh, DdbDataBackEndProvider ddbDataBackEndProvider) {
        this.updateDynamicDBean(beansToSaveAndRefresh.get(resourceTobeSave));
        if (!this.errorSaving) {
            for (int i = 0; i < this.allSaveSata.size(); ++i) {
                DynamicDBean beanTBR;
                String resourcelTX = this.allSaveSata.get(i).get("@metadata").get("resource").asText();
                if (resourcelTX.equals(resourceTobeSave) || (beanTBR = beansToSaveAndRefresh.get(resourcelTX)) == null) continue;
                this.putJSonData(this.allSaveSata.get(i), beanTBR, false);
            }
        } else {
            beansToSaveAndRefresh.put("ERROR", new DynamicDBean());
        }
    }

    @Override
    public void deleteDynamicDBean(String resourceTobeSave, Hashtable<String, DynamicDBean> beansToSaveAndRefresh) {
        this.deleteDynamicDBean(beansToSaveAndRefresh.get(resourceTobeSave));
        if (!this.errorSaving) {
            for (int i = 0; i < this.allSaveSata.size(); ++i) {
                DynamicDBean beanTBR;
                String resourcelTX = this.allSaveSata.get(i).get("@metadata").get("resource").asText();
                if (resourcelTX.equals(resourceTobeSave) || (beanTBR = beansToSaveAndRefresh.get(resourcelTX)) == null) continue;
                this.putJSonData(this.allSaveSata.get(i), beanTBR, false);
            }
        } else {
            beansToSaveAndRefresh.put("ERROR", new DynamicDBean());
        }
    }

    private void deleteDynamicDBean(DynamicDBean dB) {
        block7: {
            try {
                JsonNode rowJson = dB.getRowJSon();
                String resourceName = dB.getResourceName();
                String preConfParam = dB.getPreConfParam();
                try {
                    JsonNode postResult = JSonClient.delete(rowJson, preConfParam);
                    if (postResult.get("statusCode").intValue() != 200) {
                        this.errorSaving = true;
                        this.showError(postResult.get("errorMessage").asText());
                        break block7;
                    }
                    this.errorSaving = false;
                    this.allSaveSata = this.lTxsumary = postResult.get("txsummary");
                    if (this.lTxsumary.size() > 0) {
                        this.lTxsumary = this.getResourceFromResult(this.lTxsumary, preConfParam, resourceName);
                    }
                    System.err.println(" result  " + this.lTxsumary);
                    this.showConfirmationSave("Registro eliminado con \u00e9xito!");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (NullPointerException nullE) {
                System.err.println(" Paso por el Segundo Catch :");
                nullE.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String componFKFilter(DynamicDBean bean, String resourceSubGrid) {
        int idXEqual;
        String fKfilter = JSonClient.getHt().get(resourceSubGrid);
        int step = 0;
        String componFilter = "";
        int lengthFKfilter = 0;
        if (fKfilter != null) {
            lengthFKfilter = fKfilter.length();
        } else {
            System.err.println("ERROR FK NO CARGADA -------" + resourceSubGrid);
        }
        while ((lengthFKfilter > 0 || fKfilter != null && fKfilter.length() > 0) && (idXEqual = fKfilter.indexOf("=")) != -1) {
            int idXMark = fKfilter.indexOf("]");
            step = fKfilter.startsWith("\n and") || fKfilter.startsWith("\n AND") ? 6 : (fKfilter.indexOf("and") > -1 && fKfilter.indexOf("and") < 5 || fKfilter.indexOf("AND") > -1 && fKfilter.indexOf("AND") < 5 ? fKfilter.indexOf("AND") + 4 : 0);
            String fKfieldName = fKfilter.substring(step + 1, idXEqual - 2);
            String parentfieldName = fKfilter.substring(4 + idXEqual, idXMark - 1);
            if (bean.getRowJSon().get(parentfieldName) == null) {
                this.showError(" Campo " + parentfieldName + " de la PK, no presente en el recurso padre de: " + resourceSubGrid);
                return "";
            }
            String parentValue = bean.getRowJSon().get(parentfieldName).asText();
            componFilter = componFilter + fKfieldName + "='" + parentValue + "'%20and%20";
            lengthFKfilter -= idXMark;
            fKfilter = fKfilter.substring(idXMark + 1);
        }
        if (componFilter.length() > 9) {
            componFilter = componFilter.substring(0, componFilter.length() - 9);
        }
        if (componFilter.indexOf("'null'") > -1) {
            componFilter = componFilter.replaceAll("'null'", "null");
        }
        return componFilter;
    }
}

