/*
 * Decompiled with CFR 0.152.
 */
package coop.intergal.vaadin.rest.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.html.Label;
import com.vaadin.flow.component.html.NativeButton;
import com.vaadin.flow.component.notification.Notification;
import coop.intergal.espresso.presutec.utils.JSonClient;
import coop.intergal.ui.util.UtilSessionData;
import coop.intergal.ui.views.GeneratedUtil;
import coop.intergal.vaadin.rest.utils.DynamicDBean;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class RestData {
    static Hashtable<String, String> keepFieldName = new Hashtable();
    private static ArrayList<String> rowsColList;
    private static String variant;

    public static List<DynamicDBean> getResourceData(int offset, int limit, String resourceName, String preConfParam, ArrayList<String[]> rowsColList, String filter, boolean cache, boolean hasNewRow, String variant) {
        if (!cache) {
            keepFieldName.clear();
        }
        if (resourceName == null || resourceName.trim().length() == 0) {
            // empty if block
        }
        String pagesize = limit + "";
        if (limit == 0) {
            pagesize = "60";
        }
        ArrayList<DynamicDBean> customerList = new ArrayList<DynamicDBean>();
        JsonNode rowsList = null;
        try {
            if (filter == null || filter.equals("null")) {
                filter = "";
            }
            if (offset > 0) {
                filter = filter + "&offset=" + offset;
            }
            if (hasNewRow) {
                DynamicDBean d = new DynamicDBean();
                d.setRowsColList(rowsColList);
                d.setResourceName(resourceName);
                GeneratedUtil.fillDefaultValues(d);
                d.setPreConfParam(preConfParam);
                d.setFilter(filter);
                int maxNumberOfFields = 200;
                String maxNumberOfFieldsSTR = "";
                if (rowsColList.size() > 15) {
                    maxNumberOfFieldsSTR = rowsColList.get(0)[15];
                }
                System.out.println("RestData.fillRow() maxNumberOfFieldsSTR <<" + maxNumberOfFieldsSTR + ">>");
                if (maxNumberOfFieldsSTR.length() > 0) {
                    maxNumberOfFields = new Integer(maxNumberOfFieldsSTR);
                }
                d.setMaxColNumber(maxNumberOfFields);
                customerList.add(d);
                int pagesizeInt = new Integer(pagesize);
                if (pagesizeInt > 0) {
                    pagesize = pagesizeInt - 1 + "";
                }
            }
            if ((rowsList = JSonClient.get(resourceName, filter, false, preConfParam, pagesize + "")).get("statusCode") != null) {
                String errorMsg = rowsList.get("errorMessage").asText();
                System.err.println("*********** ERROR ******* " + errorMsg);
                DynamicDBean d = new DynamicDBean();
                d.setCol0("##ERROR## " + errorMsg);
                customerList.add(d);
                return customerList;
            }
            String col1name = rowsColList.get(0)[0];
            int i = 0;
            while (col1name.equals("#SPACE#")) {
                col1name = rowsColList.get(i)[0];
                ++i;
            }
            if (rowsList.get(col1name) != null) {
                DynamicDBean d = RestData.fillRow(rowsList, rowsColList, preConfParam, resourceName);
                d.setResourceName(resourceName);
                d.setPreConfParam(preConfParam);
                d.setFilter(filter);
                customerList.add(d);
            } else {
                for (JsonNode eachRow : rowsList) {
                    if (!RestData.isARealRow(eachRow)) continue;
                    DynamicDBean d = RestData.fillRow(eachRow, rowsColList, preConfParam, resourceName);
                    d.setResourceName(resourceName);
                    d.setPreConfParam(preConfParam);
                    d.setFilter(filter);
                    customerList.add(d);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("RestData.getResourceCustomer() after FILL LIST " + resourceName + " Filter:" + filter + " " + new Date());
        return customerList;
    }

    public static List<DynamicDBean> getResourceData(JsonNode rowsList, String resourceName, String preConfParam, ArrayList<String[]> rowsColList, boolean cache, boolean hasNewRow, String variant) {
        if (!cache) {
            keepFieldName.clear();
        }
        ArrayList<DynamicDBean> customerList = new ArrayList<DynamicDBean>();
        try {
            if (rowsList.get("statusCode") != null) {
                String errorMsg = rowsList.get("errorMessage").asText();
                System.err.println("*********** ERROR ******* " + errorMsg);
                DynamicDBean d = new DynamicDBean();
                d.setCol0("##ERROR## " + errorMsg);
                customerList.add(d);
                return customerList;
            }
            String col1name = rowsColList.get(0)[0];
            int i = 0;
            while (col1name.equals("#SPACE#")) {
                col1name = rowsColList.get(i)[0];
                ++i;
            }
            if (rowsList.get(col1name) != null) {
                DynamicDBean d = RestData.fillRow(rowsList, rowsColList, preConfParam, resourceName);
                d.setResourceName(resourceName);
                d.setPreConfParam(preConfParam);
                customerList.add(d);
            } else {
                for (JsonNode eachRow : rowsList) {
                    if (!RestData.isARealRow(eachRow)) continue;
                    DynamicDBean d = RestData.fillRow(eachRow, rowsColList, preConfParam, resourceName);
                    d.setResourceName(resourceName);
                    d.setPreConfParam(preConfParam);
                    customerList.add(d);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("RestData.getResourceCustomer() after FILL LIST (JsonNODE)" + resourceName + " " + new Date());
        return customerList;
    }

    public static List<DynamicDBean> getResourceData(String textToReturn) {
        ArrayList<DynamicDBean> customerList = new ArrayList<DynamicDBean>();
        Object rowsList = null;
        try {
            DynamicDBean dB = new DynamicDBean();
            dB.setCol0("1");
            dB.setCol1(textToReturn);
            customerList.add(dB);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return customerList;
    }

    private static boolean isARealRow(JsonNode eachRow) {
        JsonNode metadata = eachRow.get("@metadata");
        if (metadata == null) {
            return true;
        }
        return metadata.get("next_batch") == null && metadata.get("previous_batch") == null;
    }

    private static boolean isCombined(String col1name, JsonNode eachRow) {
        JsonNode metadata = eachRow.get("@metadata");
        JsonNode combined = metadata.get("combined");
        if (combined == null) {
            return false;
        }
        for (JsonNode eachfield : combined) {
            if (!col1name.equals(eachfield.asText())) continue;
            return true;
        }
        return true;
    }

    private static DynamicDBean fillRowDefaultValues(ArrayList<String[]> rowsColList, String resourceName) {
        DynamicDBean dB = new DynamicDBean();
        dB.setRowsColList(rowsColList);
        Field[] fields = dB.getClass().getDeclaredFields();
        int i = 0;
        int maxNumberOfFields = 200;
        String maxNumberOfFieldsSTR = rowsColList.get(0)[15];
        if (maxNumberOfFieldsSTR.length() > 0) {
            maxNumberOfFields = new Integer(maxNumberOfFieldsSTR);
        }
        for (Field field : fields) {
            try {
                if (field.getName().equals("col" + i) && i <= maxNumberOfFields) {
                    field.setAccessible(true);
                    String colName = RestData.getColName(rowsColList, i, resourceName);
                    if (!"null".equals(colName)) {
                        String defaultValue = RestData.getDefaultValue(rowsColList, i);
                        if (defaultValue == null || defaultValue.equals("null")) {
                            field.set(dB, null);
                        } else {
                            String value = defaultValue;
                            if (value.equals("null")) {
                                value = "";
                            }
                            field.set(dB, value);
                        }
                    }
                    ++i;
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
            if (i > maxNumberOfFields) break;
        }
        return dB;
    }

    private static DynamicDBean fillRow(JsonNode eachRow, ArrayList<String[]> rowsColList, String preConfParam, String resourceName) {
        DynamicDBean dB = new DynamicDBean();
        dB.setRowJSon(eachRow);
        dB.setRowsColList(rowsColList);
        if (eachRow.get("readOnly") != null) {
            if (eachRow.get("readOnly").asBoolean()) {
                dB.setReadOnly(true);
            } else {
                dB.setReadOnly(false);
            }
        } else {
            dB.setReadOnly(false);
        }
        if (eachRow.get("insertNotAllow") != null) {
            if (eachRow.get("insertNotAllow").asBoolean()) {
                dB.setInsertNotAllow(true);
            } else {
                dB.setInsertNotAllow(false);
            }
        } else {
            dB.setInsertNotAllow(false);
        }
        if (eachRow.get("deleteNotAllow") != null) {
            if (eachRow.get("deleteNotAllow").asBoolean()) {
                dB.setDeleteNotAllow(true);
            } else {
                dB.setDeleteNotAllow(false);
            }
        } else {
            dB.setUpdateNotAllow(false);
        }
        if (eachRow.get("updateNotAllow") != null) {
            if (eachRow.get("updateNotAllow").asBoolean()) {
                dB.setUpdateNotAllow(true);
            } else {
                dB.setUpdateNotAllow(false);
            }
        } else {
            dB.setUpdateNotAllow(false);
        }
        if (eachRow.get("splitGridDisplay") != null) {
            dB.setParams(dB.getParams() + "&splitGridDisplay=" + eachRow.get("splitGridDisplay"));
        }
        if (eachRow.get("splitQuery") != null) {
            dB.setParams(dB.getParams() + "&splitQuery=" + eachRow.get("splitQuery"));
        }
        if (eachRow.get("splitDisplaySubGrid") != null) {
            dB.setParams(dB.getParams() + "&splitDisplaySubGrid=" + eachRow.get("splitDisplaySubGrid"));
        }
        if (eachRow.get("classForLayout") != null) {
            dB.setParams(dB.getParams() + "&classForLayout=" + eachRow.get("classForLayout"));
        }
        if (eachRow.get("report") != null) {
            dB.setParams(dB.getParams() + "&report=" + eachRow.get("report"));
        }
        if (eachRow.get("report0") != null) {
            dB.setParams(dB.getParams() + "&report0=" + eachRow.get("report0"));
        }
        if (eachRow.get("report1") != null) {
            dB.setParams(dB.getParams() + "&report1=" + eachRow.get("report1"));
        }
        if (eachRow.get("report2") != null) {
            dB.setParams(dB.getParams() + "&report2=" + eachRow.get("report2"));
        }
        if (eachRow.get("report3") != null) {
            dB.setParams(dB.getParams() + "&report3=" + eachRow.get("report3"));
        }
        if (eachRow.get("report4") != null) {
            dB.setParams(dB.getParams() + "&report4=" + eachRow.get("report4"));
        }
        if (eachRow.get("report5") != null) {
            dB.setParams(dB.getParams() + "&report5=" + eachRow.get("report5"));
        }
        if (eachRow.get("report6") != null) {
            dB.setParams(dB.getParams() + "&report6=" + eachRow.get("report6"));
        }
        if (eachRow.get("report7") != null) {
            dB.setParams(dB.getParams() + "&report7=" + eachRow.get("report7"));
        }
        if (eachRow.get("report8") != null) {
            dB.setParams(dB.getParams() + "&report8=" + eachRow.get("report8"));
        }
        if (eachRow.get("report9") != null) {
            dB.setParams(dB.getParams() + "&report9=" + eachRow.get("report9"));
        }
        if (eachRow.get("report10") != null) {
            dB.setParams(dB.getParams() + "&report10=" + eachRow.get("report10"));
        }
        if (eachRow.get("reportSf") != null) {
            dB.setParams(dB.getParams() + "&reportSf=" + eachRow.get("reportSf"));
        } else if (eachRow.get("reportSF") != null) {
            dB.setParams(dB.getParams() + "&reportSf=" + eachRow.get("reportSF"));
        }
        if (eachRow.get("methodForRowSelected") != null) {
            dB.setMethodForRowSelected(eachRow.get("methodForRowSelected").asText());
        }
        Field[] fields = dB.getClass().getDeclaredFields();
        int i = 0;
        int maxNumberOfFields = 200;
        String maxNumberOfFieldsSTR = "";
        if (rowsColList.size() > 15) {
            maxNumberOfFieldsSTR = rowsColList.get(0)[15];
        }
        if (maxNumberOfFieldsSTR.length() > 0) {
            maxNumberOfFields = new Integer(maxNumberOfFieldsSTR);
        }
        dB.setMaxColNumber(maxNumberOfFields);
        for (Field field : fields) {
            try {
                if (field.getName().equals("col" + i) && i <= maxNumberOfFields) {
                    field.setAccessible(true);
                    String colName = RestData.getColName(rowsColList, i, resourceName);
                    if (!"null".equals(colName)) {
                        JsonNode data = eachRow.get(colName);
                        if (colName.indexOf("FK-") > -1) {
                            data = RestData.getDataFromFGNode(eachRow, colName);
                        }
                        if (data == null) {
                            field.set(dB, null);
                        } else if (RestData.isNotABinary(data)) {
                            String value = data.asText();
                            if (value.equals("null")) {
                                value = "";
                            }
                            field.set(dB, value);
                        } else {
                            JsonNode binaryData = data;
                            String url = binaryData.get("url").asText();
                            RestData.keepStreaminDb(dB, url, preConfParam);
                        }
                    }
                    ++i;
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
            if (i > maxNumberOfFields) break;
        }
        return dB;
    }

    private static JsonNode getDataFromFGNode(JsonNode eachRow, String colName) {
        String fkNodeName;
        JsonNode node;
        while ((node = eachRow.get(fkNodeName = colName.substring(0, colName.indexOf(".")))) != null) {
            if ((colName = colName.substring(colName.indexOf(".") + 1)).indexOf("FK-") == -1) {
                return node.get(colName);
            }
            eachRow = node;
        }
        return null;
    }

    private static void keepStreaminDb(DynamicDBean dB, String url, String preConfParam) {
        try {
            InputStream inputStream = JSonClient.getStream(url, preConfParam);
            dB.setInputStream(inputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean isNotABinary(JsonNode jsonNode) {
        return jsonNode.get("type") == null || !jsonNode.get("type").asText().equals("binary");
    }

    private static String getColName(ArrayList<String[]> rowsColList, int i, String resourceName) {
        String colNameInUIinColList = "null";
        String colNameInUIGenByI = "col" + i;
        String resourceAndFieldNinUI = resourceName + "&" + colNameInUIGenByI;
        if (keepFieldName.get(resourceAndFieldNinUI) != null && !keepFieldName.get(resourceAndFieldNinUI).equals("null")) {
            return keepFieldName.get(resourceAndFieldNinUI);
        }
        if (rowsColList.size() > i) {
            colNameInUIinColList = rowsColList.get(i)[2];
        }
        if (colNameInUIinColList.equals(colNameInUIGenByI) || colNameInUIinColList.isEmpty()) {
            return rowsColList.get(i)[0];
        }
        int cont = 0;
        for (String[] row : rowsColList) {
            ++cont;
            if (!row[2].equals(colNameInUIGenByI)) continue;
            keepFieldName.put(resourceAndFieldNinUI, row[0]);
            return row[0];
        }
        keepFieldName.put(resourceAndFieldNinUI, "null");
        return "null";
    }

    private static String getDefaultValue(ArrayList<String[]> rowsColList, int i) {
        String colNameInCL = "null";
        if (rowsColList.size() > i) {
            colNameInCL = rowsColList.get(i)[2];
        }
        if (colNameInCL.equals("col" + i) || colNameInCL.isEmpty()) {
            return rowsColList.get(i)[5];
        }
        for (String[] row : rowsColList) {
            if (!row[2].equals("col" + i)) continue;
            return row[5];
        }
        return "null";
    }

    public static void refresh(DynamicDBean dDb) {
        RestData.getResourceData(0, 0, dDb.getResourceName(), dDb.getPreConfParam(), dDb.getRowsColList(), dDb.getFilter(), false, false, variant);
    }

    public static int getCountRows(String resourceName, String preConfParam, String filter, boolean cache, boolean hasNewRow) {
        if (resourceName == null || resourceName.trim().length() == 0) {
            // empty if block
        }
        int count = 0;
        ArrayList customerList = new ArrayList();
        JsonNode rowsList = null;
        if (resourceName.startsWith("@")) {
            resourceName = resourceName.replace("@", "_");
        }
        try {
            String countName = "Count_";
            countName = countName + RestData.getDeeperTableName(resourceName);
            System.out.println("RestData.getCountRows() resourceName " + countName + " filter " + filter + " preConfParam " + preConfParam);
            rowsList = JSonClient.get(countName, filter, cache, preConfParam, "1");
            if (rowsList.get("statusCode") != null) {
                RestData.showError(rowsList.get("errorMessage").asText());
            } else {
                count = rowsList.get(0).get("COUNT(*)").asInt();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("RestData.getCountRows()--------" + count);
        if (hasNewRow) {
            System.out.println("RestData.getCountRows()--------(hasNewRow) " + ++count);
            Integer limit = new Integer("60");
            Integer actualCount = new Integer(count);
            if (actualCount > limit) {
                count = limit;
            }
        }
        return count;
    }

    private static String getDeeperTableName(String countName) {
        int idx__;
        int lastPoint = countName.lastIndexOf(".");
        if (lastPoint > -1) {
            countName = countName.substring(lastPoint);
        }
        int idxList = countName.indexOf("List-");
        int idxList_FE = countName.indexOf("List-FormExt");
        if (idxList_FE > -1) {
            countName = countName.substring(idxList_FE + 14);
        } else if (idxList > -1) {
            countName = countName.substring(idxList + 5);
        } else if (countName.startsWith("CR-")) {
            countName = countName.substring(3);
        }
        if (countName.indexOf("_SF") == -1 && (idx__ = countName.indexOf("__")) > -1) {
            countName = countName.substring(0, idx__);
        }
        return countName;
    }

    public static JsonNode getDataValueFromAFieldOfAResource(String resourceName, String field, String filter, String preConfParam) {
        JsonNode value = null;
        try {
            JsonNode rowsList = JSonClient.get(resourceName, filter, false, preConfParam, "40");
            if (rowsList != null && rowsList.get(0) != null) {
                value = rowsList.get(0).get(field);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    public static DynamicDBean getOneRow(String resourceName, String filter, String preConfParam) {
        return RestData.getOneRow(resourceName, filter, preConfParam, null);
    }

    public static DynamicDBean getOneRow(String resourceName, String filter, String preConfParam, ArrayList<String[]> rowsColList) {
        try {
            JsonNode rowsList = JSonClient.get(resourceName, filter, false, preConfParam, "20");
            rowsColList = RestData.getRowsColList(rowsColList, resourceName, preConfParam, null);
            if (!rowsColList.isEmpty()) {
                for (JsonNode eachRow : rowsList) {
                    if (eachRow.get(rowsColList.get(0)[0]) == null) continue;
                    DynamicDBean d = RestData.fillRow(eachRow, rowsColList, preConfParam, resourceName);
                    d.setResourceName(resourceName);
                    d.setPreConfParam(preConfParam);
                    d.setFilter(filter);
                    return d;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean checkIfExist(String resourceName, String filter, String preConfParam) {
        try {
            JsonNode rowsList = JSonClient.get(resourceName, filter, false, preConfParam, "1");
            return rowsList.size() > 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static ArrayList<String[]> getRowsColList(ArrayList<String[]> rowsColList, String resourceName, String preConfParam, String variant) {
        boolean cache = UtilSessionData.getCache();
        if (rowsColList == null || rowsColList.isEmpty() || !cache) {
            try {
                String genericResourceName;
                String tableNameToSearch = genericResourceName = resourceName;
                if (variant != null && !variant.isEmpty()) {
                    genericResourceName = resourceName;
                    int indx__ = genericResourceName.indexOf("__");
                    int idxPomt = resourceName.indexOf(".");
                    if (indx__ > 1 && idxPomt == -1) {
                        genericResourceName = resourceName.substring(0, indx__);
                    }
                    tableNameToSearch = genericResourceName + variant;
                }
                String filter = "tableName='" + tableNameToSearch + "'%20AND%20isDataField=true&order=colOrder";
                System.out.println("RestData.getRowsColList()  tablename to search = " + tableNameToSearch + " " + new Date());
                JsonNode cols = JSonClient.get("CR-FieldTemplate", filter, cache, "metadataLac0");
                if (cols != null && cols.size() > 0 && cols.get("errorMessage") == null) {
                    rowsColList = new ArrayList();
                    int i = 0;
                    boolean maxColNumber = false;
                    for (JsonNode col : cols) {
                        String fieldOrder;
                        String[] fieldArr = new String[26];
                        fieldArr[0] = col.get("fieldName").asText();
                        fieldArr[1] = col.get("showInGrid").asBoolean() ? "#SIG#" : "";
                        if (col.get("isSorteable").asBoolean()) {
                            fieldArr[1] = fieldArr[1] + "SORT";
                        }
                        fieldArr[0] = col.get("fieldName").asText();
                        if (col.get("isReadOnly") != null && col.get("isReadOnly").asBoolean()) {
                            fieldArr[1] = fieldArr[1] + "#CNoEDT#";
                        }
                        if (col.get("parentResource") != null && col.get("parentResource").asText().trim().length() > 1 && !col.get("parentResource").asText().trim().equals("null")) {
                            fieldArr[20] = col.get("parentResource").asText();
                            fieldArr[1] = col.get("idFieldType") != null && col.get("idFieldType").asText().trim().length() > 0 && !col.get("idFieldType").asText().trim().equals("null") && col.get("idFieldType").asInt() == 6 ? fieldArr[1] + "#COMBO#" : fieldArr[1] + "#PCK#";
                        }
                        if (col.get("isRequired") != null && col.get("isRequired").asBoolean()) {
                            fieldArr[1] = fieldArr[1] != null && !fieldArr[1].equals("null") ? fieldArr[1] + "#REQ#" : "#REQ#";
                        }
                        if (fieldArr[0].equals("pickMapFields")) {
                            fieldArr[1] = fieldArr[1] + "#PCK#FOR#pickMapFields";
                        }
                        fieldArr[2] = col.get("FieldNameInUI").asText().isEmpty() ? "col" + i : col.get("FieldNameInUI").asText();
                        fieldArr[3] = col.get("idFieldType").asText().isEmpty() || col.get("idFieldType").asText().equals("null") ? "" : col.get("idFieldType").asText();
                        fieldArr[4] = col.get("PathToParentField").asText().isEmpty() || col.get("PathToParentField").asText().equals("null") ? "" : col.get("PathToParentField").asText();
                        fieldArr[5] = col.get("defaultValue").asText().isEmpty() || col.get("defaultValue").asText().equals("null") ? "" : col.get("defaultValue").asText();
                        if (col.get("colOrder").asText().isEmpty()) {
                            fieldArr[6] = "";
                        } else if (col.get("colOrder").asText().contains("#")) {
                            String colOrder = col.get("colOrder").asText();
                            fieldArr[6] = colOrder.substring(colOrder.indexOf("#") + 1);
                        } else {
                            fieldArr[6] = "";
                        }
                        if (col.get("fieldOrder").asText().isEmpty()) {
                            fieldArr[7] = "";
                        } else if (col.get("fieldOrder").asText().contains("#")) {
                            fieldOrder = col.get("fieldOrder").asText();
                            fieldArr[7] = fieldOrder.substring(fieldOrder.indexOf("#") + 1);
                        } else {
                            fieldArr[7] = "";
                        }
                        if (col.get("queryOrder").asText().isEmpty()) {
                            fieldArr[8] = "";
                        } else if (col.get("queryOrder").asText().contains("#")) {
                            fieldOrder = col.get("queryOrder").asText();
                            fieldArr[8] = fieldOrder.substring(fieldOrder.indexOf("#") + 1);
                        } else {
                            fieldArr[8] = "";
                        }
                        fieldArr[9] = col.get("titleDisplay").asText().isEmpty() || col.get("titleDisplay").asText().equals("null") ? "" : col.get("titleDisplay").asText();
                        fieldArr[10] = col.get("titleQuery").asText().isEmpty() || col.get("titleQuery").asText().equals("null") ? "" : col.get("titleQuery").asText();
                        fieldArr[11] = col.get("titleGrid").asText().isEmpty() || col.get("titleGrid").asText().equals("null") ? "" : col.get("titleGrid").asText();
                        fieldArr[12] = col.get("tabsList").asText().isEmpty() || col.get("tabsList").asText().equals("null") ? "" : col.get("tabsList").asText();
                        fieldArr[13] = "";
                        fieldArr[14] = col.get("validationRuleName").asText().isEmpty() || col.get("validationRuleName").asText().equals("null") ? "" : col.get("validationRuleName").asText();
                        fieldArr[15] = col.get("maxColNumber").asText().isEmpty() || col.get("maxColNumber").asText().equals("null") ? "200" : col.get("maxColNumber").asText();
                        fieldArr[16] = "";
                        fieldArr[17] = "";
                        fieldArr[18] = "";
                        fieldArr[19] = "";
                        fieldArr[21] = col.get("tagsForVisibility").asText().isEmpty() || col.get("tagsForVisibility").asText().equals("null") ? "" : col.get("tagsForVisibility").asText();
                        fieldArr[22] = col.get("tagsForEdition").asText().isEmpty() || col.get("tagsForEdition").asText().equals("null") ? "" : col.get("tagsForEdition").asText();
                        fieldArr[23] = "";
                        fieldArr[24] = "";
                        fieldArr[25] = col.get("idButtonBarForButtons").asText().isEmpty() || col.get("idButtonBarForButtons").asText().equals("null") ? "" : col.get("idButtonBarForButtons").asText();
                        rowsColList.add(fieldArr);
                        ++i;
                    }
                    if (!resourceName.startsWith("@")) {
                        JsonNode resource;
                        String ident;
                        int idxPoint = resourceName.indexOf(".");
                        if (idxPoint > -1) {
                            resourceName = resourceName.substring(0, idxPoint);
                        }
                        if ((ident = JSonClient.getIdentOfResource(resourceName, true, preConfParam)) != null && ((resource = JSonClient.get("@resources/" + ident, null, true, preConfParam)).get("statusCode") != null && resource.get("statusCode").asInt() != 500 || resource.get("statusCode") == null)) {
                            JSonClient.keepJoinConditionSubResources(resource);
                        }
                    }
                } else {
                    rowsColList = RestData.getColListFromTable(resourceName, preConfParam);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return rowsColList;
    }

    public static ArrayList<String> getRowsColList(String resourceName, String preConfParam, String variant) {
        boolean cache = UtilSessionData.getCache();
        try {
            JsonNode cols;
            String genericResourceName = resourceName;
            int indx__ = genericResourceName.indexOf("__");
            if (indx__ > 1) {
                genericResourceName = resourceName.substring(0, indx__);
            }
            if ((cols = JSonClient.get("FieldTemplate", "tableName='" + genericResourceName + variant + "'", cache, "metadataLac0")) != null && cols.size() > 0 && cols.get("errorMessage") == null) {
                rowsColList = new ArrayList();
                for (JsonNode col : cols) {
                    rowsColList.add(col.get("fieldName").asText());
                }
            } else {
                cols = JSonClient.getColumnsFromTable(resourceName, null, cache, preConfParam);
                rowsColList = new ArrayList();
                Iterator fN = cols.get(0).fieldNames();
                while (fN.hasNext()) {
                    rowsColList.add((String)fN.next());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rowsColList;
    }

    public static ArrayList<String[]> getRowsFieldList(ArrayList<String[]> rowsColList, String resourceName, String preConfParam, Boolean cache) {
        cache = UtilSessionData.getCache();
        if (rowsColList == null || rowsColList.isEmpty() || !cache.booleanValue()) {
            try {
                String genericResourceName;
                String tableNameToSearch = genericResourceName = resourceName;
                System.out.println("RestData.getRowsFieldList()  tablename to search = " + tableNameToSearch);
                String filter = "tableName='" + tableNameToSearch + "'%20AND%20showInDisplay=true&order=tab,fieldOrder";
                JsonNode cols = JSonClient.get("CR-FieldTemplate", filter, cache, "metadataLac0");
                if (cols != null && cols.size() > 0 && cols.get("errorMessage") == null) {
                    rowsColList = new ArrayList();
                    int i = 0;
                    for (JsonNode col : cols) {
                        String[] fieldArr = new String[26];
                        fieldArr[0] = col.get("fieldName").asText();
                        if (col.get("isReadOnly") != null && col.get("isReadOnly").asBoolean()) {
                            fieldArr[1] = fieldArr[1] + "#CNoEDT#";
                        }
                        if (col.get("isRequired") != null && col.get("isRequired").asBoolean()) {
                            fieldArr[1] = fieldArr[1] != null && !fieldArr[1].equals("null") ? fieldArr[1] + "#REQ#" : "#REQ#";
                        }
                        if (fieldArr[1] == null || fieldArr[1].equals("null")) {
                            fieldArr[1] = "";
                        }
                        if (col.get("parentResource") != null && col.get("parentResource").asText().trim().length() > 1 && !col.get("parentResource").asText().trim().equals("null")) {
                            fieldArr[20] = col.get("parentResource").asText();
                            fieldArr[1] = col.get("idFieldType") != null && col.get("idFieldType").asText().trim().length() > 0 && !col.get("idFieldType").asText().trim().equals("null") && col.get("idFieldType").asInt() == 6 ? fieldArr[1] + "#COMBO#" : fieldArr[1] + "#PCK#";
                        }
                        fieldArr[2] = col.get("FieldNameInUI").asText().isEmpty() ? "col" + i : col.get("FieldNameInUI").asText();
                        fieldArr[3] = col.get("idFieldType").asText().isEmpty() || col.get("idFieldType").asText().equals("null") ? "" : col.get("idFieldType").asText();
                        fieldArr[4] = col.get("PathToParentField").asText().isEmpty() || col.get("PathToParentField").asText().equals("null") ? "" : col.get("PathToParentField").asText();
                        fieldArr[5] = col.get("defaultValue").asText().isEmpty() || col.get("defaultValue").asText().equals("null") ? "" : col.get("defaultValue").asText();
                        if (col.get("fieldOrder").asText().isEmpty()) {
                            fieldArr[6] = "";
                        } else if (col.get("fieldOrder").asText().contains("#")) {
                            String fieldOrder = col.get("fieldOrder").asText();
                            fieldArr[6] = fieldOrder.substring(fieldOrder.indexOf("#") + 1);
                        } else {
                            fieldArr[6] = "";
                        }
                        fieldArr[7] = col.get("fieldWidth").asText().isEmpty() || col.get("fieldWidth").asText().equals("null") ? "8" : col.get("fieldWidth").asText();
                        fieldArr[8] = col.get("cssStyle").asText().isEmpty() || col.get("cssStyle").asText().equals("null") ? "" : col.get("cssStyle").asText();
                        fieldArr[9] = col.get("titleDisplay").asText().isEmpty() || col.get("titleDisplay").asText().equals("null") ? "" : col.get("titleDisplay").asText();
                        fieldArr[10] = col.get("titleQuery").asText().isEmpty() || col.get("titleQuery").asText().equals("null") ? "" : col.get("titleQuery").asText();
                        fieldArr[11] = col.get("titleGrid").asText().isEmpty() || col.get("titleGrid").asText().equals("null") ? "" : col.get("titleGrid").asText();
                        fieldArr[12] = "";
                        fieldArr[13] = col.get("fieldSize").asText().isEmpty() || col.get("fieldSize").asText().equals("null") ? "" : col.get("fieldSize").asText();
                        fieldArr[14] = col.get("validationRuleName").asText().isEmpty() || col.get("validationRuleName").asText().equals("null") ? "" : col.get("validationRuleName").asText();
                        fieldArr[15] = col.get("maxColNumber").asText().isEmpty() || col.get("maxColNumber").asText().equals("null") ? "200" : col.get("maxColNumber").asText();
                        fieldArr[16] = col.get("toolTip").asText().isEmpty() || col.get("toolTip").asText().equals("null") ? "" : col.get("toolTip").asText();
                        fieldArr[17] = col.get("tabs").asText().isEmpty() || col.get("tabs").asText().equals("null") ? "" : col.get("tabs").asText();
                        fieldArr[18] = col.get("tab").asText().isEmpty() || col.get("tab").asText().equals("null") ? "" : col.get("tab").asText();
                        fieldArr[19] = col.get("fieldHeight").asText().isEmpty() || col.get("fieldHeight").asText().equals("null") ? "" : col.get("fieldHeight").asText();
                        fieldArr[21] = col.get("tagsForVisibility").asText().isEmpty() || col.get("tagsForVisibility").asText().equals("null") ? "" : col.get("tagsForVisibility").asText();
                        fieldArr[22] = col.get("tagsForEdition").asText().isEmpty() || col.get("tagsForEdition").asText().equals("null") ? "" : col.get("tagsForEdition").asText();
                        fieldArr[23] = "";
                        fieldArr[24] = "";
                        fieldArr[25] = col.get("idButtonBarForButtons").asText().isEmpty() || col.get("idButtonBarForButtons").asText().equals("null") ? "" : col.get("idButtonBarForButtons").asText();
                        rowsColList.add(fieldArr);
                        ++i;
                    }
                    if (!resourceName.startsWith("@")) {
                        String ident;
                        int idxPoint = resourceName.indexOf(".");
                        if (idxPoint > -1) {
                            resourceName = resourceName.substring(0, idxPoint);
                        }
                        if ((ident = JSonClient.getIdentOfResource(resourceName, UtilSessionData.getCache(), preConfParam)) != null) {
                            JsonNode resource = JSonClient.get("@resources/" + ident, null, true, preConfParam);
                            JSonClient.keepJoinConditionSubResources(resource);
                        }
                    }
                } else {
                    rowsColList = RestData.getColListFromTable(resourceName, preConfParam);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return rowsColList;
    }

    private static ArrayList<String[]> getColListFromTable(String resourceName, String preConfParam) {
        boolean cache = UtilSessionData.getCache();
        JsonNode cols = JSonClient.getColumnsFromTable(resourceName, null, cache, preConfParam);
        ArrayList<String[]> rowsColList = new ArrayList<String[]>();
        Iterator fN = cols.get(0).fieldNames();
        int i = 0;
        while (fN.hasNext()) {
            String fieldName;
            String[] fieldArr = new String[26];
            fieldArr[0] = fieldName = (String)fN.next();
            fieldArr[1] = "#SIG#";
            String type = cols.get(0).get(fieldName).asText();
            fieldArr[2] = "col" + i;
            fieldArr[3] = "";
            fieldArr[4] = "";
            fieldArr[5] = "";
            fieldArr[6] = fieldName;
            fieldArr[7] = "8";
            fieldArr[8] = "";
            fieldArr[9] = "";
            fieldArr[10] = "";
            fieldArr[11] = "";
            fieldArr[12] = "";
            fieldArr[13] = "";
            fieldArr[14] = "";
            fieldArr[15] = "200";
            fieldArr[16] = "";
            fieldArr[17] = "";
            fieldArr[18] = "";
            fieldArr[19] = "";
            fieldArr[20] = "";
            fieldArr[21] = "";
            fieldArr[22] = "";
            fieldArr[23] = "";
            fieldArr[24] = "";
            fieldArr[25] = "";
            if (type.equals("Date")) {
                fieldArr[3] = "1";
            }
            rowsColList.add(fieldArr);
            ++i;
        }
        return rowsColList;
    }

    public static DynamicDBean copyDatabean(DynamicDBean fromBean) {
        DynamicDBean toBean = new DynamicDBean();
        Field[] fieldsTobean = toBean.getClass().getDeclaredFields();
        int i = 0;
        for (Field field : fieldsTobean) {
            try {
                field.setAccessible(true);
                if (!field.getName().equals("col" + i)) continue;
                Method getColX = DynamicDBean.class.getMethod("getCol" + i, new Class[0]);
                String value = (String)getColX.invoke((Object)fromBean, new Object[0]);
                if (value == null || value.equals("null")) {
                    value = "";
                }
                field.set(toBean, value);
                ++i;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        toBean.setFilter(fromBean.getFilter());
        toBean.setPreConfParam(fromBean.getPreConfParam());
        toBean.setResourceName(fromBean.getResourceName());
        toBean.setRowColTypeList(fromBean.getRowColTypeList());
        toBean.setRowsColList(fromBean.getRowsColList());
        toBean.setRowJSon(fromBean.getRowJSon());
        return toBean;
    }

    public static ArrayList<String[]> getRowsColList(ArrayList<String[]> rowsColList, String resourceName, String preConfParam) {
        return RestData.getRowsColList(rowsColList, resourceName, preConfParam, null);
    }

    public static ArrayList<String[]> getRowsQueryFieldList(ArrayList<String[]> rowsFIeldQueryList, String resourceName, String preConfParam) {
        boolean cache = UtilSessionData.getCache();
        if (rowsFIeldQueryList == null || rowsFIeldQueryList.isEmpty() || !cache) {
            try {
                String genericResourceName;
                String tableNameToSearch = genericResourceName = resourceName;
                System.out.println("RestData.getRowsFieldList()  tablename to search = " + tableNameToSearch);
                String filter = "tableName='" + tableNameToSearch + "'%20AND%20showInQuery=true&order=tabQuery,queryOrder";
                JsonNode cols = JSonClient.get("CR-FieldTemplate", filter, cache, "metadataLac0");
                if (cols != null && cols.size() > 0 && cols.get("errorMessage") == null) {
                    rowsFIeldQueryList = new ArrayList();
                    int i = 0;
                    for (JsonNode col : cols) {
                        String[] fieldArr = new String[26];
                        fieldArr[0] = col.get("fieldName").asText();
                        if (col.get("parentResource") != null && col.get("parentResource").asText().trim().length() > 1 && !col.get("parentResource").asText().trim().equals("null")) {
                            fieldArr[20] = col.get("parentResource").asText();
                            fieldArr[1] = col.get("idFieldType") != null && col.get("idFieldType").asText().trim().length() > 0 && !col.get("idFieldType").asText().trim().equals("null") && col.get("idFieldType").asInt() == 6 ? fieldArr[1] + "#COMBO#" : fieldArr[1] + "#PCK#";
                        }
                        fieldArr[2] = col.get("FieldNameInUI").asText().isEmpty() ? "col" + i : col.get("FieldNameInUI").asText();
                        fieldArr[3] = col.get("idFieldType").asText().isEmpty() || col.get("idFieldType").asText().equals("null") ? "" : col.get("idFieldType").asText();
                        fieldArr[4] = col.get("PathToParentField").asText().isEmpty() || col.get("PathToParentField").asText().equals("null") ? "" : col.get("PathToParentField").asText();
                        fieldArr[5] = col.get("defaultValue").asText().isEmpty() || col.get("defaultValue").asText().equals("null") ? "" : col.get("defaultValue").asText();
                        if (col.get("queryOrder").asText().isEmpty()) {
                            fieldArr[6] = "";
                        } else if (col.get("queryOrder").asText().contains("#")) {
                            String queryOrder = col.get("queryOrder").asText();
                            fieldArr[6] = queryOrder.substring(queryOrder.indexOf("#") + 1);
                        } else {
                            fieldArr[6] = "";
                        }
                        fieldArr[7] = col.get("queryFieldWidth").asText().isEmpty() || col.get("queryFieldWidth").asText().equals("null") ? "25#25" : col.get("queryFieldWidth").asText();
                        fieldArr[8] = col.get("cssStyleQueryField").asText().isEmpty() || col.get("cssStyleQueryField").asText().equals("null") ? ".labelM" : col.get("cssStyleQueryField").asText();
                        fieldArr[9] = col.get("titleDisplay").asText().isEmpty() || col.get("titleDisplay").asText().equals("null") ? "" : col.get("titleDisplay").asText();
                        fieldArr[10] = col.get("titleQuery").asText().isEmpty() || col.get("titleQuery").asText().equals("null") ? "" : col.get("titleQuery").asText();
                        fieldArr[11] = col.get("titleGrid").asText().isEmpty() || col.get("titleGrid").asText().equals("null") ? "" : col.get("titleGrid").asText();
                        fieldArr[12] = "";
                        fieldArr[13] = "";
                        fieldArr[14] = "";
                        fieldArr[15] = col.get("maxColNumber").asText().isEmpty() || col.get("maxColNumber").asText().equals("null") ? "200" : col.get("maxColNumber").asText();
                        rowsFIeldQueryList.add(fieldArr);
                        fieldArr[16] = "";
                        fieldArr[16] = col.get("toolTip").asText();
                        fieldArr[17] = col.get("tabsQuery").asText().isEmpty() || col.get("tabsQuery").asText().equals("null") ? "" : col.get("tabsQuery").asText();
                        fieldArr[18] = col.get("tabQuery").asText().isEmpty() || col.get("tabQuery").asText().equals("null") ? "" : col.get("tabQuery").asText();
                        fieldArr[19] = "";
                        fieldArr[21] = col.get("tagsForVisibility").asText().isEmpty() || col.get("tagsForVisibility").asText().equals("null") ? "" : col.get("tagsForVisibility").asText();
                        fieldArr[22] = "";
                        fieldArr[23] = col.get("tagsForQueryEdition").asText().isEmpty() || col.get("tagsForQueryEdition").asText().equals("null") ? "" : col.get("tagsForQueryEdition").asText();
                        fieldArr[24] = col.get("defaultValueForQuery").asText().isEmpty() || col.get("defaultValueForQuery").asText().equals("null") ? "" : col.get("defaultValueForQuery").asText();
                        if (col.get("idButtonBarForButtons").asText().isEmpty() || col.get("idButtonBarForButtons").asText().equals("null")) {
                            fieldArr[25] = "";
                            continue;
                        }
                        fieldArr[25] = col.get("idButtonBarForButtons").asText();
                    }
                    if (!resourceName.startsWith("@")) {
                        String ident;
                        int idxPoint = resourceName.indexOf(".");
                        if (idxPoint > -1) {
                            resourceName = resourceName.substring(0, idxPoint);
                        }
                        if ((ident = JSonClient.getIdentOfResource(resourceName, true, preConfParam)) != null) {
                            JsonNode resource = JSonClient.get("@resources/" + ident, null, true, preConfParam);
                            JSonClient.keepJoinConditionSubResources(resource);
                        }
                    }
                } else {
                    rowsFIeldQueryList = RestData.getColListFromTable(resourceName, preConfParam);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return rowsFIeldQueryList;
    }

    public static void showError(String error) {
        Label content = new Label(error);
        NativeButton buttonInside = new NativeButton("Cerrar");
        Notification notification = new Notification(new Component[]{content, buttonInside});
        buttonInside.addClickListener((ComponentEventListener & Serializable)event -> notification.close());
        notification.setPosition(Notification.Position.MIDDLE);
        notification.open();
    }
}

