/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.intergal.validation;

import com.fasterxml.jackson.databind.JsonNode;
import coop.intergal.espresso.presutec.utils.JSonClient;
import coop.intergal.ui.util.UtilSessionData;
import coop.intergal.vaadin.rest.utils.DataService;
import coop.intergal.vaadin.rest.utils.DynamicDBean;
import coop.intergal.vaadin.rest.utils.RestData;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.vaadin.intergal.validation.ValidationMetadata;

public class Constraints {
    static Hashtable<String, String> fieldNAmeAndFieldinUI = new Hashtable();
    private static final String RESOURCE_FIELD_TEMPLATE = "CR-FormTemplate.List-FieldTemplate";

    private static String formatMessage(ValidationMetadata<?> metadata, String message) {
        String fieldName = metadata.getProperty("name");
        if (fieldName == null) {
            return message;
        }
        return fieldName + " " + message;
    }

    public static String positive(Integer value, ValidationMetadata<?> metadata) {
        return Constraints.greaterThan(value, metadata, "0");
    }

    public static String greaterThan(Integer value, ValidationMetadata<?> metadata, String arg) {
        String result;
        boolean req = false;
        int separatorPos = arg.indexOf(";");
        if (separatorPos > -1) {
            String reqStr = arg.substring(separatorPos + 1);
            arg = arg.substring(0, separatorPos);
            if (reqStr.equals("true")) {
                req = true;
            }
        }
        if (req && (result = Constraints.isRequired(value, metadata)) != null) {
            return result;
        }
        int limit = Integer.parseInt(arg);
        if (value == null || value > limit) {
            return null;
        }
        return Constraints.formatMessage(metadata, "debe ser mayor a " + limit);
    }

    public static String lessThan(Integer value, ValidationMetadata<?> metadata, String arg) {
        Long limit = new Long(arg);
        if (value == null || (long)value.intValue() < limit) {
            return null;
        }
        return Constraints.formatMessage(metadata, "debe ser menor a " + limit);
    }

    public static String lessThan(String valueStr, ValidationMetadata<?> metadata, String arg) {
        valueStr = valueStr.replace(",", ".");
        Double value = new Double(valueStr);
        Double limit = new Double(arg);
        if (value == null || value > limit) {
            return null;
        }
        return Constraints.formatMessage(metadata, "debe ser menor a " + limit);
    }

    public static String minLength(String value, ValidationMetadata<?> metadata, String arg) {
        int length = Integer.parseInt(arg);
        if (value == null || value.length() >= length) {
            return null;
        }
        return Constraints.formatMessage(metadata, "debe contener al menos " + length + " caracteres");
    }

    public static String isRequired(String value, ValidationMetadata<?> metadata) {
        if (value == null || value.length() >= 1) {
            return null;
        }
        return Constraints.formatMessage(metadata, "Requerido");
    }

    public static String isRequired(Double value, ValidationMetadata<?> metadata) {
        if (value == null || value >= 0.0) {
            return null;
        }
        return Constraints.formatMessage(metadata, "Requerido");
    }

    public static String isRequired(BigDecimal value, ValidationMetadata<?> metadata) {
        if (value == null) {
            return Constraints.formatMessage(metadata, "Requerido");
        }
        if (value.doubleValue() > 0.0) {
            return null;
        }
        return Constraints.formatMessage(metadata, "Requerido");
    }

    public static String isRequired(Integer value, ValidationMetadata<?> metadata) {
        if (value == null) {
            return Constraints.formatMessage(metadata, "Requerido");
        }
        if (value >= 0) {
            return null;
        }
        return Constraints.formatMessage(metadata, "Requerido");
    }

    public static String notInFuture(LocalDate value, ValidationMetadata<?> metadata) {
        if (value == null || value.compareTo(LocalDate.now()) <= 0) {
            return null;
        }
        return Constraints.formatMessage(metadata, "no debe ser posterior a la fecha actual");
    }

    public static String compareDates(DynamicDBean bean, ValidationMetadata<?> metadata, String startDateCol, String endDateCol) {
        if (bean.getColDate(startDateCol) == null || bean.getColDate(endDateCol) == null || bean.getColDate(startDateCol).compareTo(bean.getColDate(endDateCol)) < 0) {
            return null;
        }
        return "La fecha de inicio debe ser anterior a la fecha de finalizacion";
    }

    public static String validateOneCol(DynamicDBean bean, ValidationMetadata<?> metadata, String colName) {
        if (bean.getCol(colName).equals("1111")) {
            return null;
        }
        return "La fecha de inicio debe ser anterior a la fecha de finalizacion";
    }

    public static String validateFromBackEnd(DynamicDBean bean, ValidationMetadata<?> metadata, String validationNameANDcache) {
        String validationName;
        String Result;
        Boolean cache = true;
        if (validationNameANDcache.substring(validationNameANDcache.indexOf(",")).equals(",false")) {
            cache = false;
        }
        if ((Result = Constraints.validateFromBackEnd(bean, validationName = validationNameANDcache.substring(0, validationNameANDcache.indexOf(",")), cache)).equals("OK")) {
            return null;
        }
        return Result;
    }

    public static String warningFromUiValidation(DynamicDBean bean, ValidationMetadata<?> metadata, String validationNameANDcache) {
        String validationName;
        String Result;
        Boolean cache = true;
        if (validationNameANDcache.substring(validationNameANDcache.indexOf(",")).equals(",false")) {
            cache = false;
        }
        if ((Result = Constraints.warningFromUiValidation(bean, validationName = validationNameANDcache.substring(0, validationNameANDcache.indexOf(",")))).equals("OK")) {
            return null;
        }
        return Result;
    }

    public static String warningFromBackEnd(DynamicDBean bean, ValidationMetadata<?> metadata, String validationNameANDcache) {
        String validationName;
        String Result;
        Boolean cache = true;
        if (validationNameANDcache.substring(validationNameANDcache.indexOf(",")).equals(",false")) {
            cache = false;
        }
        if ((Result = Constraints.warningFromBackEnd(bean, validationName = validationNameANDcache.substring(0, validationNameANDcache.indexOf(",")), cache)).equals("OK")) {
            return null;
        }
        return Result;
    }

    private static String validateFromBackEnd(DynamicDBean bean, String validationName, Boolean cache) {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("JavaScript");
        String resourceName = bean.getResourceName();
        String[] jSStringAndErrorTest = Constraints.getJSFromBackEnd(resourceName, validationName, cache);
        if (jSStringAndErrorTest == null) {
            return "ERROR en Validaci\u00f3n, \"Nombre Validaci\u00f3n BR\" (" + validationName + ") no existe para la tabla (" + Constraints.getTableNameFromResourceName(resourceName) + ") correspondiente";
        }
        String jSStringToProcess = Constraints.createUsableJS(jSStringAndErrorTest[0], validationName, resourceName);
        String callJS = "valida(" + Constraints.getValuesFromBean(bean, resourceName, validationName) + ")";
        String resultStr = "No validado";
        try {
            engine.eval(jSStringToProcess);
            Boolean result = (Boolean)engine.eval(callJS);
            resultStr = result.booleanValue() ? "OK" : jSStringAndErrorTest[1];
        }
        catch (ScriptException e) {
            e.printStackTrace();
            return "ERROR en Validaci\u00f3n, \"Nombre Validaci\u00f3n BR\" (" + validationName + ") ->" + e.getMessage();
        }
        return resultStr;
    }

    private static String warningFromBackEnd(DynamicDBean bean, String validationName, Boolean cache) {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("JavaScript");
        String resourceName = bean.getResourceName();
        String[] jSStringAndErrorTest = Constraints.getJSFromBackEnd(resourceName, validationName, cache);
        if (jSStringAndErrorTest == null) {
            return "ERROR en Validaci\u00f3n, \"Nombre Validaci\u00f3n BR\" (" + validationName + ") no existe para la tabla (" + Constraints.getTableNameFromResourceName(resourceName) + ") correspondiente";
        }
        String jSStringToProcess = Constraints.createUsableJS(jSStringAndErrorTest[0], validationName, resourceName);
        String callJS = "valida(" + Constraints.getValuesFromBean(bean, resourceName, validationName) + ")";
        String resultStr = "No validado";
        try {
            engine.eval(jSStringToProcess);
            Boolean result = (Boolean)engine.eval(callJS);
            resultStr = result.booleanValue() ? "OK" : "WARNING" + jSStringAndErrorTest[1];
        }
        catch (ScriptException e) {
            e.printStackTrace();
            return "ERROR en Validaci\u00f3n, \"Nombre Validaci\u00f3n BR\" (" + validationName + ") ->" + e.getMessage();
        }
        return resultStr;
    }

    private static String warningFromUiValidation(DynamicDBean bean, String validationName) {
        int idxFilter = validationName.indexOf("@FILTER");
        String resourceUiV = validationName.substring(0, idxFilter);
        String filter = validationName.substring(idxFilter + 7);
        int idxStartField = filter.indexOf("<<");
        int idxEndField = filter.indexOf(">>");
        String fieldTofilter = filter.substring(idxStartField + 2, idxEndField);
        String colNameinUI = Constraints.getColNameinUI(bean.getResourceName(), fieldTofilter);
        String valueToFilter = bean.getCol(colNameinUI);
        filter = filter.replace("<<" + fieldTofilter + ">>", valueToFilter);
        String resultStr = "OK";
        try {
            JsonNode resultRow = JSonClient.get(resourceUiV, filter, false, UtilSessionData.getCompanyYear() + "TYSLac0", "1");
            if (resultRow.get("statusCode") == null) {
                if (resultRow.get("result") == null || resultRow.get("msgError") == null) {
                    DataService.get().showError(" Campos \"result\" o \"msgError\", no definidos en el recurso " + resourceUiV);
                } else {
                    boolean result = resultRow.get("result").asBoolean();
                    String msgError = resultRow.get("msgError").asText();
                    resultStr = result ? "OK" : "WARNING" + msgError;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultStr;
    }

    private static String getValuesFromBean(DynamicDBean bean, String resourceName, String validationName) {
        String[] tokens = validationName.split(Pattern.quote("_"));
        String values = "'";
        for (int i = 1; tokens.length > i; ++i) {
            String field = tokens[i];
            String fieldNameInUI = fieldNAmeAndFieldinUI.get(resourceName + "#" + field);
            String value = bean.getCol(fieldNameInUI);
            values = values + value + "','";
        }
        if (values.indexOf("'true'") > -1) {
            values = values.replace("'true'", "true");
        } else if (values.indexOf("'false'") > -1) {
            values = values.replace("'false'", "false");
        }
        return values.substring(0, values.length() - 2);
    }

    private static String[] getJSFromBackEnd(String resourceName, String validationName, boolean cache) {
        try {
            String filter = "\"name\"='" + validationName + "'";
            String filterEncode = URLEncoder.encode(filter, StandardCharsets.UTF_8.toString());
            JsonNode rowRules = JSonClient.get("LACAdmin:rules", filterEncode, cache, "metadataLac0", "1");
            Iterator iterator = rowRules.iterator();
            if (iterator.hasNext()) {
                JsonNode eachRow = (JsonNode)iterator.next();
                String[] s = new String[]{eachRow.get("rule_text1").asText(), eachRow.get("rule_text2").asText()};
                return s;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static String getTableNameFromResourceName(String resourceName) {
        if (resourceName.startsWith("CR-")) {
            int idxEnd = resourceName.indexOf("__");
            String tableName = resourceName.substring(3);
            if (idxEnd > -1) {
                tableName = resourceName.substring(3, idxEnd);
            }
            return tableName;
        }
        if (resourceName.indexOf("List-") > -1 && resourceName.indexOf("List-") < 3) {
            int idxEnd = resourceName.indexOf("__");
            String tableName = resourceName.substring(5);
            if (idxEnd > -1) {
                tableName = resourceName.substring(5, idxEnd);
            }
            return tableName;
        }
        return resourceName;
    }

    private static String createUsableJS(String javascriptString, String fieldNames, String resourceName) {
        String[] tokens = fieldNames.split(Pattern.quote("_"));
        String functionDef = "function valida(";
        for (int i = 1; tokens.length > i; ++i) {
            String field = tokens[i];
            Constraints.fillHTable(resourceName, field);
            javascriptString = javascriptString.replaceAll("row." + field, "f" + i);
            functionDef = functionDef + "f" + i + ",";
        }
        functionDef = functionDef.substring(0, functionDef.length() - 1) + "){";
        return functionDef + javascriptString + "}";
    }

    private static void fillHTable(String resourceName, String field) {
        if (fieldNAmeAndFieldinUI.get(resourceName + "#" + field) == null) {
            fieldNAmeAndFieldinUI.put(resourceName + "#" + field, Constraints.getColNameinUI(resourceName, field));
        }
    }

    private static String getColNameinUIOLD(String resourceName, String field) {
        String filter = "tableName='" + resourceName + "'%20AND%20fieldName='" + field + "'";
        DynamicDBean dynamicDBean = RestData.getOneRow(RESOURCE_FIELD_TEMPLATE, filter, "metadataLac0", null);
        if (dynamicDBean.getCol19() != null) {
            return dynamicDBean.getCol19();
        }
        return "colNOTFOUND";
    }

    private static String getColNameinUI(String resourceName, String field) {
        try {
            String filter = "tableName='" + resourceName + "' AND fieldName='" + field + "'";
            String filterEncode = URLEncoder.encode(filter, StandardCharsets.UTF_8.toString());
            JsonNode rowFT = JSonClient.get("main:FieldTemplate", filterEncode, true, "metadataLac0", "1");
            Iterator iterator = rowFT.iterator();
            if (iterator.hasNext()) {
                JsonNode eachRow = (JsonNode)iterator.next();
                return eachRow.get("FieldNameInUI").asText();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DataService.get().showError("el campo (" + field + ") no exite en Metaconfig");
        return "colNOTFOUND";
    }

    public static String valueInList(String value, ValidationMetadata<?> metadata, String arg) {
        if (value == null || Arrays.asList(arg.split(",")).contains(value)) {
            return null;
        }
        return "El valor no se encuentra en la lista";
    }
}

