/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.intergal.validation;

import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.binder.ValueContext;
import coop.intergal.vaadin.rest.utils.DataService;
import org.vaadin.intergal.validation.ValidationConstraint;
import org.vaadin.intergal.validation.ValidationMetadata;
import org.vaadin.intergal.validation.ValidationServiceProvider;

public class DynValidator<T>
implements Validator<T> {
    private static final long serialVersionUID = 1L;
    private final ValidationConstraint<? super T> constraint;
    private int errorAlreadyShow = 0;

    public DynValidator(String constraint, ValidationMetadata<T> metadata) {
        this.constraint = ValidationServiceProvider.getInstance().parseConstraint(constraint, metadata);
    }

    public ValidationResult apply(T value, ValueContext context) {
        Object errorMessage = this.constraint.apply((Object)value);
        if (errorMessage != null) {
            if (((String)errorMessage).startsWith("WARNING")) {
                DataService.get().showError(((String)errorMessage).substring(7));
                ++this.errorAlreadyShow;
                return ValidationResult.ok();
            }
            return ValidationResult.error((String)errorMessage);
        }
        return ValidationResult.ok();
    }
}

