/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.intergal.validation;

import java.util.HashMap;
import java.util.Map;

public final class ValidationMetadata<T> {
    private final Class<T> valueType;
    private Map<String, String> properties;

    private ValidationMetadata(Class<T> valueType, Map<String, String> properties) {
        this.valueType = valueType;
        this.properties = properties;
    }

    public Class<T> getValueType() {
        return this.valueType;
    }

    public static <T> ValidationMetadata<T> of(Class<T> valueType) {
        return new ValidationMetadata<T>(valueType, new HashMap<String, String>());
    }

    public ValidationMetadata<T> withProperty(String name, String value) {
        this.properties.put(name, value);
        return this;
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }
}

