/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.intergal.validation;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import org.vaadin.intergal.validation.ValidationConstraint;
import org.vaadin.intergal.validation.ValidationMetadata;
import org.vaadin.intergal.validation.ValidationService;

public class ValidationServiceImpl
implements ValidationService {
    @Override
    public <T> ValidationConstraint<? super T> parseConstraint(String constraint, ValidationMetadata<T> metadata) {
        Method method;
        String[] ss = constraint.split("#", 2);
        int i = ss[0].lastIndexOf(46);
        String methodName = ss[0].substring(i + 1);
        String className = ss[0].substring(0, i);
        String arg = ss.length == 1 ? null : ss[1];
        try {
            method = this.lookupMethod(className, methodName, metadata.getValueType(), ss.length + 1);
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e);
        }
        return value -> this.invoke(method, value, metadata, arg);
    }

    private String invoke(Method method, Object value, ValidationMetadata<?> metadata, Object arg) {
        Object[] objectArray;
        if (arg == null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = value;
            objectArray = objectArray2;
            objectArray2[1] = metadata;
        } else {
            Object[] objectArray3 = new Object[3];
            objectArray3[0] = value;
            objectArray3[1] = metadata;
            objectArray = objectArray3;
            objectArray3[2] = arg;
        }
        Object[] args = objectArray;
        try {
            return (String)method.invoke(null, args);
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    private Method lookupMethod(String className, String methodName, Class<?> valueType, int arity) throws ClassNotFoundException, NoSuchMethodException {
        for (Method method : Class.forName(className).getMethods()) {
            if (!method.getName().equals(methodName) || !Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers()) || method.getReturnType() != String.class || method.getParameterCount() != arity || valueType != null && !method.getParameterTypes()[0].isAssignableFrom(valueType) || method.getParameterTypes()[1] != ValidationMetadata.class || method.getParameterCount() == 3 && method.getParameterTypes()[2] != String.class) continue;
            return method;
        }
        throw new NoSuchMethodException(className + "." + methodName);
    }
}

