/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.cornerstone.services.connection;

import org.apache.avalon.cornerstone.services.connection.ConnectionHandler;
import org.apache.avalon.cornerstone.services.connection.ConnectionHandlerFactory;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.WrapperComponentManager;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public abstract class AbstractHandlerFactory
extends AbstractLogEnabled
implements Contextualizable,
Serviceable,
Configurable,
ConnectionHandlerFactory {
    private Context m_context;
    private ServiceManager m_serviceManager;
    private Configuration m_configuration;

    public void contextualize(Context context) {
        this.m_context = context;
    }

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.m_serviceManager = serviceManager;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.m_configuration = configuration;
    }

    public ConnectionHandler createConnectionHandler() throws Exception {
        ConnectionHandler handler = this.newHandler();
        ContainerUtil.enableLogging((Object)handler, (Logger)this.getLogger());
        ContainerUtil.contextualize((Object)handler, (Context)this.m_context);
        ContainerUtil.service((Object)handler, (ServiceManager)this.m_serviceManager);
        ContainerUtil.compose((Object)handler, (ComponentManager)new WrapperComponentManager(this.m_serviceManager));
        ContainerUtil.configure((Object)handler, (Configuration)this.m_configuration);
        ContainerUtil.initialize((Object)handler);
        return handler;
    }

    public void releaseConnectionHandler(ConnectionHandler connectionHandler) {
        ContainerUtil.dispose((Object)connectionHandler);
    }

    protected abstract ConnectionHandler newHandler() throws Exception;
}

