/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.util;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;

public final class MPIOutputStream {
    private final OutputStream os;

    public MPIOutputStream(OutputStream os) {
        this.os = os;
    }

    public void close() throws IOException {
        this.os.close();
    }

    public void flush() throws IOException {
        this.os.flush();
    }

    public void write(BigInteger bi) throws IOException {
        byte[] tmp = bi.toByteArray();
        short upperTwo = (short)(tmp[0] << 8 | tmp[1]);
        if (upperTwo != 0) {
            throw new IOException("bi: unsupported value");
        }
        this.os.write(tmp, 2, tmp.length - 2);
    }
}

