/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.Support;

public class KeyGenerator {
    private final KeyGeneratorSpi spi;
    private final Provider provider;
    private final String algorithm;

    protected KeyGenerator(KeyGeneratorSpi keyGenSpi, Provider provider, String algorithm) {
        this.spi = keyGenSpi;
        this.provider = provider;
        this.algorithm = algorithm;
    }

    public final SecretKey generateKey() {
        return this.spi.engineGenerateKey();
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static final KeyGenerator getInstance(String algorithm) throws NoSuchAlgorithmException {
        Object[] o = Support.getImplementation("KeyGenerator", algorithm);
        return new KeyGenerator((KeyGeneratorSpi)o[0], (Provider)o[1], algorithm);
    }

    public static final KeyGenerator getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Object[] o = Support.getImplementation("KeyGenerator", algorithm, provider);
        return new KeyGenerator((KeyGeneratorSpi)o[0], (Provider)o[1], algorithm);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(int strength) {
        this.spi.engineInit(strength, new SecureRandom());
    }

    public final void init(int strength, SecureRandom random) {
        this.spi.engineInit(strength, random);
    }

    public final void init(SecureRandom random) {
        this.spi.engineInit(random);
    }

    public final void init(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        this.spi.engineInit(params, new SecureRandom());
    }

    public final void init(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        this.spi.engineInit(params, random);
    }
}

