/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.rsa;

import cryptix.jce.provider.asn.AsnAlgorithmId;
import cryptix.jce.provider.asn.AsnBitString;
import cryptix.jce.provider.asn.AsnInteger;
import cryptix.jce.provider.asn.AsnObjectId;
import cryptix.jce.provider.asn.AsnOutputStream;
import cryptix.jce.provider.asn.AsnSequence;
import java.io.IOException;
import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;

public final class RSAPublicKeyImpl
implements RSAPublicKey {
    private final BigInteger n;
    private final BigInteger e;

    public RSAPublicKeyImpl(BigInteger n, BigInteger e) {
        this.n = n;
        this.e = e;
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public byte[] getEncoded() {
        try {
            AsnOutputStream aos = new AsnOutputStream();
            aos.write(new AsnSequence(new AsnInteger(this.n), new AsnInteger(this.e)));
            byte[] bitStringBytes = aos.toByteArray();
            aos = new AsnOutputStream();
            aos.write(new AsnSequence(new AsnAlgorithmId(AsnObjectId.OID_rsaEncryption), new AsnBitString(bitStringBytes)));
            return aos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new InternalError("PANIC: Unexpected exception during ASN encoding...");
        }
    }

    public String getFormat() {
        return "X.509";
    }

    public BigInteger getModulus() {
        return this.n;
    }

    public BigInteger getPublicExponent() {
        return this.e;
    }
}

