/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.io;

import cryptix.openpgp.io.PGPPacketDataOutputStream;
import cryptix.openpgp.util.PGPUpdateable;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;

public class PGPHashDataOutputStream
extends PGPPacketDataOutputStream {
    private MessageDigest md;
    private PGPUpdateable signer;
    private int bytesWritten = 0;

    public PGPHashDataOutputStream(MessageDigest md) {
        super(null, (byte)6);
        this.md = md;
        this.signer = null;
    }

    public PGPHashDataOutputStream(MessageDigest md, PGPUpdateable signer) {
        super(null, (byte)6);
        this.md = md;
        this.signer = signer;
    }

    protected void writeDirect(int b) throws IOException {
        this.md.update((byte)b);
        if (this.signer != null) {
            byte[] bb = new byte[]{(byte)b};
            this.signer.update(bb);
        }
        ++this.bytesWritten;
    }

    protected void writeLength(OutputStream out, long len) throws IOException {
        if (len > 65535L) {
            throw new InternalError("Length > 65535.");
        }
        this.writeDirect(153);
        this.writeDirect((int)len >> 8);
        this.writeDirect((int)len & 0xFF);
    }

    protected void writePartialLength(OutputStream out, long len) throws IOException {
        throw new InternalError("Partial lengths not allowed on public keys when calculating a hash.");
    }
}

