/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.io;

import cryptix.openpgp.io.PGPLengthDataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PGPSignatureDataOutputStream
extends PGPLengthDataOutputStream {
    private byte packetID;

    public PGPSignatureDataOutputStream(OutputStream out, byte packetID) {
        super(out);
        this.packetID = packetID;
    }

    protected void writeLength(OutputStream out, long len) throws IOException {
        this.writePacketLength(out, len + 1L);
        out.write(this.packetID);
    }

    private void writePacketLength(OutputStream out, long len) throws IOException {
        if (len < 0L) {
            throw new IllegalArgumentException("Negative length not allowed");
        }
        if (len < 192L) {
            out.write((int)len);
        } else if (len < 16320L) {
            out.write((int)((len - 192L >> 8) + 192L));
            out.write((int)(len - 192L & 0xFFL));
        } else if (len < 0x100000000L) {
            out.write(255);
            out.write((int)(len >> 24));
            out.write((int)(len >> 16 & 0xFFL));
            out.write((int)(len >> 8 & 0xFFL));
            out.write((int)(len & 0xFFL));
        } else {
            throw new IllegalArgumentException("Maximum length exceeded");
        }
    }

    protected void writePartialLength(OutputStream out, long len) throws IOException {
        throw new RuntimeException("Partial lengths not supported in Signature Subpackets.");
    }
}

