/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.net;

import cryptix.message.MessageException;
import cryptix.message.MessageFactory;
import cryptix.openpgp.net.KeyServerIOException;
import cryptix.openpgp.net.PGPKeyServer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public abstract class PGPKeyServerImpl
implements PGPKeyServer {
    private MessageFactory mfactory;

    public PGPKeyServerImpl(String format) throws NoSuchAlgorithmException {
        this.mfactory = MessageFactory.getInstance((String)format);
    }

    public Collection fetchById(String id) throws KeyServerIOException, MessageException {
        try {
            ArrayList bundles = new ArrayList();
            Iterator it = this.fetchRaw(id);
            while (it.hasNext()) {
                String ascii = (String)it.next();
                ByteArrayInputStream in = new ByteArrayInputStream(ascii.getBytes());
                Collection list = this.mfactory.generateMessages((InputStream)in);
                in.close();
                Iterator msgs = list.iterator();
                while (msgs.hasNext()) {
                    bundles.add(msgs.next());
                }
            }
            return bundles;
        }
        catch (IOException e) {
            throw new MessageException("An I/O error occured during internal message processing.  " + e.getMessage());
        }
    }

    public abstract Iterator fetchRaw(String var1) throws KeyServerIOException;
}

