/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.provider;

import cryptix.message.stream.MessageStreamException;
import cryptix.message.stream.SignedMessageOutputStreamSpi;
import cryptix.openpgp.PGPPrivateKey;
import cryptix.openpgp.PGPPublicKey;
import cryptix.openpgp.algorithm.PGPAlgorithmFactory;
import cryptix.openpgp.algorithm.PGPSigner;
import cryptix.openpgp.packet.PGPOnePassSignaturePacket;
import cryptix.openpgp.packet.PGPSignaturePacket;
import cryptix.openpgp.provider.PGPKeyIDFactory;
import cryptix.openpgp.signature.PGPDateSP;
import cryptix.openpgp.signature.PGPKeyIDSP;
import cryptix.pki.KeyBundle;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.util.Date;
import java.util.Vector;

public class PGPSignedMessageOutputStream
implements SignedMessageOutputStreamSpi {
    private OutputStream out;
    private SecureRandom sr;
    private boolean nodatawritten = true;
    private PGPPrivateKey signingkey;
    private byte[] keyid;
    private byte algoid;
    private byte hashid;
    private byte type;
    private MessageDigest md;
    private PGPSigner signer;
    private boolean v4sig;

    protected PGPSignedMessageOutputStream(boolean v4sig) {
        this.v4sig = v4sig;
    }

    public void engineAddSigner(KeyBundle signingkey, char[] passphrase) throws IllegalStateException, IOException, MessageStreamException, UnrecoverableKeyException {
        if (this.sr == null) {
            throw new IllegalStateException("Not yet initialized.");
        }
        if (this.signingkey != null) {
            throw new RuntimeException("Nesting signatures not supported yet.");
        }
        PGPPublicKey pubkey = (PGPPublicKey)signingkey.getPublicKeys().next();
        this.engineAddSigner((PGPPrivateKey)signingkey.getPrivateKey((PublicKey)pubkey, passphrase));
    }

    public void engineAddSigner(PrivateKey signingkey) throws IllegalStateException, IOException, MessageStreamException {
        if (this.signingkey != null) {
            throw new RuntimeException("Nesting signatures not supported yet.");
        }
        this.signingkey = (PGPPrivateKey)signingkey;
        try {
            this.keyid = PGPKeyIDFactory.convert(signingkey).getBytes(8);
        }
        catch (InvalidKeyException ike) {
            throw new MessageStreamException(String.valueOf(String.valueOf(ike)));
        }
        this.algoid = this.signingkey.getPacket().getAlgorithmID();
        this.hashid = (byte)2;
        this.type = 0;
        PGPAlgorithmFactory factory = PGPAlgorithmFactory.getDefaultInstance();
        try {
            this.md = factory.getHashAlgorithm(this.hashid);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new MessageStreamException(String.valueOf(String.valueOf(nsae)));
        }
        this.signer = (PGPSigner)this.signingkey.getPacket().getAlgorithm();
        this.signer.initSign(this.hashid, factory);
    }

    public void engineClose() throws IOException, MessageStreamException {
        if (this.nodatawritten) {
            throw new MessageStreamException("No data written yet");
        }
        PGPSignaturePacket pkt = new PGPSignaturePacket();
        pkt.setPacketID((byte)2);
        if (this.v4sig) {
            PGPDateSP creation = new PGPDateSP();
            creation.setValue(new Date());
            creation.setPacketID((byte)2);
            Vector<PGPDateSP> hashed = new Vector<PGPDateSP>();
            hashed.addElement(creation);
            PGPKeyIDSP keyidsp = new PGPKeyIDSP();
            keyidsp.setValue(this.keyid);
            keyidsp.setPacketID((byte)16);
            Vector<PGPKeyIDSP> unhashed = new Vector<PGPKeyIDSP>();
            unhashed.addElement(keyidsp);
            pkt.setData(this.type, this.algoid, this.hashid, hashed, unhashed);
        } else {
            byte[] time = new byte[4];
            int unixTime = (int)(System.currentTimeMillis() / 1000L);
            time[0] = (byte)(unixTime >>> 24 & 0xFF);
            time[1] = (byte)(unixTime >>> 16 & 0xFF);
            time[2] = (byte)(unixTime >>> 8 & 0xFF);
            time[3] = (byte)(unixTime & 0xFF);
            pkt.setData(this.type, time, this.keyid, this.algoid, this.hashid);
        }
        int bytesWritten = pkt.hashData(this.md, this.signer);
        if (pkt.getVersion() == 4) {
            byte[] trailer = new byte[]{pkt.getVersion(), -1, (byte)(bytesWritten >> 24 & 0xFF), (byte)(bytesWritten >> 16 & 0xFF), (byte)(bytesWritten >> 8 & 0xFF), (byte)(bytesWritten & 0xFF)};
            this.md.update(trailer);
            this.signer.update(trailer);
        }
        byte[] digestcalc = this.md.digest();
        pkt.setHash(digestcalc);
        this.signer.computeSignature();
        pkt.setSignature(this.signer);
        pkt.encode(this.out);
        this.out.close();
    }

    public void engineFlush() throws IOException, MessageStreamException {
        this.out.flush();
    }

    public void engineInit(OutputStream out, SecureRandom sr) throws IllegalStateException, IOException, MessageStreamException {
        if (this.out != null) {
            throw new IllegalStateException("Already called init before");
        }
        if (out == null) {
            throw new IllegalArgumentException("Outputstream cannot be null");
        }
        this.out = out;
        this.sr = sr;
    }

    public void engineSetAttribute(String name, Object attr) throws IllegalStateException, IllegalArgumentException, MessageStreamException {
        throw new IllegalArgumentException("No attributes supported");
    }

    public void engineWrite(int b) throws IOException, MessageStreamException {
        byte[] b1 = new byte[]{(byte)b};
        this.engineWrite(b1, 0, 1);
    }

    public void engineWrite(byte[] b) throws IOException, MessageStreamException {
        this.engineWrite(b, 0, b.length);
    }

    public void engineWrite(byte[] b, int off, int len) throws IOException, MessageStreamException {
        if (this.out == null) {
            throw new IllegalStateException("Not yet initialized");
        }
        if (this.nodatawritten) {
            this.nodatawritten = false;
            PGPOnePassSignaturePacket opspkt = new PGPOnePassSignaturePacket(this.type, this.hashid, this.algoid, this.keyid, false);
            opspkt.setPacketID((byte)4);
            opspkt.encode(this.out);
        }
        this.out.write(b, off, len);
        this.md.update(b, off, len);
        this.signer.update(b, off, len);
    }

    public void writeNoData(int b) throws IOException, MessageStreamException {
        if (this.out == null) {
            throw new IllegalStateException("Not yet initialized");
        }
        if (this.nodatawritten) {
            this.nodatawritten = false;
            PGPOnePassSignaturePacket opspkt = new PGPOnePassSignaturePacket(this.type, this.hashid, this.algoid, this.keyid, false);
            opspkt.setPacketID((byte)4);
            opspkt.encode(this.out);
        }
        this.out.write(b);
    }

    public static class V4
    extends PGPSignedMessageOutputStream {
        public V4() {
            super(true);
        }
    }

    public static class V3
    extends PGPSignedMessageOutputStream {
        public V3() {
            super(false);
        }
    }
}

