/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp;

import cryptix.openpgp.packet.PGPIDPacket;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.Principal;

public abstract class PGPPrincipal
implements Principal {
    private PGPIDPacket packet;

    protected PGPPrincipal(PGPIDPacket pkt) {
        if (pkt == null) {
            throw new IllegalArgumentException("null argument");
        }
        this.packet = pkt;
    }

    public boolean equals(Object another) {
        if (!(another instanceof PGPPrincipal)) {
            return false;
        }
        PGPPrincipal that = (PGPPrincipal)another;
        return this.packet.equals(that.packet);
    }

    public byte[] getEncoded() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.packet.encode(baos);
            baos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new InternalError("IOException on ByteArrayOutputStream " + e);
        }
    }

    public String getName() {
        return this.packet.toString();
    }

    public PGPIDPacket getPacket() {
        return this.packet;
    }

    public int hashCode() {
        return this.packet.hashCode();
    }

    public String toString() {
        return this.getName();
    }
}

