/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.provider;

import cryptix.message.EncryptedMessage;
import cryptix.message.Message;
import cryptix.message.MessageException;
import cryptix.message.NotEncryptedToParameterException;
import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPDecryptionFailedException;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.PGPKeyBundle;
import cryptix.openpgp.PGPPrivateKey;
import cryptix.openpgp.PGPPublicKey;
import cryptix.openpgp.algorithm.PGPAlgorithmFactory;
import cryptix.openpgp.algorithm.PGPEncryptor;
import cryptix.openpgp.packet.PGPCompressedDataPacket;
import cryptix.openpgp.packet.PGPContainerPacket;
import cryptix.openpgp.packet.PGPEncryptedDataPacket;
import cryptix.openpgp.packet.PGPLiteralDataPacket;
import cryptix.openpgp.packet.PGPOnePassSignaturePacket;
import cryptix.openpgp.packet.PGPPacket;
import cryptix.openpgp.packet.PGPPublicKeyEncryptedSessionKeyPacket;
import cryptix.openpgp.packet.PGPSessionKey;
import cryptix.openpgp.packet.PGPSessionKeyPacket;
import cryptix.openpgp.packet.PGPSignaturePacket;
import cryptix.openpgp.provider.PGPLiteralMessageImpl;
import cryptix.openpgp.provider.PGPSignedMessageImpl;
import cryptix.pki.KeyBundle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.UnrecoverableKeyException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class PGPEncryptedMessageImpl
extends EncryptedMessage {
    private PGPSessionKeyPacket[] skps;
    private PGPEncryptedDataPacket pkt;

    public PGPEncryptedMessageImpl(PGPSessionKeyPacket[] skps, PGPEncryptedDataPacket pkt) {
        super("OpenPGP");
        this.skps = skps;
        this.pkt = pkt;
    }

    public Message decrypt(KeyBundle bundle, char[] passphrase) throws NotEncryptedToParameterException, MessageException, UnsupportedOperationException, UnrecoverableKeyException {
        if (!(bundle instanceof PGPKeyBundle)) {
            throw new IllegalArgumentException("Invalid key type, PGPKeyBundle expected.");
        }
        if (!((PGPKeyBundle)bundle).containsPrivateKey()) {
            throw new IllegalArgumentException("KeyBundle does not contain a private key.");
        }
        PGPKeyBundle pgpbundle = (PGPKeyBundle)bundle;
        Iterator it = pgpbundle.getPublicSubKeys();
        while (it.hasNext()) {
            PGPPublicKey pubsubkey = (PGPPublicKey)it.next();
            PGPPrivateKey privsubkey = (PGPPrivateKey)pgpbundle.getPrivateSubKey(pubsubkey, passphrase);
            try {
                return this.decrypt(privsubkey);
            }
            catch (NotEncryptedToParameterException notEncryptedToParameterException) {}
        }
        it = pgpbundle.getPublicKeys();
        PGPPublicKey pubmainkey = (PGPPublicKey)it.next();
        PGPPrivateKey privmainkey = (PGPPrivateKey)pgpbundle.getPrivateKey(pubmainkey, passphrase);
        if (privmainkey.getPacket().getAlgorithm() instanceof PGPEncryptor) {
            return this.decrypt(privmainkey);
        }
        throw new NotEncryptedToParameterException();
    }

    public Message decrypt(Key key) throws NotEncryptedToParameterException, MessageException, UnsupportedOperationException {
        if (!(key instanceof PGPPrivateKey)) {
            throw new IllegalArgumentException("Invalid key type, PGPPrivateKey expected.");
        }
        PGPPrivateKey pgpkey = (PGPPrivateKey)key;
        if (!(pgpkey.getPacket().getAlgorithm() instanceof PGPEncryptor)) {
            throw new IllegalArgumentException("Not an encryption key.");
        }
        PGPEncryptor cryptor = (PGPEncryptor)pgpkey.getPacket().getAlgorithm();
        Vector<PGPSessionKey> sessionkeys = new Vector<PGPSessionKey>();
        int i = 0;
        while (i < this.skps.length) {
            if (this.skps[i] instanceof PGPPublicKeyEncryptedSessionKeyPacket) {
                PGPPublicKeyEncryptedSessionKeyPacket pkeskp = (PGPPublicKeyEncryptedSessionKeyPacket)this.skps[i];
                boolean success = false;
                try {
                    pkeskp.decrypt(cryptor);
                    success = true;
                }
                catch (PGPDataFormatException pGPDataFormatException) {
                }
                catch (PGPDecryptionFailedException pGPDecryptionFailedException) {}
                if (success) {
                    sessionkeys.add(pkeskp.getSessionKey());
                }
            }
            ++i;
        }
        if (sessionkeys.size() == 0) {
            throw new NotEncryptedToParameterException();
        }
        PGPSessionKey[] sks = new PGPSessionKey[sessionkeys.size()];
        int i2 = 0;
        while (i2 < sks.length) {
            sks[i2] = (PGPSessionKey)sessionkeys.elementAt(i2);
            ++i2;
        }
        try {
            this.pkt.decrypt(sks, PGPAlgorithmFactory.getDefaultInstance());
        }
        catch (PGPDecryptionFailedException pGPDecryptionFailedException) {
            throw new NotEncryptedToParameterException();
        }
        catch (PGPDataFormatException e) {
            throw new MessageException(String.valueOf(String.valueOf(e)));
        }
        catch (PGPFatalDataFormatException e) {
            throw new MessageException(String.valueOf(String.valueOf(e)));
        }
        Enumeration pkts = this.pkt.listPackets();
        if (!pkts.hasMoreElements()) {
            throw new MessageException("No data found");
        }
        PGPPacket content = (PGPPacket)pkts.nextElement();
        if (content instanceof PGPCompressedDataPacket) {
            pkts = ((PGPContainerPacket)content).listPackets();
            if (!pkts.hasMoreElements()) {
                throw new MessageException("No data found");
            }
            content = (PGPPacket)pkts.nextElement();
        }
        if (content instanceof PGPOnePassSignaturePacket) {
            content = (PGPPacket)pkts.nextElement();
        }
        Object msg = null;
        if (content instanceof PGPLiteralDataPacket) {
            msg = new PGPLiteralMessageImpl((PGPLiteralDataPacket)content);
            if (pkts.hasMoreElements()) {
                content = (PGPPacket)pkts.nextElement();
            }
        }
        if (content instanceof PGPSignaturePacket) {
            PGPPacket more;
            if (msg == null && pkts.hasMoreElements() && (more = (PGPPacket)pkts.nextElement()) instanceof PGPLiteralDataPacket) {
                msg = new PGPLiteralMessageImpl((PGPLiteralDataPacket)more);
            }
            if (msg == null) {
                throw new MessageException("Could not find any data I understand. (Lone sig)");
            }
            msg = new PGPSignedMessageImpl(false, (PGPSignaturePacket)content, (PGPLiteralMessageImpl)((Object)msg));
        }
        if (msg == null) {
            throw new MessageException("Could not find any data I understand.");
        }
        return msg;
    }

    public Message decrypt(char[] passphrase) throws NotEncryptedToParameterException, MessageException, UnsupportedOperationException {
        throw new RuntimeException("NYI");
    }

    public Object getAttribute(String name) throws IllegalArgumentException, MessageException {
        throw new IllegalArgumentException("Attributes not supported.");
    }

    public byte[] getEncoded() throws MessageException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int i = 0;
            while (i < this.skps.length) {
                this.skps[i].encode(baos);
                ++i;
            }
            this.pkt.encode(baos);
            baos.close();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new RuntimeException("IOException in ByteArrayOutputStream - " + ioe);
        }
    }
}

