/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.signature;

import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.io.PGPSignatureDataInputStream;
import cryptix.openpgp.io.PGPSignatureDataOutputStream;
import cryptix.openpgp.signature.PGPSignatureSubPacket;
import cryptix.openpgp.util.PGPCompare;
import java.io.IOException;

public class PGPRevocationKeySP
extends PGPSignatureSubPacket {
    private byte[] fingerprint;
    private byte revocationclass = (byte)-128;
    private byte algid = 0;

    protected void decodeBody(PGPSignatureDataInputStream in) throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        byte b = in.readByte();
        if ((b & 0x80) == 0) {
            in.readByteArray();
            throw new PGPDataFormatException("Invalid class in revocation packet");
        }
        this.setRevocationClass(b);
        this.setAlgID(in.readByte());
        byte[] fp = new byte[20];
        in.readFully(fp);
        this.setFingerprint(fp);
    }

    protected void encodeBody(PGPSignatureDataOutputStream out) throws IOException {
        if (this.getFingerprint() == null || (this.getRevocationClass() & 0x80) == 0) {
            throw new IllegalStateException("Packet data not initialized");
        }
        out.writeByte(this.getRevocationClass());
        out.writeByte(this.getAlgID());
        out.writeFully(this.getFingerprint());
    }

    public boolean equals(Object ssp) {
        if (!(ssp instanceof PGPRevocationKeySP)) {
            return false;
        }
        PGPRevocationKeySP that = (PGPRevocationKeySP)ssp;
        return PGPCompare.equals(this.getPacketID(), that.getPacketID()) && PGPCompare.equals(this.getFingerprint(), that.getFingerprint()) && PGPCompare.equals(this.getRevocationClass(), that.getRevocationClass()) && PGPCompare.equals(this.getAlgID(), that.getAlgID());
    }

    public byte getAlgID() {
        return this.algid;
    }

    public byte[] getFingerprint() {
        return this.fingerprint;
    }

    public byte getRevocationClass() {
        return this.revocationclass;
    }

    public boolean getSensitive() {
        return (this.revocationclass & 0x40) != 0;
    }

    public void setAlgID(byte algid) {
        this.algid = algid;
    }

    public void setFingerprint(byte[] fp) {
        if (fp.length != 20) {
            throw new IllegalArgumentException("Fingerprint must be 20 bytes");
        }
        this.fingerprint = fp;
    }

    public void setRevocationClass(byte cl) {
        if ((cl & 0x80) == 0) {
            throw new IllegalArgumentException("Illegal revocation class");
        }
        this.revocationclass = cl;
    }

    public void setSensitive(boolean sensitive) {
        this.revocationclass = sensitive ? (byte)(this.revocationclass | 0x40) : (byte)(this.revocationclass & 0xBF);
    }
}

