/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.signature;

import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.io.PGPSignatureDataInputStream;
import cryptix.openpgp.io.PGPSignatureDataOutputStream;
import cryptix.openpgp.signature.PGPSignatureSubPacket;
import cryptix.openpgp.util.PGPCompare;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class PGPStringSP
extends PGPSignatureSubPacket {
    private String value;

    protected void decodeBody(PGPSignatureDataInputStream in) throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        byte[] bytes = in.readByteArray();
        try {
            String value = new String(bytes, "UTF-8");
            if (value.length() == 0) {
                throw new PGPDataFormatException("No data found.");
            }
            this.setValue(value);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError("Unsupported Encoding: UTF-8");
        }
    }

    protected void encodeBody(PGPSignatureDataOutputStream out) throws IOException {
        if (this.getValue() == null) {
            throw new IllegalStateException("Packet data not initialized");
        }
        try {
            byte[] bytes = this.getValue().getBytes("UTF-8");
            out.writeFully(bytes);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError("Unsupported Encoding: UTF-8");
        }
    }

    public boolean equals(Object ssp) {
        if (!(ssp instanceof PGPStringSP)) {
            return false;
        }
        PGPStringSP that = (PGPStringSP)ssp;
        return PGPCompare.equals(this.getPacketID(), that.getPacketID()) && PGPCompare.equals(this.getValue(), that.getValue());
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        if (value.length() == 0) {
            throw new IllegalArgumentException("String length == 0");
        }
        this.value = value;
    }
}

