/*
 * Decompiled with CFR 0.152.
 */
package cryptix.pki;

import cryptix.pki.PrincipalBuilderSpi;
import cryptix.pki.PrincipalException;
import cryptix.pki.Support;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;

public class PrincipalBuilder {
    private final PrincipalBuilderSpi spi;
    private final Provider provider;
    private final String format;

    protected PrincipalBuilder(PrincipalBuilderSpi builderSpi, Provider provider, String format) {
        this.spi = builderSpi;
        this.provider = provider;
        this.format = format;
    }

    public final Principal build(Object contents) throws PrincipalException {
        return this.spi.engineBuild(contents);
    }

    public final String getFormat() {
        return this.format;
    }

    public static PrincipalBuilder getInstance(String format) throws NoSuchAlgorithmException {
        Object[] o = Support.getImplementation("PrincipalBuilder", format);
        return new PrincipalBuilder((PrincipalBuilderSpi)o[0], (Provider)o[1], format);
    }

    public static PrincipalBuilder getInstance(String format, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Object[] o = Support.getImplementation("PrincipalBuilder", format, provider);
        return new PrincipalBuilder((PrincipalBuilderSpi)o[0], (Provider)o[1], format);
    }

    public static PrincipalBuilder getInstance(String format, Provider provider) throws NoSuchAlgorithmException {
        Object[] o = Support.getImplementation("PrincipalBuilder", format, provider);
        return new PrincipalBuilder((PrincipalBuilderSpi)o[0], (Provider)o[1], format);
    }

    public final Provider getProvider() {
        return this.provider;
    }
}

