/*
 * Decompiled with CFR 0.152.
 */
package cz.active24.client.fred.eppclient;

import cz.active24.client.fred.exception.SchemaValidationException;
import cz.active24.client.fred.exception.SystemException;
import cz.nic.xml.epp.keyset_1.ObjectFactory;
import ietf.params.xml.ns.epp_1.EppType;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.JAXBIntrospector;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class EppClientMarshallerHelper {
    private static final Log log = LogFactory.getLog(EppClientMarshallerHelper.class);
    private JAXBContext jaxbContext;
    private Schema schema;
    private Properties properties;

    public EppClientMarshallerHelper(Properties properties) {
        this.properties = properties;
    }

    public Object unmarshal(Node node) throws SystemException, SchemaValidationException {
        Unmarshaller jaxbUnmarshaller = this.getUnmarshaller();
        try {
            return JAXBIntrospector.getValue((Object)jaxbUnmarshaller.unmarshal(node));
        }
        catch (JAXBException e) {
            if (e.getLinkedException() instanceof SAXParseException) {
                String message = "Provided data are wrong, validation against schema failed!";
                log.error((Object)message, (Throwable)e);
                throw new SchemaValidationException(message, e.getMessage(), e);
            }
            log.error((Object)"Something happen when unmarshalling data from xml!", (Throwable)e);
            throw new SystemException(e.getMessage(), e);
        }
    }

    EppType unmarshal(String xml) throws SystemException, SchemaValidationException {
        Unmarshaller jaxbUnmarshaller = this.getUnmarshaller();
        try {
            return (EppType)JAXBIntrospector.getValue((Object)jaxbUnmarshaller.unmarshal((Reader)new StringReader(xml)));
        }
        catch (JAXBException e) {
            if (e.getLinkedException() instanceof SAXParseException) {
                String message = "Response data are wrong, validation against schema failed!";
                log.error((Object)message, (Throwable)e);
                throw new SchemaValidationException(message, e.getMessage(), e);
            }
            log.error((Object)"Something happen when unmarshalling data from xml!", (Throwable)e);
            throw new SystemException(e.getMessage(), e);
        }
    }

    String marshal(Object command) throws SystemException, SchemaValidationException {
        try {
            StringWriter result = new StringWriter();
            JAXBContext jaxbContext = this.getJaxbContext();
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            if (this.validateRequestAgainstSchema()) {
                jaxbMarshaller.setSchema(this.getSchema());
            }
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.marshal(command, (Writer)result);
            return result.toString();
        }
        catch (JAXBException e) {
            if (e.getLinkedException() instanceof SAXParseException) {
                String message = "Provided data are wrong, validation against schema failed!";
                log.error((Object)message, (Throwable)e);
                throw new SchemaValidationException(message, e.getMessage(), e);
            }
            log.error((Object)"Something happen when marshalling data into xml!", (Throwable)e);
            throw new SystemException(e.getMessage(), e);
        }
        catch (SAXException e) {
            String message = "Schema loading failed!";
            log.error((Object)message, (Throwable)e);
            throw new SystemException(e.getMessage(), e);
        }
    }

    private boolean validateRequestAgainstSchema() {
        return this.properties.getProperty("schema.validation.request").equalsIgnoreCase("true");
    }

    private boolean validateResponseAgainstSchema() {
        return this.properties.getProperty("schema.validation.response").equalsIgnoreCase("true");
    }

    private Unmarshaller getUnmarshaller() throws SystemException {
        try {
            JAXBContext jaxbContext = this.getJaxbContext();
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            if (this.validateResponseAgainstSchema()) {
                jaxbUnmarshaller.setSchema(this.getSchema());
            }
            return jaxbUnmarshaller;
        }
        catch (JAXBException e) {
            log.error((Object)"Something happen when creating unmarshaller", (Throwable)e);
            throw new SystemException(e.getMessage(), e);
        }
        catch (SAXException e) {
            String message = "Schema loading failed!";
            log.error((Object)message, (Throwable)e);
            throw new SystemException(e.getMessage(), e);
        }
    }

    private JAXBContext getJaxbContext() throws JAXBException {
        if (this.jaxbContext == null) {
            this.jaxbContext = JAXBContext.newInstance((Class[])this.getObjectFactories());
        }
        return this.jaxbContext;
    }

    Schema getSchema() throws SAXException {
        if (this.schema == null) {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            this.schema = schemaFactory.newSchema(new Source[]{new StreamSource(this.getClass().getResourceAsStream("/schema/eppcom-1.0.xsd")), new StreamSource(this.getClass().getResourceAsStream("/schema/epp-1.0.xsd")), new StreamSource(this.getClass().getResourceAsStream("/schema/fredcom-1.2.1.xsd")), new StreamSource(this.getClass().getResourceAsStream("/schema/contact-1.6.2.xsd")), new StreamSource(this.getClass().getResourceAsStream("/schema/domain-1.4.2.xsd")), new StreamSource(this.getClass().getResourceAsStream("/schema/nsset-1.2.2.xsd")), new StreamSource(this.getClass().getResourceAsStream("/schema/fred-1.5.0.xsd")), new StreamSource(this.getClass().getResourceAsStream("/schema/enumval-1.2.0.xsd")), new StreamSource(this.getClass().getResourceAsStream("/schema/keyset-1.3.2.xsd")), new StreamSource(this.getClass().getResourceAsStream("/schema/extra-addr-1.0.0.xsd"))});
        }
        return this.schema;
    }

    private Class[] getObjectFactories() {
        return (Class[])Arrays.asList(ietf.params.xml.ns.epp_1.ObjectFactory.class, cz.nic.xml.epp.domain_1.ObjectFactory.class, cz.nic.xml.epp.nsset_1.ObjectFactory.class, cz.nic.xml.epp.contact_1.ObjectFactory.class, ObjectFactory.class, cz.nic.xml.epp.enumval_1.ObjectFactory.class, cz.nic.xml.epp.fred_1.ObjectFactory.class, cz.nic.xml.epp.extra_addr_1.ObjectFactory.class, cz.nic.xml.epp.fredcom_1.ObjectFactory.class, ietf.params.xml.ns.eppcom_1.ObjectFactory.class).toArray();
    }
}

