/*
 * Decompiled with CFR 0.152.
 */
package cz.active24.client.fred.eppclient.objectstrategy;

import cz.active24.client.fred.data.check.CheckRequest;
import cz.active24.client.fred.data.check.CheckResponse;
import cz.active24.client.fred.data.check.keyset.KeysetCheckRequest;
import cz.active24.client.fred.data.check.keyset.KeysetCheckResponse;
import cz.active24.client.fred.data.create.CreateRequest;
import cz.active24.client.fred.data.create.CreateResponse;
import cz.active24.client.fred.data.create.keyset.KeysetCreateRequest;
import cz.active24.client.fred.data.create.keyset.KeysetCreateResponse;
import cz.active24.client.fred.data.creditinfo.other.CreditInfoRequest;
import cz.active24.client.fred.data.creditinfo.other.CreditInfoResponse;
import cz.active24.client.fred.data.delete.DeleteRequest;
import cz.active24.client.fred.data.delete.DeleteResponse;
import cz.active24.client.fred.data.delete.keyset.KeysetDeleteRequest;
import cz.active24.client.fred.data.delete.keyset.KeysetDeleteResponse;
import cz.active24.client.fred.data.info.InfoRequest;
import cz.active24.client.fred.data.info.InfoResponse;
import cz.active24.client.fred.data.info.keyset.KeysetInfoRequest;
import cz.active24.client.fred.data.info.keyset.KeysetInfoResponse;
import cz.active24.client.fred.data.list.ListRequest;
import cz.active24.client.fred.data.list.ListResponse;
import cz.active24.client.fred.data.list.ListResultsHelper;
import cz.active24.client.fred.data.list.ListType;
import cz.active24.client.fred.data.list.keyset.KeysetsByContactListRequest;
import cz.active24.client.fred.data.list.keyset.KeysetsListRequest;
import cz.active24.client.fred.data.login.other.LoginRequest;
import cz.active24.client.fred.data.login.other.LoginResponse;
import cz.active24.client.fred.data.logout.other.LogoutRequest;
import cz.active24.client.fred.data.logout.other.LogoutResponse;
import cz.active24.client.fred.data.poll.PollAcknowledgementRequest;
import cz.active24.client.fred.data.poll.PollAcknowledgementResponse;
import cz.active24.client.fred.data.poll.PollRequest;
import cz.active24.client.fred.data.poll.PollResponse;
import cz.active24.client.fred.data.renew.domain.DomainRenewRequest;
import cz.active24.client.fred.data.renew.domain.DomainRenewResponse;
import cz.active24.client.fred.data.sendauthinfo.SendAuthInfoRequest;
import cz.active24.client.fred.data.sendauthinfo.SendAuthInfoResponse;
import cz.active24.client.fred.data.sendauthinfo.keyset.KeysetSendAuthInfoRequest;
import cz.active24.client.fred.data.sendauthinfo.keyset.KeysetSendAuthInfoResponse;
import cz.active24.client.fred.data.testnsset.nsset.TestNssetRequest;
import cz.active24.client.fred.data.testnsset.nsset.TestNssetResponse;
import cz.active24.client.fred.data.transfer.TransferRequest;
import cz.active24.client.fred.data.transfer.TransferResponse;
import cz.active24.client.fred.data.transfer.keyset.KeysetTransferRequest;
import cz.active24.client.fred.data.transfer.keyset.KeysetTransferResponse;
import cz.active24.client.fred.data.update.UpdateRequest;
import cz.active24.client.fred.data.update.UpdateResponse;
import cz.active24.client.fred.data.update.keyset.KeysetUpdateRequest;
import cz.active24.client.fred.data.update.keyset.KeysetUpdateResponse;
import cz.active24.client.fred.eppclient.EppClient;
import cz.active24.client.fred.eppclient.EppClientImpl;
import cz.active24.client.fred.eppclient.EppCommandHelper;
import cz.active24.client.fred.eppclient.objectstrategy.ServerObjectStrategy;
import cz.active24.client.fred.exception.FredClientException;
import cz.active24.client.fred.mapper.FredClientDozerMapper;
import cz.nic.xml.epp.fred_1.ExtcommandType;
import cz.nic.xml.epp.fred_1.NssetsByContactT;
import cz.nic.xml.epp.keyset_1.ChkDataType;
import cz.nic.xml.epp.keyset_1.CrType;
import cz.nic.xml.epp.keyset_1.CreDataType;
import cz.nic.xml.epp.keyset_1.InfDataType;
import cz.nic.xml.epp.keyset_1.MNameType;
import cz.nic.xml.epp.keyset_1.ObjectFactory;
import cz.nic.xml.epp.keyset_1.SIDType;
import cz.nic.xml.epp.keyset_1.SendAuthInfoType;
import cz.nic.xml.epp.keyset_1.TransferType;
import cz.nic.xml.epp.keyset_1.UpdateType;
import ietf.params.xml.ns.epp_1.EppType;
import ietf.params.xml.ns.epp_1.ResponseType;
import java.util.Properties;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBIntrospector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KeysetStrategy
implements ServerObjectStrategy {
    private static final Log log = LogFactory.getLog(KeysetStrategy.class);
    private EppClient client;
    private EppCommandHelper eppCommandHelper;
    private FredClientDozerMapper mapper = FredClientDozerMapper.getInstance();
    private ListResultsHelper listResultsHelper;

    KeysetStrategy(Properties properties) {
        this.client = EppClientImpl.getInstance(properties);
        this.eppCommandHelper = new EppCommandHelper();
        this.listResultsHelper = new ListResultsHelper(this.client, this.eppCommandHelper);
    }

    @Override
    public InfoResponse callInfo(InfoRequest infoRequest) throws FredClientException {
        log.debug((Object)("keysetInfo called with request(" + infoRequest + ")"));
        KeysetInfoRequest keysetInfoRequest = (KeysetInfoRequest)infoRequest;
        SIDType sidType = new SIDType();
        sidType.setId(keysetInfoRequest.getId());
        JAXBElement<SIDType> wrapper = new ObjectFactory().createInfo(sidType);
        JAXBElement<EppType> requestElement = this.eppCommandHelper.createInfoEppCommand(wrapper, keysetInfoRequest.getClientTransactionId());
        ResponseType responseType = this.client.execute(requestElement);
        InfDataType infDataType = (InfDataType)JAXBIntrospector.getValue((Object)responseType.getResData().getAny().get(0));
        KeysetInfoResponse result = this.mapper.map(infDataType, KeysetInfoResponse.class);
        result.addResponseInfo(responseType);
        return result;
    }

    @Override
    public SendAuthInfoResponse callSendAuthInfo(SendAuthInfoRequest sendAuthInfoRequest) throws FredClientException {
        log.debug((Object)("sendAuthInfo for keyset called with request(" + sendAuthInfoRequest + ")"));
        KeysetSendAuthInfoRequest request = (KeysetSendAuthInfoRequest)sendAuthInfoRequest;
        SendAuthInfoType sendAuthInfoType = new SendAuthInfoType();
        sendAuthInfoType.setId(request.getKeysetId());
        JAXBElement<SendAuthInfoType> wrapper = new ObjectFactory().createSendAuthInfo(sendAuthInfoType);
        JAXBElement<EppType> requestElement = this.eppCommandHelper.createSendAuthInfoEppCommand(wrapper, request.getClientTransactionId());
        ResponseType responseType = this.client.execute(requestElement);
        KeysetSendAuthInfoResponse result = new KeysetSendAuthInfoResponse();
        result.addResponseInfo(responseType);
        return result;
    }

    @Override
    public ListResponse callList(ListRequest listRequest) throws FredClientException {
        ExtcommandType extcommandType = null;
        if (ListType.LIST_ALL.equals((Object)listRequest.getListType())) {
            extcommandType = this.prepareListKeysetsCommand((KeysetsListRequest)listRequest);
        }
        if (ListType.KEYSETS_BY_CONTACT.equals((Object)listRequest.getListType())) {
            extcommandType = this.prepareKeysetsByContactCommand((KeysetsByContactListRequest)listRequest);
        }
        return this.listResultsHelper.prepareListAndGetResults(extcommandType);
    }

    @Override
    public CheckResponse callCheck(CheckRequest checkRequest) throws FredClientException {
        log.debug((Object)("nssetCheck called with request(" + checkRequest + ")"));
        KeysetCheckRequest keysetCheckRequest = (KeysetCheckRequest)checkRequest;
        MNameType mNameType = new MNameType();
        mNameType.getId().addAll(keysetCheckRequest.getKeysetIds());
        JAXBElement<MNameType> wrapper = new ObjectFactory().createCheck(mNameType);
        JAXBElement<EppType> requestElement = this.eppCommandHelper.createCheckEppCommand(wrapper, keysetCheckRequest.getClientTransactionId());
        ResponseType responseType = this.client.execute(requestElement);
        ChkDataType chkDataType = (ChkDataType)JAXBIntrospector.getValue((Object)responseType.getResData().getAny().get(0));
        KeysetCheckResponse result = this.mapper.map(chkDataType, KeysetCheckResponse.class);
        result.addResponseInfo(responseType);
        return result;
    }

    @Override
    public CreateResponse callCreate(CreateRequest createRequest) throws FredClientException {
        log.debug((Object)("keysetCreate called with request(" + createRequest + ")"));
        KeysetCreateRequest keysetCreateRequest = (KeysetCreateRequest)createRequest;
        CrType crType = this.mapper.map(keysetCreateRequest, CrType.class);
        JAXBElement<CrType> wrapper = new ObjectFactory().createCreate(crType);
        JAXBElement<EppType> requestElement = this.eppCommandHelper.createCreateEppCommand(wrapper, keysetCreateRequest.getClientTransactionId());
        ResponseType responseType = this.client.execute(requestElement);
        CreDataType creDataType = (CreDataType)JAXBIntrospector.getValue((Object)responseType.getResData().getAny().get(0));
        KeysetCreateResponse result = this.mapper.map(creDataType, KeysetCreateResponse.class);
        result.addResponseInfo(responseType);
        return result;
    }

    @Override
    public DomainRenewResponse callRenew(DomainRenewRequest renewRequest) throws FredClientException {
        log.debug((Object)("callRenew called with request(" + renewRequest + ")"));
        throw new UnsupportedOperationException("callRenew operation is not supported for object " + (Object)((Object)renewRequest.getServerObjectType()));
    }

    @Override
    public TransferResponse callTransfer(TransferRequest transferRequest) throws FredClientException {
        log.debug((Object)("callTransfer called with request(" + transferRequest + ")"));
        KeysetTransferRequest keysetTransferRequest = (KeysetTransferRequest)transferRequest;
        TransferType transferType = this.mapper.map(keysetTransferRequest, TransferType.class);
        JAXBElement<TransferType> wrapper = new ObjectFactory().createTransfer(transferType);
        JAXBElement<EppType> requestElement = this.eppCommandHelper.createTransferEppCommand(wrapper, keysetTransferRequest.getClientTransactionId());
        ResponseType responseType = this.client.execute(requestElement);
        KeysetTransferResponse result = new KeysetTransferResponse();
        result.addResponseInfo(responseType);
        return result;
    }

    @Override
    public DeleteResponse callDelete(DeleteRequest deleteRequest) throws FredClientException {
        log.debug((Object)("callDelete called with request(" + deleteRequest + ")"));
        KeysetDeleteRequest keysetDeleteRequest = (KeysetDeleteRequest)deleteRequest;
        SIDType sidType = new SIDType();
        sidType.setId(keysetDeleteRequest.getKeysetId());
        JAXBElement<SIDType> wrapper = new ObjectFactory().createDelete(sidType);
        JAXBElement<EppType> requestElement = this.eppCommandHelper.createDeleteEppCommand(wrapper, keysetDeleteRequest.getClientTransactionId());
        ResponseType responseType = this.client.execute(requestElement);
        KeysetDeleteResponse result = new KeysetDeleteResponse();
        result.addResponseInfo(responseType);
        return result;
    }

    @Override
    public CreditInfoResponse callCreditInfo(CreditInfoRequest creditInfoRequest) throws FredClientException {
        log.debug((Object)("callCreditInfo called with request(" + creditInfoRequest + ")"));
        throw new UnsupportedOperationException("callCreditInfo operation is not supported for object " + (Object)((Object)creditInfoRequest.getServerObjectType()));
    }

    @Override
    public TestNssetResponse callTestNsset(TestNssetRequest testNssetRequest) throws FredClientException {
        log.debug((Object)("callTestNsset called with request(" + testNssetRequest + ")"));
        throw new UnsupportedOperationException("callTestNsset operation is not supported for object " + (Object)((Object)testNssetRequest.getServerObjectType()));
    }

    @Override
    public PollResponse callPollRequest(PollRequest pollRequest) throws FredClientException {
        log.debug((Object)("callPollRequest called with request(" + pollRequest + ")"));
        throw new UnsupportedOperationException("callPollRequest operation is not supported for object " + (Object)((Object)pollRequest.getServerObjectType()));
    }

    @Override
    public PollAcknowledgementResponse callPollAcknowledgement(PollAcknowledgementRequest pollAcknowledgementRequest) throws FredClientException {
        log.debug((Object)("callPollAcknowledgement called with request(" + pollAcknowledgementRequest + ")"));
        throw new UnsupportedOperationException("callPollAcknowledgement operation is not supported for object " + (Object)((Object)pollAcknowledgementRequest.getServerObjectType()));
    }

    @Override
    public UpdateResponse callUpdate(UpdateRequest updateRequest) throws FredClientException {
        log.debug((Object)("callUpdate called with request(" + updateRequest + ")"));
        KeysetUpdateRequest keysetUpdateRequest = (KeysetUpdateRequest)updateRequest;
        UpdateType updateType = this.mapper.map(keysetUpdateRequest, UpdateType.class);
        JAXBElement<UpdateType> wrapper = new ObjectFactory().createUpdate(updateType);
        JAXBElement<EppType> requestElement = this.eppCommandHelper.createUpdateEppCommand(wrapper, keysetUpdateRequest.getClientTransactionId());
        ResponseType responseType = this.client.execute(requestElement);
        KeysetUpdateResponse result = new KeysetUpdateResponse();
        result.addResponseInfo(responseType);
        return result;
    }

    @Override
    public LoginResponse callLogin(LoginRequest loginRequest) throws FredClientException {
        log.debug((Object)("callLogin called with request(" + loginRequest + ")"));
        throw new UnsupportedOperationException("callLogin operation is not supported for object " + (Object)((Object)loginRequest.getServerObjectType()));
    }

    @Override
    public LogoutResponse callLogout(LogoutRequest logoutRequest) throws FredClientException {
        log.debug((Object)("callLogout called with request(" + logoutRequest + ")"));
        throw new UnsupportedOperationException("callLogin operation is not supported for object " + (Object)((Object)logoutRequest.getServerObjectType()));
    }

    private ExtcommandType prepareKeysetsByContactCommand(KeysetsByContactListRequest keysetsByContactListRequest) {
        log.debug((Object)("listKeysetsByContact called with request(" + keysetsByContactListRequest + ")"));
        NssetsByContactT keysetsByContact = new NssetsByContactT();
        keysetsByContact.setId(keysetsByContactListRequest.getContactId());
        return this.eppCommandHelper.createKeysetsByContactExtCommand(keysetsByContact, keysetsByContactListRequest.getClientTransactionId());
    }

    private ExtcommandType prepareListKeysetsCommand(KeysetsListRequest keysetsListRequest) {
        log.debug((Object)("listAllKeysets called with request(" + keysetsListRequest + ")"));
        ExtcommandType extcommandType = new ExtcommandType();
        extcommandType.setListKeysets("");
        extcommandType.setClTRID(keysetsListRequest.getClientTransactionId());
        return this.eppCommandHelper.createListKeysetsExtCommand(keysetsListRequest.getClientTransactionId());
    }
}

