/*
 * Decompiled with CFR 0.152.
 */
package cz.active24.client.fred.eppclient.objectstrategy;

import cz.active24.client.fred.data.check.CheckRequest;
import cz.active24.client.fred.data.check.CheckResponse;
import cz.active24.client.fred.data.create.CreateRequest;
import cz.active24.client.fred.data.create.CreateResponse;
import cz.active24.client.fred.data.creditinfo.other.CreditInfoRequest;
import cz.active24.client.fred.data.creditinfo.other.CreditInfoResponse;
import cz.active24.client.fred.data.delete.DeleteRequest;
import cz.active24.client.fred.data.delete.DeleteResponse;
import cz.active24.client.fred.data.info.InfoRequest;
import cz.active24.client.fred.data.info.InfoResponse;
import cz.active24.client.fred.data.list.ListRequest;
import cz.active24.client.fred.data.list.ListResponse;
import cz.active24.client.fred.data.login.other.LoginRequest;
import cz.active24.client.fred.data.login.other.LoginResponse;
import cz.active24.client.fred.data.logout.other.LogoutRequest;
import cz.active24.client.fred.data.logout.other.LogoutResponse;
import cz.active24.client.fred.data.poll.PollAcknowledgementRequest;
import cz.active24.client.fred.data.poll.PollAcknowledgementResponse;
import cz.active24.client.fred.data.poll.PollRequest;
import cz.active24.client.fred.data.poll.PollResponse;
import cz.active24.client.fred.data.renew.domain.DomainRenewRequest;
import cz.active24.client.fred.data.renew.domain.DomainRenewResponse;
import cz.active24.client.fred.data.sendauthinfo.SendAuthInfoRequest;
import cz.active24.client.fred.data.sendauthinfo.SendAuthInfoResponse;
import cz.active24.client.fred.data.testnsset.nsset.TestNssetRequest;
import cz.active24.client.fred.data.testnsset.nsset.TestNssetResponse;
import cz.active24.client.fred.data.transfer.TransferRequest;
import cz.active24.client.fred.data.transfer.TransferResponse;
import cz.active24.client.fred.data.update.UpdateRequest;
import cz.active24.client.fred.data.update.UpdateResponse;
import cz.active24.client.fred.eppclient.EppClient;
import cz.active24.client.fred.eppclient.EppClientImpl;
import cz.active24.client.fred.eppclient.EppClientMarshallerHelper;
import cz.active24.client.fred.eppclient.EppCommandHelper;
import cz.active24.client.fred.eppclient.SuccessfulResponse;
import cz.active24.client.fred.eppclient.objectstrategy.ServerObjectStrategy;
import cz.active24.client.fred.exception.FredClientException;
import cz.active24.client.fred.mapper.FredClientDozerMapper;
import cz.nic.xml.epp.fred_1.ResCreditType;
import ietf.params.xml.ns.epp_1.EppType;
import ietf.params.xml.ns.epp_1.MsgQType;
import ietf.params.xml.ns.epp_1.ResponseType;
import java.util.Properties;
import javax.xml.bind.JAXBElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

public class OtherStrategy
implements ServerObjectStrategy {
    private static final Log log = LogFactory.getLog(OtherStrategy.class);
    private EppClient client;
    private EppCommandHelper eppCommandHelper;
    private FredClientDozerMapper mapper = FredClientDozerMapper.getInstance();
    private EppClientMarshallerHelper marshallerHelper;

    OtherStrategy(Properties properties) {
        this.client = EppClientImpl.getInstance(properties);
        this.eppCommandHelper = new EppCommandHelper();
        this.marshallerHelper = new EppClientMarshallerHelper(properties);
    }

    @Override
    public InfoResponse callInfo(InfoRequest infoRequest) throws FredClientException {
        log.debug((Object)("callInfo called with request(" + infoRequest + ")"));
        throw new UnsupportedOperationException("callInfo operation is not supported for object " + (Object)((Object)infoRequest.getServerObjectType()));
    }

    @Override
    public SendAuthInfoResponse callSendAuthInfo(SendAuthInfoRequest sendAuthInfoRequest) throws FredClientException {
        log.debug((Object)("callSendAuthInfo called with request(" + sendAuthInfoRequest + ")"));
        throw new UnsupportedOperationException("callSendAuthInfo operation is not supported for object " + (Object)((Object)sendAuthInfoRequest.getServerObjectType()));
    }

    @Override
    public ListResponse callList(ListRequest listRequest) throws FredClientException {
        log.debug((Object)("callList called with request(" + listRequest + ")"));
        throw new UnsupportedOperationException("callList operation is not supported for object " + (Object)((Object)listRequest.getServerObjectType()));
    }

    @Override
    public CheckResponse callCheck(CheckRequest checkRequest) throws FredClientException {
        log.debug((Object)("callCheck called with request(" + checkRequest + ")"));
        throw new UnsupportedOperationException("callCheck operation is not supported for object " + (Object)((Object)checkRequest.getServerObjectType()));
    }

    @Override
    public CreateResponse callCreate(CreateRequest createRequest) throws FredClientException {
        log.debug((Object)("callCreate called with request(" + createRequest + ")"));
        throw new UnsupportedOperationException("callCreate operation is not supported for object " + (Object)((Object)createRequest.getServerObjectType()));
    }

    @Override
    public DomainRenewResponse callRenew(DomainRenewRequest renewRequest) throws FredClientException {
        log.debug((Object)("callRenew called with request(" + renewRequest + ")"));
        throw new UnsupportedOperationException("callRenew operation is not supported for object " + (Object)((Object)renewRequest.getServerObjectType()));
    }

    @Override
    public TransferResponse callTransfer(TransferRequest transferRequest) throws FredClientException {
        log.debug((Object)("callTransfer called with request(" + transferRequest + ")"));
        throw new UnsupportedOperationException("callTransfer operation is not supported for object " + (Object)((Object)transferRequest.getServerObjectType()));
    }

    @Override
    public DeleteResponse callDelete(DeleteRequest deleteRequest) throws FredClientException {
        log.debug((Object)("callDelete called with request(" + deleteRequest + ")"));
        throw new UnsupportedOperationException("callDelete operation is not supported for object " + (Object)((Object)deleteRequest.getServerObjectType()));
    }

    @Override
    public CreditInfoResponse callCreditInfo(CreditInfoRequest creditInfoRequest) throws FredClientException {
        log.debug((Object)("callCreditInfo called with request(" + creditInfoRequest + ")"));
        JAXBElement<EppType> requestElement = this.eppCommandHelper.createCreditInfoEppCommand(creditInfoRequest.getClientTransactionId());
        ResponseType responseType = this.client.execute(requestElement);
        JAXBElement wrapperBack = (JAXBElement)responseType.getResData().getAny().get(0);
        ResCreditType resCreditType = (ResCreditType)wrapperBack.getValue();
        CreditInfoResponse result = this.mapper.map(resCreditType, CreditInfoResponse.class);
        result.addResponseInfo(responseType);
        return result;
    }

    @Override
    public TestNssetResponse callTestNsset(TestNssetRequest testNssetRequest) throws FredClientException {
        log.debug((Object)("callTestNsset called with request(" + testNssetRequest + ")"));
        throw new UnsupportedOperationException("callTestNsset operation is not supported for object " + (Object)((Object)testNssetRequest.getServerObjectType()));
    }

    @Override
    public PollResponse callPollRequest(PollRequest pollRequest) throws FredClientException {
        log.debug((Object)("callPollRequest called with request(" + pollRequest + ")"));
        JAXBElement<EppType> requestElement = this.eppCommandHelper.createPollRequestEppCommand(pollRequest.getClientTransactionId());
        ResponseType responseType = this.client.execute(requestElement);
        PollResponse result = new PollResponse();
        result.addResponseInfo(responseType);
        if (SuccessfulResponse.RESPONSE_1301.getCode() == responseType.getResult().get(0).getCode()) {
            MsgQType msgQType = responseType.getMsgQ();
            Object unmarshalledMessage = this.marshallerHelper.unmarshal((Node)msgQType.getMsg().getContent().get(0));
            result = this.mapper.map(unmarshalledMessage, PollResponse.class);
            result.setMessageQDate(msgQType.getQDate().toGregorianCalendar().getTime());
            result.setMessageCount(msgQType.getCount().intValue());
            result.setMessageId(msgQType.getId());
        }
        return result;
    }

    @Override
    public PollAcknowledgementResponse callPollAcknowledgement(PollAcknowledgementRequest pollAcknowledgementRequest) throws FredClientException {
        log.debug((Object)("callPollAcknowledgement called with request(" + pollAcknowledgementRequest + ")"));
        JAXBElement<EppType> requestElement = this.eppCommandHelper.createPollAcknowledgementEppCommand(pollAcknowledgementRequest.getMsgID(), pollAcknowledgementRequest.getClientTransactionId());
        ResponseType responseType = this.client.execute(requestElement);
        PollAcknowledgementResponse result = new PollAcknowledgementResponse();
        result.addResponseInfo(responseType);
        if (responseType.getMsgQ() != null) {
            result.setId(responseType.getMsgQ().getId());
            result.setCount(responseType.getMsgQ().getCount().intValue());
        }
        return result;
    }

    @Override
    public UpdateResponse callUpdate(UpdateRequest updateRequest) {
        log.debug((Object)("callUpdate called with request(" + updateRequest + ")"));
        throw new UnsupportedOperationException("callUpdate operation is not supported for object " + (Object)((Object)updateRequest.getServerObjectType()));
    }

    @Override
    public LoginResponse callLogin(LoginRequest loginRequest) throws FredClientException {
        log.debug((Object)("callLogin called with request(" + loginRequest + ")"));
        ResponseType responseType = this.client.login(loginRequest.getNewPw(), loginRequest.getClientTransactionId());
        LoginResponse result = new LoginResponse();
        result.addResponseInfo(responseType);
        return result;
    }

    @Override
    public LogoutResponse callLogout(LogoutRequest logoutRequest) throws FredClientException {
        log.debug((Object)("callLogout called with request(" + logoutRequest + ")"));
        ResponseType responseType = this.client.logout(logoutRequest.getClientTransactionId());
        LogoutResponse result = new LogoutResponse();
        result.addResponseInfo(responseType);
        return result;
    }
}

