/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jopa;

import cz.cvut.kbss.jopa.PersistenceUtilImpl;
import cz.cvut.kbss.jopa.model.EntityManagerFactory;
import cz.cvut.kbss.jopa.model.PersistenceProvider;
import cz.cvut.kbss.jopa.model.PersistenceProviderResolverHolder;
import cz.cvut.kbss.jopa.model.PersistenceUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class Persistence {
    private static final PersistenceUtil pu = new PersistenceUtilImpl();

    private Persistence() {
        throw new AssertionError((Object)"No Persistence instances can be created.");
    }

    public static EntityManagerFactory createEntityManagerFactory(String persistenceUnitName) {
        return Persistence.createEntityManagerFactory(persistenceUnitName, Collections.emptyMap());
    }

    public static EntityManagerFactory createEntityManagerFactory(String persistenceUnitName, Map<String, String> properties) {
        HashMap<String, String> realParams = new HashMap<String, String>(properties);
        String className = (String)realParams.get("cz.cvut.kbss.jopa.model.PersistenceProvider");
        if (className == null) {
            throw new IllegalArgumentException("Missing persistence unit provider.");
        }
        List<PersistenceProvider> providers = PersistenceProviderResolverHolder.getPersistenceProviderResolver().getPersistenceProviders();
        Optional<PersistenceProvider> provider = providers.stream().filter(pp -> pp.getClass().getName().equals(className)).findFirst();
        return provider.orElseThrow(() -> new IllegalArgumentException("Type " + className + " is not a PersistenceProvider implementation.")).createEntityManagerFactory(persistenceUnitName, realParams);
    }

    public static PersistenceUtil getPersistenceUtil() {
        return pu;
    }
}

