/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jopa.model;

import cz.cvut.kbss.jopa.model.PersistenceProvider;
import cz.cvut.kbss.jopa.model.PersistenceProviderResolver;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPersistenceProviderResolver
implements PersistenceProviderResolver {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPersistenceProviderResolver.class);
    private static final ReferenceQueue<?> referenceQueue = new ReferenceQueue();
    private final HashMap<CacheKey, PersistenceProviderReference> providers = new HashMap();

    @Override
    public List<PersistenceProvider> getPersistenceProviders() {
        this.processQueue();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        CacheKey cacheKey = new CacheKey(loader);
        PersistenceProviderReference providersReferent = this.providers.get(cacheKey);
        if (providersReferent != null) {
            return (List)providersReferent.get();
        }
        ArrayList<PersistenceProvider> loadedProviders = new ArrayList<PersistenceProvider>();
        Iterator<PersistenceProvider> ipp = ServiceLoader.load(PersistenceProvider.class, loader).iterator();
        try {
            DefaultPersistenceProviderResolver.loadProvider(ipp).ifPresent(loadedProviders::add);
        }
        catch (ServiceConfigurationError sce) {
            LOG.warn("Unable to load PersistenceProvider implementation via service loader.", (Throwable)sce);
        }
        if (loadedProviders.isEmpty()) {
            LOG.warn("No valid providers found.");
        }
        providersReferent = new PersistenceProviderReference(loadedProviders, referenceQueue, cacheKey);
        this.providers.put(cacheKey, providersReferent);
        return loadedProviders;
    }

    private static Optional<PersistenceProvider> loadProvider(Iterator<PersistenceProvider> ipp) {
        try {
            return Optional.of(ipp.next());
        }
        catch (ServiceConfigurationError sce) {
            LOG.warn("Unable to load PersistenceProvider implementation via service loader.", (Throwable)sce);
            return Optional.empty();
        }
    }

    private void processQueue() {
        CacheKeyReference ref;
        while ((ref = (CacheKeyReference)((Object)referenceQueue.poll())) != null) {
            this.providers.remove(ref.getCacheKey());
        }
    }

    @Override
    public void clearCachedProviders() {
        this.providers.clear();
    }

    private class CacheKey
    implements Cloneable {
        private LoaderReference loaderRef;
        private int hashCodeCache;

        CacheKey(ClassLoader loader) {
            this.loaderRef = loader == null ? null : new LoaderReference(loader, referenceQueue, this);
            this.calculateHashCode();
        }

        ClassLoader getLoader() {
            return this.loaderRef != null ? (ClassLoader)this.loaderRef.get() : null;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !this.getClass().equals(other.getClass())) {
                return false;
            }
            CacheKey otherEntry = (CacheKey)other;
            if (this.hashCodeCache != otherEntry.hashCodeCache) {
                return false;
            }
            if (this.loaderRef == null) {
                return otherEntry.loaderRef == null;
            }
            ClassLoader loader = (ClassLoader)this.loaderRef.get();
            return otherEntry.loaderRef != null && loader != null && loader == otherEntry.loaderRef.get();
        }

        public int hashCode() {
            return this.hashCodeCache;
        }

        private void calculateHashCode() {
            ClassLoader loader = this.getLoader();
            if (loader != null) {
                this.hashCodeCache = loader.hashCode();
            }
        }

        public Object clone() {
            try {
                CacheKey clone = (CacheKey)super.clone();
                if (this.loaderRef != null) {
                    clone.loaderRef = new LoaderReference((ClassLoader)this.loaderRef.get(), referenceQueue, clone);
                }
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError(e);
            }
        }

        public String toString() {
            return "CacheKey[" + String.valueOf(this.getLoader()) + ")]";
        }
    }

    private class PersistenceProviderReference
    extends SoftReference<List<PersistenceProvider>>
    implements CacheKeyReference {
        private final CacheKey cacheKey;

        PersistenceProviderReference(List<PersistenceProvider> referent, ReferenceQueue q, CacheKey key) {
            super(referent, q);
            this.cacheKey = key;
        }

        @Override
        public CacheKey getCacheKey() {
            return this.cacheKey;
        }
    }

    private static interface CacheKeyReference {
        public CacheKey getCacheKey();
    }

    private class LoaderReference
    extends WeakReference<ClassLoader>
    implements CacheKeyReference {
        private final CacheKey cacheKey;

        LoaderReference(ClassLoader referent, ReferenceQueue q, CacheKey key) {
            super(referent, q);
            this.cacheKey = key;
        }

        @Override
        public CacheKey getCacheKey() {
            return this.cacheKey;
        }
    }
}

