/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jopa.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class MultilingualString
implements Serializable {
    private final Map<String, String> value;

    public MultilingualString() {
        this.value = new HashMap<String, String>(8);
    }

    public MultilingualString(Map<String, String> value) {
        this.value = new HashMap<String, String>(Objects.requireNonNull(value));
    }

    public MultilingualString set(String language, String value) {
        Objects.requireNonNull(value);
        this.value.put(language, value);
        return this;
    }

    public MultilingualString set(String value) {
        Objects.requireNonNull(value);
        this.value.put(null, value);
        return this;
    }

    public String get(String language) {
        return language != null ? this.value.get(language) : this.get();
    }

    public String get() {
        return this.value.getOrDefault(null, this.value.isEmpty() ? null : this.value.get(this.value.keySet().iterator().next()));
    }

    public boolean contains(String language) {
        return this.value.containsKey(language) || language == null && !this.value.isEmpty();
    }

    public boolean containsSimple() {
        return this.value.containsKey(null);
    }

    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    public void remove(String language) {
        this.value.remove(language);
    }

    public Set<String> getLanguages() {
        return Collections.unmodifiableSet(this.value.keySet());
    }

    public Map<String, String> getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultilingualString)) {
            return false;
        }
        MultilingualString that = (MultilingualString)o;
        return this.value.equals(that.getValue());
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value.toString();
    }

    public static MultilingualString create(String value, String language) {
        MultilingualString instance = new MultilingualString();
        instance.set(language, value);
        return instance;
    }
}

