/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jopa.model.descriptors;

import cz.cvut.kbss.jopa.exceptions.AmbiguousContextException;
import cz.cvut.kbss.jopa.model.descriptors.Descriptor;
import cz.cvut.kbss.jopa.model.metamodel.FieldSpecification;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public abstract class AbstractDescriptor
implements Descriptor {
    protected final Set<URI> contexts = new HashSet<URI>(4);
    protected final boolean assertionsInSubjectContext;
    private String language;
    private boolean hasLanguage;
    private boolean includeInferred = true;

    protected AbstractDescriptor() {
        this(true);
    }

    protected AbstractDescriptor(boolean assertionsInSubjectContext) {
        this.assertionsInSubjectContext = assertionsInSubjectContext;
    }

    protected AbstractDescriptor(URI context) {
        this(context, true);
    }

    protected AbstractDescriptor(URI context, boolean assertionsInSubjectContext) {
        if (context != null) {
            this.contexts.add(context);
        }
        this.assertionsInSubjectContext = assertionsInSubjectContext;
    }

    @Override
    public Set<URI> getContexts() {
        return Collections.unmodifiableSet(this.contexts);
    }

    @Override
    public Optional<URI> getSingleContext() {
        return AbstractDescriptor.retrieveSingleContext(this.contexts);
    }

    private static Optional<URI> retrieveSingleContext(Set<URI> col) {
        if (col.size() > 1) {
            throw new AmbiguousContextException("Expected at most one context, but got " + String.valueOf(col));
        }
        return col.isEmpty() ? Optional.empty() : Optional.of(col.iterator().next());
    }

    @Override
    public Descriptor addContext(URI context) {
        if (context == null) {
            this.contexts.clear();
        } else {
            this.contexts.add(context);
        }
        return this;
    }

    @Override
    public Optional<URI> getSingleAttributeContext(FieldSpecification<?, ?> attribute) {
        return AbstractDescriptor.retrieveSingleContext(this.getAttributeContexts(attribute));
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public boolean hasLanguage() {
        return this.hasLanguage;
    }

    @Override
    public Descriptor setLanguage(String languageTag) {
        this.language = languageTag;
        this.hasLanguage = true;
        return this;
    }

    @Override
    public Descriptor anyLanguage() {
        return this.setLanguage(null);
    }

    @Override
    public boolean areAssertionsInSubjectContext() {
        return this.assertionsInSubjectContext;
    }

    @Override
    public boolean includeInferred() {
        return this.includeInferred;
    }

    @Override
    public Descriptor disableInference() {
        this.includeInferred = false;
        return this;
    }

    @Override
    public Descriptor enableInference() {
        this.includeInferred = true;
        return this;
    }

    protected void setIncludeInferred(boolean includeInferred) {
        this.includeInferred = includeInferred;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractDescriptor)) {
            return false;
        }
        AbstractDescriptor that = (AbstractDescriptor)o;
        if (this.hasLanguage != that.hasLanguage) {
            return false;
        }
        if (this.assertionsInSubjectContext != that.assertionsInSubjectContext) {
            return false;
        }
        return Objects.equals(this.contexts, that.contexts) && Objects.equals(this.language, that.language);
    }

    public int hashCode() {
        int result = this.contexts.hashCode();
        result = 31 * result + (this.language != null ? this.language.hashCode() : 0);
        result = 31 * result + (this.hasLanguage ? 1 : 0);
        result = 31 * result + (this.assertionsInSubjectContext ? 1 : 0);
        return result;
    }

    public String toString() {
        return this.contexts.isEmpty() ? "default_context" : this.contexts.toString();
    }
}

