/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jopa.maven;

import cz.cvut.kbss.jopa.maven.Utils;
import cz.cvut.kbss.jopa.modelgen.ModelGenProcessor;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.GENERATE_SOURCES, name="modelgen")
public class ModelGenMojo
extends AbstractMojo {
    private static final String OUTPUT_DIRECTORY_PARAM = "output-directory";
    private static final String ADDITIONAL_SOURCES_PARAM = "additional-sources";
    private static final String SOURCE_PACKAGE_PARAM = "source-package";
    public static final String DEBUG_PARAM = "debug-option";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(name="output-directory", defaultValue="./target/generated-sources/static-metamodel")
    private String outputDirectory;
    @Parameter(name="source-package")
    private String sourcePackage;
    @Parameter(name="debug-option", defaultValue="false")
    private String debugOption;
    @Parameter(name="additional-sources")
    private String additionalSources;

    public void execute() {
        this.printParameterValues();
        this.getLog().info((CharSequence)"");
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        ArrayList<String> options = new ArrayList<String>();
        options.add("-processor");
        options.add(ModelGenProcessor.class.getName());
        Object[] classPathFiles = this.getClassPathFiles();
        String compileClassPath = StringUtils.join((Object[])classPathFiles, (String)File.pathSeparator);
        options.add("-cp");
        options.add(compileClassPath);
        options.add("-d");
        File folder = new File("./target/classes");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        options.add("./target/classes");
        if (StringUtils.isNotBlank((CharSequence)this.outputDirectory)) {
            options.add("-AoutputDirectory=" + this.outputDirectory);
        }
        if (StringUtils.isNotBlank((CharSequence)this.sourcePackage)) {
            options.add("-AsourcePackage=" + this.sourcePackage);
        }
        if (StringUtils.isNotBlank((CharSequence)this.debugOption)) {
            options.add("-AdebugOption=" + this.debugOption);
        }
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
        DiagnosticCollector<JavaFileObject> diagnosticCollector = new DiagnosticCollector<JavaFileObject>();
        ArrayList<File> sourceFiles = new ArrayList<File>();
        for (File directory : this.getSourceDirectories()) {
            sourceFiles.addAll(this.findFiles(directory.getPath()));
        }
        Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(sourceFiles);
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnosticCollector, options, null, compilationUnits);
        this.getLog().info((CharSequence)"Processing annotations.");
        task.call();
        this.logTaskDiagnostics(diagnosticCollector);
        this.getLog().info((CharSequence)"Static metamodel generated.");
        this.getLog().info((CharSequence)"------------------------------------------------------------------------");
    }

    private Set<File> getSourceDirectories() {
        HashSet<File> directories = new HashSet<File>();
        List<String> directoryNames = this.getCompileSourceRoots();
        for (String name : directoryNames) {
            File file = new File(name);
            if (!file.exists() || !file.isDirectory()) continue;
            directories.add(file);
        }
        return directories;
    }

    private List<String> getCompileSourceRoots() {
        List compileSourceRoots = this.project.getCompileSourceRoots();
        if (this.additionalSources != null && !this.additionalSources.isEmpty()) {
            compileSourceRoots.add(this.additionalSources);
        }
        return compileSourceRoots;
    }

    public List<File> findFiles(String directoryName) {
        ArrayList<File> resultList = new ArrayList<File>();
        File directory = new File(directoryName);
        File[] fList = directory.listFiles();
        if (fList != null) {
            for (File file : fList) {
                if (file.isFile()) {
                    resultList.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                resultList.addAll(this.findFiles(file.getAbsolutePath()));
            }
        }
        return resultList;
    }

    private File[] getClassPathFiles() {
        List classpathElements;
        TreeSet<File> files = new TreeSet<File>(this.getCurrentClassPath());
        try {
            classpathElements = this.project.getTestClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        for (Object o : classpathElements) {
            File file;
            if (o == null || !(file = new File(o.toString())).canRead()) continue;
            files.add(file);
        }
        return files.toArray(new File[0]);
    }

    private List<File> getCurrentClassPath() {
        ArrayList<File> retVal = new ArrayList<File>();
        URLClassLoader cl = (URLClassLoader)((Object)((Object)this)).getClass().getClassLoader();
        try {
            for (URL url : cl.getURLs()) {
                retVal.add(new File(url.toURI()));
            }
            return retVal;
        }
        catch (URISyntaxException exc) {
            throw new RuntimeException(exc.getMessage(), exc);
        }
    }

    private void logTaskDiagnostics(DiagnosticCollector<JavaFileObject> diagnosticCollector) {
        for (Diagnostic<JavaFileObject> diagnostic : diagnosticCollector.getDiagnostics()) {
            switch (diagnostic.getKind()) {
                case ERROR: {
                    this.getLog().error((CharSequence)diagnostic.getMessage(null));
                    break;
                }
                case WARNING: 
                case MANDATORY_WARNING: {
                    this.getLog().warn((CharSequence)diagnostic.getMessage(null));
                    break;
                }
                case NOTE: 
                case OTHER: {
                    this.getLog().info((CharSequence)diagnostic.getMessage(null));
                }
            }
        }
    }

    private void printParameterValues() {
        Utils.logParameterValue(OUTPUT_DIRECTORY_PARAM, this.outputDirectory, this.getLog());
        Utils.logParameterValue(SOURCE_PACKAGE_PARAM, this.sourcePackage, this.getLog());
        Utils.logParameterValue(DEBUG_PARAM, this.debugOption, this.getLog());
        Utils.logParameterValue(ADDITIONAL_SOURCES_PARAM, this.additionalSources, this.getLog());
    }
}

