/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jopa.maven;

import cz.cvut.kbss.jopa.maven.Utils;
import cz.cvut.kbss.jopa.owl2java.OWL2JavaTransformer;
import cz.cvut.kbss.jopa.owl2java.cli.PropertiesType;
import cz.cvut.kbss.jopa.owl2java.config.TransformationConfiguration;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="owl2java-transform", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class OWL2JavaMojo
extends AbstractMojo {
    private static final String MAPPING_FILE_PARAM = "mapping-file";
    private static final String PACKAGE_PARAM = "package";
    private static final String CONTEXT_PARAM = "context-name";
    private static final String ONTOLOGY_PARAM = "ontology-iri";
    private static final String OUTPUT_PARAM = "output-directory";
    private static final String W_OWLAPI_PARAM = "with-owlapi";
    private static final String ALL_IC_PARAM = "whole-ontology-as-ics";
    private static final String VOCABULARY_PARAM = "vocabulary-only";
    private static final String IGNORE_FAILED_IMPORTS_PARAM = "ignore-failed-imports";
    private static final String PROPERTIES_TYPE = "properties-type";
    private static final String GENERATE_JAVADOC = "javadoc-from-rdfs-comment";
    private static final String PREFER_MULTILINGUAL_STRINGS = "prefer-multilingual-strings";
    private static final String GENERATE_ANNOTATION_FIELDS = "generate-annotation-fields";
    private static final String GENERATE_THING = "generate-thing";
    private static final String ONTOLOGY_PREFIX_PROPERTY = "ontology-prefix-property";
    private static final String ALWAYS_USE_PREFIXES = "always-use-prefixes";
    private static final String PREFIX_MAPPING_FILE = "prefix-mapping-file";
    @Parameter(name="mapping-file")
    private String mappingFile;
    @Parameter(name="package", required=true)
    private String pPackage;
    @Parameter(name="context-name")
    private String contextName;
    @Parameter(name="ontology-iri")
    private String ontologyIri;
    @Parameter(name="output-directory", defaultValue="${project.basedir}/src/main/generated-sources")
    private String outputDirectory;
    @Parameter(name="with-owlapi", defaultValue="false")
    private boolean withOwlapi;
    @Parameter(name="whole-ontology-as-ics", defaultValue="false")
    private boolean wholeOntologyAsIcs;
    @Parameter(name="vocabulary-only", defaultValue="false")
    private boolean vocabularyOnly;
    @Parameter(name="ignore-failed-imports", defaultValue="false")
    private boolean ignoreFailedImports;
    @Parameter(name="properties-type", defaultValue="string")
    private String propertiesType;
    @Parameter(name="javadoc-from-rdfs-comment", defaultValue="true")
    private boolean javadocFromRdfsComment;
    @Parameter(name="prefer-multilingual-strings", defaultValue="true")
    private boolean preferMultilingualStrings;
    @Parameter(name="generate-annotation-fields", defaultValue="true")
    private boolean generateAnnotationFields;
    @Parameter(name="generate-thing", defaultValue="true")
    private boolean generateThing;
    @Parameter(name="ontology-prefix-property")
    private String ontologyPrefixProperty;
    @Parameter(name="always-use-prefixes", defaultValue="true")
    private boolean alwaysUsePrefixes;
    @Parameter(name="prefix-mapping-file")
    private String prefixMappingFile;

    public void execute() {
        OWL2JavaTransformer owl2java = new OWL2JavaTransformer();
        this.printParameterValues();
        if (this.ontologyIri == null) {
            this.getLog().error((CharSequence)"The parameter 'ontology-iri' is invalid. Must not be null.");
            this.getLog().error((CharSequence)"Skipping OWL2Java transformation.");
            return;
        }
        owl2java.ignoreMissingImports(this.ignoreFailedImports);
        if (this.mappingFile != null && !this.mappingFile.isEmpty()) {
            owl2java.setOntology(this.ontologyIri, this.mappingFile);
        } else {
            owl2java.setOntology(this.ontologyIri, null);
        }
        TransformationConfiguration.TransformationConfigurationBuilder builder = TransformationConfiguration.builder();
        if (!this.wholeOntologyAsIcs) {
            builder.context(this.contextName);
        }
        if (this.propertiesType != null) {
            builder.propertiesType(PropertiesType.valueOf((String)this.propertiesType));
        }
        TransformationConfiguration config = builder.packageName(this.pPackage).targetDir(this.outputDirectory).addOwlapiIris(this.withOwlapi).generateJavadoc(this.javadocFromRdfsComment).preferMultilingualStrings(this.preferMultilingualStrings).generateAnnotationFields(this.generateAnnotationFields).generateThing(this.generateThing).ontologyPrefixProperty(this.ontologyPrefixProperty).alwaysUseOntologyPrefix(this.alwaysUsePrefixes).prefixMappingFile(this.prefixMappingFile).build();
        if (this.vocabularyOnly) {
            owl2java.generateVocabulary(config);
        } else {
            owl2java.transform(config);
        }
        this.getLog().info((CharSequence)"OWL2Java successfully generated!");
    }

    private void printParameterValues() {
        Utils.logParameterValue(MAPPING_FILE_PARAM, this.mappingFile, this.getLog());
        Utils.logParameterValue(PACKAGE_PARAM, this.pPackage, this.getLog());
        Utils.logParameterValue(CONTEXT_PARAM, this.contextName, this.getLog());
        Utils.logParameterValue(ONTOLOGY_PARAM, this.ontologyIri, this.getLog());
        Utils.logParameterValue(OUTPUT_PARAM, this.outputDirectory, this.getLog());
        Utils.logParameterValue(W_OWLAPI_PARAM, this.withOwlapi, this.getLog());
        Utils.logParameterValue(ALL_IC_PARAM, this.wholeOntologyAsIcs, this.getLog());
        Utils.logParameterValue(VOCABULARY_PARAM, this.vocabularyOnly, this.getLog());
        Utils.logParameterValue(IGNORE_FAILED_IMPORTS_PARAM, this.ignoreFailedImports, this.getLog());
        Utils.logParameterValue(PROPERTIES_TYPE, this.propertiesType, this.getLog());
        Utils.logParameterValue(GENERATE_JAVADOC, this.javadocFromRdfsComment, this.getLog());
        Utils.logParameterValue(PREFER_MULTILINGUAL_STRINGS, this.preferMultilingualStrings, this.getLog());
        Utils.logParameterValue(GENERATE_ANNOTATION_FIELDS, this.generateAnnotationFields, this.getLog());
        Utils.logParameterValue(GENERATE_THING, this.generateThing, this.getLog());
        Utils.logParameterValue(ONTOLOGY_PREFIX_PROPERTY, this.ontologyPrefixProperty, this.getLog());
        Utils.logParameterValue(ALWAYS_USE_PREFIXES, this.alwaysUsePrefixes, this.getLog());
        Utils.logParameterValue(PREFIX_MAPPING_FILE, this.prefixMappingFile, this.getLog());
    }

    public String getPackage() {
        return this.pPackage;
    }

    public void setPackage(String pPackage) {
        this.pPackage = pPackage;
    }
}

