/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jopa.owl2java;

import cz.cvut.kbss.jopa.ic.api.DataParticipationConstraint;
import cz.cvut.kbss.jopa.ic.api.DataRangeConstraint;
import cz.cvut.kbss.jopa.owl2java.Card;
import cz.cvut.kbss.jopa.owl2java.ClassPropertyComputer;
import cz.cvut.kbss.jopa.owl2java.IntegrityConstraintSet;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLOntology;

public class ClassDataPropertyComputer
extends ClassPropertyComputer<DataParticipationConstraint, OWLDatatype> {
    public ClassDataPropertyComputer(OWLClass clazz, OWLDataProperty prop, IntegrityConstraintSet set, OWLOntology ontology) {
        boolean hasFiller = true;
        set.getClassDataIntegrityConstraints(clazz, prop).forEach(integrityConstraint -> {
            if (integrityConstraint instanceof DataParticipationConstraint) {
                this.constraints.add((DataParticipationConstraint)integrityConstraint);
            } else if (integrityConstraint instanceof DataRangeConstraint) {
                this.filler = ((DataRangeConstraint)integrityConstraint).getRange();
            }
        });
        if (this.filler == null) {
            hasFiller = false;
            this.filler = ontology.getOWLOntologyManager().getOWLDataFactory().getRDFPlainLiteral();
        }
        if (this.constraints.isEmpty() && !hasFiller) {
            this.card = Card.NO;
        } else {
            this.card = Card.MULTIPLE;
            for (DataParticipationConstraint opc : this.constraints) {
                OWLDatatype dt2 = (OWLDatatype)opc.getObject();
                if (!((OWLDatatype)this.getFiller()).equals(dt2) && !dt2.equals(OWLManager.getOWLDataFactory().getTopDatatype()) || opc.getMax() != 1) continue;
                this.card = Card.ONE;
                return;
            }
        }
    }
}

