/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jopa.owl2java;

import cz.cvut.kbss.jopa.ic.api.ObjectParticipationConstraint;
import cz.cvut.kbss.jopa.ic.api.ObjectRangeConstraint;
import cz.cvut.kbss.jopa.model.SequencesVocabulary;
import cz.cvut.kbss.jopa.owl2java.Card;
import cz.cvut.kbss.jopa.owl2java.ClassPropertyComputer;
import cz.cvut.kbss.jopa.owl2java.IntegrityConstraintSet;
import java.net.URI;
import java.util.Set;
import java.util.stream.Collectors;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.search.EntitySearcher;

public class ClassObjectPropertyComputer
extends ClassPropertyComputer<ObjectParticipationConstraint, OWLClass> {
    public ClassObjectPropertyComputer(OWLClass clazz, OWLObjectProperty prop, IntegrityConstraintSet set, OWLOntology merged) {
        boolean hasFiller = true;
        set.getClassObjectIntegrityConstraints(clazz, prop).forEach(ic -> {
            if (ic instanceof ObjectParticipationConstraint) {
                this.constraints.add((ObjectParticipationConstraint)ic);
            } else if (ic instanceof ObjectRangeConstraint) {
                this.filler = ((ObjectRangeConstraint)ic).getRange();
            }
        });
        if (this.filler == null) {
            hasFiller = false;
            this.filler = merged.getOWLOntologyManager().getOWLDataFactory().getOWLThing();
        }
        if (this.constraints.isEmpty() && !hasFiller) {
            this.card = Card.NO;
        } else {
            OWLDataFactory f = merged.getOWLOntologyManager().getOWLDataFactory();
            OWLClass object = (OWLClass)this.filler;
            Set superClasses = EntitySearcher.getSuperClasses((OWLClass)object, (OWLOntology)merged).collect(Collectors.toSet());
            if (superClasses.contains(f.getOWLClass(IRI.create((String)"http://swan.mindinformatics.org/ontologies/1.2/collections/List")))) {
                this.filler = new ClassObjectPropertyComputer(object, f.getOWLObjectProperty(IRI.create((String)"http://swan.mindinformatics.org/ontologies/1.2/collections/element")), set, merged).getFiller();
                this.card = Card.LIST;
            } else if (superClasses.contains(f.getOWLClass(IRI.create((URI)SequencesVocabulary.c_OWLSimpleList)))) {
                this.filler = new ClassObjectPropertyComputer(object, f.getOWLObjectProperty(IRI.create((URI)SequencesVocabulary.p_hasNext)), set, merged).getFiller();
                this.card = Card.SIMPLELIST;
            } else {
                this.card = Card.MULTIPLE;
                for (ObjectParticipationConstraint opc : this.constraints) {
                    OWLClass dt2 = (OWLClass)opc.getObject();
                    if (!((OWLClass)this.filler).equals(dt2) && !dt2.equals(OWLManager.getOWLDataFactory().getOWLThing()) || opc.getMax() != 1) continue;
                    this.card = Card.ONE;
                    break;
                }
            }
        }
    }
}

