/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jopa.owl2java;

import cz.cvut.kbss.jopa.owl2java.exception.OWL2JavaException;
import java.io.IOException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Properties;

public class Constants {
    public static final String P_IS_INTEGRITY_CONSTRAINT_FOR = "http://krizik.felk.cvut.cz/ontologies/2009/ic.owl#isIntegrityConstraintFor";
    public static final String P_CLASS_NAME = "http://krizik.felk.cvut.cz/ontologies/2009/ic.owl#javaClassName";
    public static final String VOCABULARY_CLASS = "Vocabulary";
    public static final String MODEL_PACKAGE = "model";
    public static final char PACKAGE_SEPARATOR = '.';
    public static final String LANGUAGE = "en";
    public static final String ID_FIELD_NAME = "id";
    public static final String LABEL_FIELD_NAME = "name";
    public static final String DESCRIPTION_FIELD_NAME = "description";
    public static final String TYPES_FIELD_NAME = "types";
    public static final String PROPERTIES_FIELD_NAME = "properties";
    public static final Duration PREFIX_RESOLVE_TIMEOUT = Duration.of(5L, ChronoUnit.SECONDS);
    public static final String VERSION = Constants.resolveVersion();

    private Constants() {
        throw new AssertionError();
    }

    private static String resolveVersion() {
        Properties properties = new Properties();
        try {
            properties.load(Constants.class.getClassLoader().getResourceAsStream("owl2java.properties"));
            assert (properties.containsKey("cz.cvut.jopa.owl2java.version"));
            return properties.getProperty("cz.cvut.jopa.owl2java.version");
        }
        catch (IOException e) {
            throw new OWL2JavaException("Unable to load OWL2Java version from properties file.", e);
        }
    }
}

