/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jopa.owl2java;

import cz.cvut.kbss.jopa.model.SequencesVocabulary;
import cz.cvut.kbss.jopa.owl2java.IntegrityConstraintParser;
import cz.cvut.kbss.jopa.owl2java.IntegrityConstraintSet;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;

class ContextDefinition {
    private static final Set<IRI> SKIPPED = new HashSet<IRI>(Arrays.asList(IRI.create((String)"http://swan.mindinformatics.org/ontologies/1.2/collections/Collection"), IRI.create((String)"http://swan.mindinformatics.org/ontologies/1.2/collections/List"), IRI.create((URI)SequencesVocabulary.c_OWLSimpleList), IRI.create((URI)SequencesVocabulary.c_OWLReferencedList)));
    final Set<OWLAxiom> axioms = new HashSet<OWLAxiom>();
    final Set<OWLClass> classes = new TreeSet<OWLClass>();
    final Set<OWLObjectProperty> objectProperties = new TreeSet<OWLObjectProperty>();
    final Set<OWLDataProperty> dataProperties = new TreeSet<OWLDataProperty>();
    final Set<OWLAnnotationProperty> annotationProperties = new TreeSet<OWLAnnotationProperty>();
    final Set<OWLNamedIndividual> individuals = new TreeSet<OWLNamedIndividual>();
    IntegrityConstraintSet set;

    ContextDefinition() {
    }

    void parse() {
        IntegrityConstraintParser parser = new IntegrityConstraintParser();
        for (OWLAxiom a : this.axioms) {
            a.accept((OWLAxiomVisitor)parser);
        }
        this.set = parser.getClassIntegrityConstraintSet();
    }

    void addAxiom(OWLAxiom axiom) {
        axiom.signature().filter(e -> !SKIPPED.contains(e.getIRI())).forEach(this::add);
        this.axioms.add(axiom);
    }

    void add(OWLEntity e) {
        if (e.isOWLClass()) {
            this.classes.add(e.asOWLClass());
        } else if (e.isOWLObjectProperty()) {
            this.objectProperties.add(e.asOWLObjectProperty());
        } else if (e.isOWLDataProperty()) {
            this.dataProperties.add(e.asOWLDataProperty());
        } else if (e.isOWLAnnotationProperty()) {
            this.annotationProperties.add(e.asOWLAnnotationProperty());
        } else if (e.isOWLNamedIndividual()) {
            this.individuals.add(e.asOWLNamedIndividual());
        }
    }
}

