/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jopa.owl2java;

import cz.cvut.kbss.jopa.ic.api.IntegrityConstraint;
import cz.cvut.kbss.jopa.ic.api.IntegrityConstraintFactory;
import cz.cvut.kbss.jopa.ic.impl.IntegrityConstraintFactoryImpl;
import cz.cvut.kbss.jopa.owl2java.Utils;
import cz.cvut.kbss.jopa.owl2java.exception.UnsupportedICException;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegrityConstraintClassParser
implements OWLClassExpressionVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(IntegrityConstraintClassParser.class);
    private final Set<IntegrityConstraint> integrityConstraints = new HashSet<IntegrityConstraint>();
    private final OWLClass subjClass;
    private final IntegrityConstraintFactory integrityConstraintFactory = new IntegrityConstraintFactoryImpl();

    public IntegrityConstraintClassParser(OWLClass subjClass) {
        this.subjClass = subjClass;
    }

    private static void notSupported(OWLObject o) {
        LOG.info("Ignoring Unsupported Axiom : {}", (Object)o);
    }

    public Set<IntegrityConstraint> getIntegrityConstraints() {
        return this.integrityConstraints;
    }

    public void visit(OWLDataMaxCardinality arg0) {
        try {
            OWLDatatype dt = Utils.ensureDatatype((OWLDataRange)arg0.getFiller());
            OWLDataProperty dp = Utils.ensureDataProperty(arg0.getProperty());
            this.integrityConstraints.add(this.integrityConstraintFactory.MaxDataParticipationConstraint(this.subjClass, dp, dt, arg0.getCardinality()));
        }
        catch (UnsupportedICException e) {
            IntegrityConstraintClassParser.notSupported((OWLObject)arg0);
        }
    }

    public void visit(OWLDataExactCardinality arg0) {
        try {
            OWLDatatype dt = Utils.ensureDatatype((OWLDataRange)arg0.getFiller());
            OWLDataProperty dp = Utils.ensureDataProperty(arg0.getProperty());
            this.integrityConstraints.add(this.integrityConstraintFactory.DataParticipationConstraint(this.subjClass, dp, dt, arg0.getCardinality(), arg0.getCardinality()));
        }
        catch (UnsupportedICException e) {
            IntegrityConstraintClassParser.notSupported((OWLObject)arg0);
        }
    }

    public void visit(OWLDataMinCardinality arg0) {
        try {
            OWLDatatype dt = Utils.ensureDatatype((OWLDataRange)arg0.getFiller());
            OWLDataProperty dp = Utils.ensureDataProperty(arg0.getProperty());
            this.integrityConstraints.add(this.integrityConstraintFactory.MinDataParticipationConstraint(this.subjClass, dp, dt, arg0.getCardinality()));
        }
        catch (UnsupportedICException e) {
            IntegrityConstraintClassParser.notSupported((OWLObject)arg0);
        }
    }

    public void visit(OWLDataHasValue arg0) {
        IntegrityConstraintClassParser.notSupported((OWLObject)arg0);
    }

    public void visit(OWLDataAllValuesFrom arg0) {
        try {
            OWLDataProperty op = Utils.ensureDataProperty(arg0.getProperty());
            OWLDatatype clz = Utils.ensureDatatype((OWLDataRange)arg0.getFiller());
            this.integrityConstraints.add(this.integrityConstraintFactory.DataPropertyRangeConstraint(this.subjClass, op, clz));
        }
        catch (UnsupportedICException e) {
            IntegrityConstraintClassParser.notSupported((OWLObject)arg0);
        }
    }

    public void visit(OWLDataSomeValuesFrom arg0) {
        try {
            OWLDatatype dt = Utils.ensureDatatype((OWLDataRange)arg0.getFiller());
            OWLDataProperty dp = Utils.ensureDataProperty(arg0.getProperty());
            this.integrityConstraints.add(this.integrityConstraintFactory.MinDataParticipationConstraint(this.subjClass, dp, dt, 1));
        }
        catch (UnsupportedICException e) {
            IntegrityConstraintClassParser.notSupported((OWLObject)arg0);
        }
    }

    public void visit(OWLObjectOneOf arg0) {
        IntegrityConstraintClassParser.notSupported((OWLObject)arg0);
    }

    public void visit(OWLObjectHasSelf arg0) {
        IntegrityConstraintClassParser.notSupported((OWLObject)arg0);
    }

    public void visit(OWLObjectMaxCardinality arg0) {
        try {
            OWLClass c = Utils.ensureClass((OWLClassExpression)arg0.getFiller());
            OWLObjectProperty p = Utils.ensureObjectProperty(arg0.getProperty());
            this.integrityConstraints.add(this.integrityConstraintFactory.MaxObjectParticipationConstraint(this.subjClass, p, c, arg0.getCardinality()));
        }
        catch (UnsupportedICException e) {
            IntegrityConstraintClassParser.notSupported((OWLObject)arg0);
        }
    }

    public void visit(OWLObjectExactCardinality arg0) {
        try {
            OWLClass c = Utils.ensureClass((OWLClassExpression)arg0.getFiller());
            OWLObjectProperty p = Utils.ensureObjectProperty(arg0.getProperty());
            this.integrityConstraints.add(this.integrityConstraintFactory.ObjectParticipationConstraint(this.subjClass, p, c, arg0.getCardinality(), arg0.getCardinality()));
        }
        catch (UnsupportedICException e) {
            IntegrityConstraintClassParser.notSupported((OWLObject)arg0);
        }
    }

    public void visit(OWLObjectMinCardinality arg0) {
        try {
            OWLClass c = Utils.ensureClass((OWLClassExpression)arg0.getFiller());
            OWLObjectProperty p = Utils.ensureObjectProperty(arg0.getProperty());
            this.integrityConstraints.add(this.integrityConstraintFactory.MinObjectParticipationConstraint(this.subjClass, p, c, arg0.getCardinality()));
        }
        catch (UnsupportedICException e) {
            IntegrityConstraintClassParser.notSupported((OWLObject)arg0);
        }
    }

    public void visit(OWLObjectHasValue arg0) {
        IntegrityConstraintClassParser.notSupported((OWLObject)arg0);
    }

    public void visit(OWLObjectAllValuesFrom arg0) {
        try {
            OWLObjectProperty op = Utils.ensureObjectProperty(arg0.getProperty());
            OWLClass clz = Utils.ensureClass((OWLClassExpression)arg0.getFiller());
            this.integrityConstraints.add(this.integrityConstraintFactory.ObjectPropertyRangeConstraint(this.subjClass, op, clz));
        }
        catch (UnsupportedICException e) {
            IntegrityConstraintClassParser.notSupported((OWLObject)arg0);
        }
    }

    public void visit(OWLObjectSomeValuesFrom arg0) {
        try {
            OWLClass c = Utils.ensureClass((OWLClassExpression)arg0.getFiller());
            OWLObjectProperty p = Utils.ensureObjectProperty(arg0.getProperty());
            this.integrityConstraints.add(this.integrityConstraintFactory.MinObjectParticipationConstraint(this.subjClass, p, c, 1));
        }
        catch (UnsupportedICException e) {
            IntegrityConstraintClassParser.notSupported((OWLObject)arg0);
        }
    }

    public void visit(OWLObjectComplementOf arg0) {
        IntegrityConstraintClassParser.notSupported((OWLObject)arg0);
    }

    public void visit(OWLObjectUnionOf arg0) {
        IntegrityConstraintClassParser.notSupported((OWLObject)arg0);
    }

    public void visit(OWLObjectIntersectionOf arg0) {
        arg0.operands().forEach(o -> o.accept((OWLClassExpressionVisitor)this));
    }

    public void visit(OWLClass arg0) {
        this.integrityConstraints.add(this.integrityConstraintFactory.SubClassConstraint(this.subjClass, arg0));
    }
}

