/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jopa.owl2java;

import cz.cvut.kbss.jopa.owl2java.IntegrityConstraintClassParser;
import cz.cvut.kbss.jopa.owl2java.IntegrityConstraintSet;
import cz.cvut.kbss.jopa.owl2java.Utils;
import cz.cvut.kbss.jopa.owl2java.exception.UnsupportedICException;
import java.util.HashMap;
import java.util.Map;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegrityConstraintParser
implements OWLAxiomVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(IntegrityConstraintParser.class);
    private final IntegrityConstraintSet integrityConstraintSet = new IntegrityConstraintSet();
    private final Map<OWLObjectProperty, OWLClass> opRanges = new HashMap<OWLObjectProperty, OWLClass>();
    private final Map<OWLDataProperty, OWLDatatype> dpRanges = new HashMap<OWLDataProperty, OWLDatatype>();

    public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
        IntegrityConstraintParser.notSupported((OWLObject)axiom);
    }

    public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
        IntegrityConstraintParser.notSupported((OWLObject)axiom);
    }

    public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        IntegrityConstraintParser.notSupported((OWLObject)axiom);
    }

    public void visit(OWLAnnotationAssertionAxiom axiom) {
        IntegrityConstraintParser.notSupported((OWLObject)axiom);
    }

    public void visit(SWRLRule axiom) {
        IntegrityConstraintParser.notSupported((OWLObject)axiom);
    }

    public void visit(OWLDatatypeDefinitionAxiom axiom) {
        IntegrityConstraintParser.notSupported((OWLObject)axiom);
    }

    public void visit(OWLHasKeyAxiom axiom) {
        IntegrityConstraintParser.notSupported((OWLObject)axiom);
    }

    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        IntegrityConstraintParser.notSupported((OWLObject)axiom);
    }

    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        IntegrityConstraintParser.notSupported((OWLObject)axiom);
    }

    public void visit(OWLSameIndividualAxiom axiom) {
        IntegrityConstraintParser.notSupported((OWLObject)axiom);
    }

    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        IntegrityConstraintParser.notSupported((OWLObject)axiom);
    }

    public void visit(OWLSubDataPropertyOfAxiom axiom) {
        IntegrityConstraintParser.notSupported((OWLObject)axiom);
    }

    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        IntegrityConstraintParser.notSupported((OWLObject)axiom);
    }

    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        IntegrityConstraintParser.notSupported((OWLObject)axiom);
    }

    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        IntegrityConstraintParser.notSupported((OWLObject)axiom);
    }

    public void visit(OWLEquivalentClassesAxiom axiom) {
        IntegrityConstraintParser.notSupported((OWLObject)axiom);
    }

    public void visit(OWLClassAssertionAxiom axiom) {
        IntegrityConstraintParser.notSupported((OWLObject)axiom);
    }

    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        IntegrityConstraintParser.notSupported((OWLObject)axiom);
    }

    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        IntegrityConstraintParser.notSupported((OWLObject)axiom);
    }

    public void visit(OWLDataPropertyRangeAxiom axiom) {
        try {
            OWLDataProperty op = Utils.ensureDataProperty((OWLDataPropertyExpression)axiom.getProperty());
            OWLDatatype clz = Utils.ensureDatatype((OWLDataRange)axiom.getRange());
            this.dpRanges.put(op, clz);
        }
        catch (UnsupportedICException e) {
            IntegrityConstraintParser.notSupported((OWLObject)axiom);
        }
    }

    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        IntegrityConstraintParser.notSupported((OWLObject)axiom);
    }

    public void visit(OWLDisjointUnionAxiom axiom) {
        IntegrityConstraintParser.notSupported((OWLObject)axiom);
    }

    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        IntegrityConstraintParser.notSupported((OWLObject)axiom);
    }

    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        IntegrityConstraintParser.notSupported((OWLObject)axiom);
    }

    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        IntegrityConstraintParser.notSupported((OWLObject)axiom);
    }

    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        try {
            OWLObjectProperty op = Utils.ensureObjectProperty((OWLObjectPropertyExpression)axiom.getProperty());
            OWLClass clz = Utils.ensureClass((OWLClassExpression)axiom.getRange());
            this.opRanges.put(op, clz);
        }
        catch (UnsupportedICException e) {
            IntegrityConstraintParser.notSupported((OWLObject)axiom);
        }
    }

    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        IntegrityConstraintParser.notSupported((OWLObject)axiom);
    }

    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        IntegrityConstraintParser.notSupported((OWLObject)axiom);
    }

    public void visit(OWLDifferentIndividualsAxiom axiom) {
        IntegrityConstraintParser.notSupported((OWLObject)axiom);
    }

    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        IntegrityConstraintParser.notSupported((OWLObject)axiom);
    }

    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        IntegrityConstraintParser.notSupported((OWLObject)axiom);
    }

    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        IntegrityConstraintParser.notSupported((OWLObject)axiom);
    }

    public void visit(OWLDataPropertyDomainAxiom axiom) {
        IntegrityConstraintParser.notSupported((OWLObject)axiom);
    }

    public void visit(OWLDisjointClassesAxiom axiom) {
        IntegrityConstraintParser.notSupported((OWLObject)axiom);
    }

    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        IntegrityConstraintParser.notSupported((OWLObject)axiom);
    }

    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        IntegrityConstraintParser.notSupported((OWLObject)axiom);
    }

    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        IntegrityConstraintParser.notSupported((OWLObject)axiom);
    }

    public void visit(OWLSubClassOfAxiom axiom) {
        try {
            if (!axiom.getSubClass().isAnonymous()) {
                this.processSubClassConstraintCandidate(axiom.getSubClass().asOWLClass(), axiom.getSuperClass());
            } else {
                IntegrityConstraintParser.notSupported((OWLObject)axiom);
            }
        }
        catch (UnsupportedICException e) {
            IntegrityConstraintParser.notSupported((OWLObject)axiom);
        }
    }

    public void visit(OWLDeclarationAxiom axiom) {
        IntegrityConstraintParser.notSupported((OWLObject)axiom);
    }

    private static void notSupported(OWLObject o) {
        LOG.info("Ignoring Unsupported Axiom : {}", (Object)o);
    }

    private void processSubClassConstraintCandidate(OWLClass subjClass, OWLClassExpression superClass) {
        OWLObjectProperty property;
        IntegrityConstraintClassParser icp = new IntegrityConstraintClassParser(subjClass);
        superClass.accept((OWLClassExpressionVisitor)icp);
        for (Map.Entry<OWLObjectProperty, OWLClass> entry : this.opRanges.entrySet()) {
            property = entry.getKey();
            if (!superClass.signature().anyMatch(e -> e.equals(property))) continue;
            OWLManager.getOWLDataFactory().getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)property, (OWLClassExpression)entry.getValue()).accept((OWLClassExpressionVisitor)icp);
        }
        for (Map.Entry<OWLObjectProperty, OWLClass> entry : this.dpRanges.entrySet()) {
            property = (OWLDataProperty)entry.getKey();
            if (!superClass.signature().anyMatch(arg_0 -> IntegrityConstraintParser.lambda$processSubClassConstraintCandidate$1((OWLDataProperty)property, arg_0))) continue;
            OWLManager.getOWLDataFactory().getOWLDataAllValuesFrom((OWLDataPropertyExpression)property, (OWLDataRange)entry.getValue()).accept((OWLClassExpressionVisitor)icp);
        }
        icp.getIntegrityConstraints().forEach(this.integrityConstraintSet::addIntegrityConstraint);
    }

    public IntegrityConstraintSet getClassIntegrityConstraintSet() {
        return this.integrityConstraintSet;
    }

    private static /* synthetic */ boolean lambda$processSubClassConstraintCandidate$1(OWLDataProperty property, OWLEntity e) {
        return e.equals(property);
    }
}

