/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jopa.owl2java;

import cz.cvut.kbss.jopa.ic.api.AtomicSubClassConstraint;
import cz.cvut.kbss.jopa.ic.api.DataDomainConstraint;
import cz.cvut.kbss.jopa.ic.api.DataParticipationConstraint;
import cz.cvut.kbss.jopa.ic.api.DataRangeConstraint;
import cz.cvut.kbss.jopa.ic.api.IntegrityConstraint;
import cz.cvut.kbss.jopa.ic.api.IntegrityConstraintVisitor;
import cz.cvut.kbss.jopa.ic.api.ObjectDomainConstraint;
import cz.cvut.kbss.jopa.ic.api.ObjectParticipationConstraint;
import cz.cvut.kbss.jopa.ic.api.ObjectRangeConstraint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLObjectProperty;

public class IntegrityConstraintSet {
    private final Map<OWLClass, List<IntegrityConstraint>> cConstraints = new HashMap<OWLClass, List<IntegrityConstraint>>();
    private final Map<OWLClass, Map<OWLObjectProperty, Collection<IntegrityConstraint>>> opConstraints = new HashMap<OWLClass, Map<OWLObjectProperty, Collection<IntegrityConstraint>>>();
    private final Map<OWLClass, Map<OWLDataProperty, Collection<IntegrityConstraint>>> dpConstraints = new HashMap<OWLClass, Map<OWLDataProperty, Collection<IntegrityConstraint>>>();

    private static <K, V> void addToMap(K key, V value, Map<K, Collection<V>> map) {
        if (!map.containsKey(key)) {
            map.put(key, new HashSet());
        }
        map.get(key).add(value);
    }

    public void addIntegrityConstraint(IntegrityConstraint ic) {
        ic.accept(new IntegrityConstraintVisitor(){

            @Override
            public void visit(AtomicSubClassConstraint cpc) {
                List setC = IntegrityConstraintSet.this.cConstraints.computeIfAbsent(cpc.getSubClass(), k -> new ArrayList());
                setC.add(cpc);
            }

            @Override
            public void visit(DataParticipationConstraint cpc) {
                IntegrityConstraintSet.this.addToClassDataIntegrityConstraintSet(cpc.getSubject(), (OWLDataProperty)cpc.getPredicate(), cpc);
            }

            @Override
            public void visit(ObjectParticipationConstraint cpc) {
                IntegrityConstraintSet.this.addToClassObjectIntegrityConstraintSet(cpc.getSubject(), (OWLObjectProperty)cpc.getPredicate(), cpc);
            }

            @Override
            public void visit(ObjectDomainConstraint cpc) {
                IntegrityConstraintSet.this.addToClassObjectIntegrityConstraintSet(cpc.getDomain(), cpc.getProperty(), cpc);
            }

            @Override
            public void visit(ObjectRangeConstraint cpc) {
                IntegrityConstraintSet.this.addToClassObjectIntegrityConstraintSet(cpc.getOWLClass(), cpc.getProperty(), cpc);
            }

            @Override
            public void visit(DataDomainConstraint cpc) {
                IntegrityConstraintSet.this.addToClassDataIntegrityConstraintSet(cpc.getDomain(), cpc.getProperty(), cpc);
            }

            @Override
            public void visit(DataRangeConstraint cpc) {
                IntegrityConstraintSet.this.addToClassDataIntegrityConstraintSet(cpc.getOWLClass(), cpc.getProperty(), cpc);
            }
        });
    }

    private Map<OWLObjectProperty, Collection<IntegrityConstraint>> addToClassObjectIntegrityConstraintSet(OWLClass subjClass, OWLObjectProperty p, IntegrityConstraint ic) {
        Map map = this.opConstraints.computeIfAbsent(subjClass, k -> new HashMap());
        IntegrityConstraintSet.addToMap(p, ic, map);
        return map;
    }

    private Map<OWLDataProperty, Collection<IntegrityConstraint>> addToClassDataIntegrityConstraintSet(OWLClass subjClass, OWLDataProperty p, IntegrityConstraint ic) {
        Map map = this.dpConstraints.computeIfAbsent(subjClass, k -> new HashMap());
        IntegrityConstraintSet.addToMap(p, ic, map);
        return map;
    }

    public List<IntegrityConstraint> getClassIntegrityConstraints(OWLClass cls) {
        return this.cConstraints.getOrDefault(cls, Collections.emptyList());
    }

    public Collection<IntegrityConstraint> getClassObjectIntegrityConstraints(OWLClass clazz, OWLObjectProperty prop) {
        Map<OWLObjectProperty, Collection<IntegrityConstraint>> constraints = this.opConstraints.get(clazz);
        if (constraints != null && constraints.containsKey(prop)) {
            return constraints.get(prop);
        }
        return Collections.emptyList();
    }

    public Collection<IntegrityConstraint> getClassDataIntegrityConstraints(OWLClass clazz, OWLDataProperty prop) {
        Map<OWLDataProperty, Collection<IntegrityConstraint>> constraints = this.dpConstraints.get(clazz);
        if (constraints != null && constraints.containsKey(prop)) {
            return constraints.get(prop);
        }
        return Collections.emptyList();
    }
}

