/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jopa.owl2java;

import cz.cvut.kbss.jopa.owl2java.prefix.PrefixMap;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyID;

public class JavaNameGenerator {
    private static final String[] JAVA_KEYWORDS = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};
    private static final char SEPARATOR = '_';
    private final PrefixMap prefixMap;

    public JavaNameGenerator(PrefixMap prefixMap) {
        this.prefixMap = prefixMap;
    }

    public String generateJavaNameForIri(IRI iri) {
        if (iri.getFragment() != null && !iri.getFragment().isEmpty()) {
            return JavaNameGenerator.makeNameValidJava(iri.getFragment());
        }
        String strIri = iri.toString();
        if (strIri.charAt(strIri.length() - 1) == '/') {
            strIri = strIri.substring(0, strIri.length() - 1);
        }
        int x = strIri.lastIndexOf("/");
        return JavaNameGenerator.makeNameValidJava(strIri.substring(x + 1));
    }

    public String generatePrefixedJavaNameForIri(IRI iri, OWLOntologyID ontologyId) {
        if (ontologyId.isAnonymous()) {
            return this.generateJavaNameForIri(iri);
        }
        assert (ontologyId.getOntologyIRI().isPresent());
        IRI ontologyIri = (IRI)ontologyId.getOntologyIRI().get();
        return JavaNameGenerator.makeNameValidJava(this.prefixMap.getPrefix(ontologyIri).orElse(this.generateJavaNameForIri(ontologyIri))) + "_" + this.generateJavaNameForIri(iri);
    }

    public Optional<String> getOntologyPrefix(IRI ontologyIri) {
        Objects.requireNonNull(ontologyIri);
        return this.prefixMap.getPrefix(ontologyIri);
    }

    public boolean hasPrefix(IRI ontologyIri) {
        return this.prefixMap.hasPrefix(ontologyIri);
    }

    public static String makeNameValidJava(String name) {
        Object res = name.trim().replace('-', '_').replace("'", "_quote_").replace(".", "_dot_").replace(',', '_').replace("#", "");
        if (Arrays.binarySearch(JAVA_KEYWORDS, res = Normalizer.normalize((CharSequence)res, Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "")) >= 0) {
            res = "_" + (String)res;
        }
        return res;
    }

    public static String toCamelCaseNotation(String name) {
        StringBuilder result = new StringBuilder();
        for (String w : name.split(Character.toString('_'))) {
            if (w.isEmpty()) continue;
            result.append(w.substring(0, 1).toUpperCase()).append(w.substring(1));
        }
        return result.toString();
    }
}

