/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jopa.owl2java;

import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocCommentable;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import cz.cvut.kbss.jopa.ic.api.AtomicSubClassConstraint;
import cz.cvut.kbss.jopa.ic.api.DataParticipationConstraint;
import cz.cvut.kbss.jopa.ic.api.ObjectParticipationConstraint;
import cz.cvut.kbss.jopa.ic.api.ParticipationConstraint;
import cz.cvut.kbss.jopa.model.MultilingualString;
import cz.cvut.kbss.jopa.model.annotations.Id;
import cz.cvut.kbss.jopa.model.annotations.OWLAnnotationProperty;
import cz.cvut.kbss.jopa.model.annotations.OWLObjectProperty;
import cz.cvut.kbss.jopa.model.annotations.ParticipationConstraints;
import cz.cvut.kbss.jopa.model.annotations.Properties;
import cz.cvut.kbss.jopa.model.annotations.Sequence;
import cz.cvut.kbss.jopa.model.annotations.SequenceType;
import cz.cvut.kbss.jopa.model.annotations.Types;
import cz.cvut.kbss.jopa.owl2java.Card;
import cz.cvut.kbss.jopa.owl2java.ClassDataPropertyComputer;
import cz.cvut.kbss.jopa.owl2java.ClassObjectPropertyComputer;
import cz.cvut.kbss.jopa.owl2java.Constants;
import cz.cvut.kbss.jopa.owl2java.ContextDefinition;
import cz.cvut.kbss.jopa.owl2java.JavaNameGenerator;
import cz.cvut.kbss.jopa.owl2java.ObjectModel;
import cz.cvut.kbss.jopa.owl2java.cli.Option;
import cz.cvut.kbss.jopa.owl2java.cli.PropertiesType;
import cz.cvut.kbss.jopa.owl2java.config.TransformationConfiguration;
import cz.cvut.kbss.jopa.owl2java.exception.OWL2JavaException;
import cz.cvut.kbss.jopa.owl2java.prefix.PrefixMap;
import cz.cvut.kbss.jopa.owlapi.DatatypeTransformer;
import cz.cvut.kbss.jopa.vocabulary.DC;
import cz.cvut.kbss.jopa.vocabulary.RDFS;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.search.EntitySearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaTransformer {
    private static final Logger LOG = LoggerFactory.getLogger(JavaTransformer.class);
    private static final String PREFIX_STRING = "s_";
    private static final String PREFIX_CLASS = "c_";
    private static final String PREFIX_PROPERTY = "p_";
    private static final String PREFIX_INDIVIDUAL = "i_";
    private static final String PREFIX_DATATYPE = "d_";
    private static final String DISAMBIGUATION_SUFFIX = "_A";
    private JDefinedClass voc;
    private final Map<OWLEntity, JFieldRef> entities = new HashMap<OWLEntity, JFieldRef>();
    private final Map<OWLClass, JDefinedClass> classes = new HashMap<OWLClass, JDefinedClass>();
    private JavaNameGenerator nameGenerator;
    private final TransformationConfiguration configuration;

    JavaTransformer(TransformationConfiguration configuration) {
        this.configuration = configuration;
    }

    public ObjectModel generateModel(OWLOntology ontology, ContextDefinition context) {
        try {
            this.nameGenerator = new JavaNameGenerator(new PrefixMap(ontology.getOWLOntologyManager(), this.configuration));
            JCodeModel cm = new JCodeModel();
            this.voc = this.createVocabularyClass(cm);
            this.generateVocabulary(ontology, cm, context);
            this.generateModelImpl(ontology, cm, context, this.modelPackageName());
            return new ObjectModel(cm);
        }
        catch (JClassAlreadyExistsException e) {
            throw new OWL2JavaException("Transformation FAILED.", e);
        }
    }

    private String modelPackageName() {
        String packageConfig = this.configuration.getPackageName();
        StringBuilder sb = new StringBuilder(packageConfig);
        if (!packageConfig.isEmpty()) {
            sb.append('.');
        }
        sb.append("model");
        return sb.toString();
    }

    private JDefinedClass createVocabularyClass(JCodeModel codeModel) throws JClassAlreadyExistsException {
        String packageName = this.configuration.getPackageName();
        Object className = packageName.isEmpty() ? "Vocabulary" : packageName + ".Vocabulary";
        JDefinedClass cls = codeModel._class((String)className);
        JavaTransformer.generateAuthorshipDoc((JDocCommentable)cls);
        return cls;
    }

    private static void generateAuthorshipDoc(JDocCommentable javaElem) {
        javaElem.javadoc().add((Object)("This class was generated by OWL2Java " + Constants.VERSION));
    }

    public ObjectModel generateVocabulary(OWLOntology ontology, ContextDefinition context) {
        try {
            this.nameGenerator = new JavaNameGenerator(new PrefixMap(ontology.getOWLOntologyManager(), this.configuration));
            JCodeModel cm = new JCodeModel();
            this.voc = this.createVocabularyClass(cm);
            this.generateVocabulary(ontology, cm, context);
            return new ObjectModel(cm);
        }
        catch (JClassAlreadyExistsException e) {
            throw new OWL2JavaException("Vocabulary generation FAILED, because the Vocabulary class already exists.", e);
        }
    }

    private void generateVocabulary(OWLOntology o, JCodeModel cm, ContextDefinition context) {
        LinkedHashSet<Object> col = new LinkedHashSet<Object>();
        col.add(o.getOWLOntologyManager().getOWLDataFactory().getOWLThing());
        col.addAll(context.classes);
        col.addAll(context.objectProperties);
        col.addAll(context.dataProperties);
        col.addAll(context.annotationProperties);
        col.addAll(context.individuals);
        this.generateOntologyIrisConstants(o.getOWLOntologyManager());
        HashSet<IRI> visitedProperties = new HashSet<IRI>(col.size());
        for (OWLEntity oWLEntity : col) {
            Optional<String> sFieldName = this.generateFieldName(oWLEntity, o.getOWLOntologyManager(), visitedProperties);
            if (sFieldName.isEmpty()) continue;
            JFieldVar fv1 = this.voc.field(25, String.class, sFieldName.get(), JExpr.lit((String)oWLEntity.getIRI().toString()));
            if (this.configuration.shouldGenerateOwlapiIris()) {
                this.voc.field(25, IRI.class, sFieldName.get().substring(PREFIX_STRING.length()), (JExpression)cm.ref(IRI.class).staticInvoke("create").arg((JExpression)fv1));
            }
            this.generateJavadoc(o, oWLEntity, (JDocCommentable)fv1);
            this.entities.put(oWLEntity, this.voc.staticRef((JVar)fv1));
        }
    }

    private void generateOntologyIrisConstants(OWLOntologyManager ontologyManager) {
        List<IRI> ontologyIris = ontologyManager.ontologies().map(o -> o.getOntologyID().getOntologyIRI()).filter(Optional::isPresent).map(Optional::get).distinct().sorted(Comparator.comparing(IRI::getIRIString)).toList();
        ontologyIris.forEach(iri -> {
            String fieldName = this.ensureVocabularyItemUniqueIdentifier("ONTOLOGY_IRI_" + JavaNameGenerator.makeNameValidJava(this.nameGenerator.getOntologyPrefix((IRI)iri).orElseGet(() -> this.nameGenerator.generateJavaNameForIri((IRI)iri))).toUpperCase());
            this.voc.field(25, String.class, fieldName, JExpr.lit((String)iri.toString()));
        });
    }

    private Optional<String> generateFieldName(OWLEntity c, OWLOntologyManager ontologyManager, Set<IRI> visitedProperties) {
        Optional<String> prefix = JavaTransformer.resolveFieldPrefix(c, visitedProperties);
        if (prefix.isEmpty()) {
            return prefix;
        }
        Optional<OWLOntology> containingOntology = JavaTransformer.resolveContainingOntology(c, ontologyManager);
        String fieldName = PREFIX_STRING + prefix.get() + this.nameGenerator.generateJavaNameForIri(c.getIRI());
        if (this.voc.fields().containsKey(fieldName) || containingOntology.isPresent() && this.isPrefixedVersionRequired(containingOntology.get().getOntologyID())) {
            fieldName = PREFIX_STRING + prefix.get() + this.nameGenerator.generatePrefixedJavaNameForIri(c.getIRI(), containingOntology.get().getOntologyID());
        }
        return Optional.of(this.ensureVocabularyItemUniqueIdentifier(fieldName));
    }

    private static Optional<OWLOntology> resolveContainingOntology(OWLEntity c, OWLOntologyManager ontologyManager) {
        return ontologyManager.getOntologies().stream().filter(o -> !o.getOntologyID().isAnonymous()).filter(o -> o.containsEntityInSignature(c)).findFirst();
    }

    private static Optional<String> resolveFieldPrefix(OWLEntity c, Set<IRI> visitedProperties) {
        if (c.isOWLClass()) {
            return Optional.of(PREFIX_CLASS);
        }
        if (c.isOWLDatatype()) {
            return Optional.of(PREFIX_DATATYPE);
        }
        if (c.isOWLDataProperty() || c.isOWLObjectProperty() || c.isOWLAnnotationProperty()) {
            if (visitedProperties.contains(c.getIRI())) {
                LOG.debug("Property with IRI {} already processed. Skipping.", (Object)c.getIRI());
                return Optional.empty();
            }
            visitedProperties.add(c.getIRI());
            return Optional.of(PREFIX_PROPERTY);
        }
        if (c.isOWLNamedIndividual()) {
            return Optional.of(PREFIX_INDIVIDUAL);
        }
        return Optional.of("");
    }

    private String ensureVocabularyItemUniqueIdentifier(String id) {
        StringBuilder sb = new StringBuilder(id);
        while (this.voc.fields().containsKey(sb.toString())) {
            sb.append(DISAMBIGUATION_SUFFIX);
        }
        return sb.toString();
    }

    private boolean generateJavadoc(OWLOntology ontology, OWLEntity owlEntity, JDocCommentable javaElem) {
        if (!this.configuration.shouldGenerateJavadoc()) {
            return false;
        }
        List<OWLAnnotation> comments = EntitySearcher.getAnnotations((OWLEntity)owlEntity, (OWLOntology)ontology).filter(a -> a.getProperty().isComment() && a.getValue().isLiteral()).toList();
        Optional<OWLAnnotation> langComment = comments.stream().filter(a -> a.getValue().asLiteral().map(l -> l.hasLang("en")).orElse(false)).findFirst();
        if (langComment.isPresent()) {
            langComment.flatMap(a -> a.getValue().asLiteral()).ifPresent(lit -> javaElem.javadoc().add((Object)lit.getLiteral()));
            return true;
        }
        if (!comments.isEmpty()) {
            OWLAnnotation anyComment = comments.get(0);
            anyComment.getValue().asLiteral().ifPresent(lit -> javaElem.javadoc().add((Object)lit.getLiteral()));
            return true;
        }
        return false;
    }

    private void generateModelImpl(OWLOntology ontology, JCodeModel cm, ContextDefinition context, String pkg) {
        LOG.info("Generating model ...");
        PropertiesType propertiesType = this.configuration.getPropertiesType();
        if (this.configuration.shouldGenerateThing()) {
            context.classes.add(ontology.getOWLOntologyManager().getOWLDataFactory().getOWLThing());
        }
        for (OWLClass clazz : context.classes) {
            LOG.info("  Generating entity class for '{}'.", (Object)clazz);
            JDefinedClass subj = this.ensureEntityClassExists(pkg, cm, clazz, ontology);
            AtomicBoolean extendClass = new AtomicBoolean(false);
            context.set.getClassIntegrityConstraints(clazz).stream().filter(ic -> ic instanceof AtomicSubClassConstraint).forEach(ic -> {
                AtomicSubClassConstraint icc = (AtomicSubClassConstraint)ic;
                subj._extends((JClass)this.ensureEntityClassExists(pkg, cm, icc.getSupClass(), ontology));
                extendClass.set(true);
            });
            if (!extendClass.get()) {
                this.addCommonClassFields(cm, subj, propertiesType);
            }
            for (org.semanticweb.owlapi.model.OWLObjectProperty oWLObjectProperty : context.objectProperties) {
                this.generateObjectProperty(ontology, cm, context, pkg, clazz, subj, oWLObjectProperty);
            }
            for (OWLDataProperty oWLDataProperty : context.dataProperties) {
                this.generateDataProperty(ontology, cm, context, clazz, subj, oWLDataProperty);
            }
        }
    }

    private void generateObjectProperty(OWLOntology ontology, JCodeModel cm, ContextDefinition context, String pkg, OWLClass clazz, JDefinedClass subj, org.semanticweb.owlapi.model.OWLObjectProperty prop) {
        ClassObjectPropertyComputer comp = new ClassObjectPropertyComputer(clazz, prop, context.set, ontology);
        if (Card.NO != comp.getCard()) {
            JDefinedClass filler = this.ensureEntityClassExists(pkg, cm, (OWLClass)comp.getFiller(), ontology);
            String fieldName = this.nameGenerator.generateJavaNameForIri(prop.getIRI());
            switch (comp.getCard()) {
                case MULTIPLE: {
                    filler = cm.ref(Set.class).narrow((JClass)filler);
                    break;
                }
                case SIMPLELIST: 
                case LIST: {
                    filler = cm.ref(List.class).narrow((JClass)filler);
                    break;
                }
            }
            JFieldVar fv = JavaTransformer.addField(fieldName, subj, (JType)filler);
            this.generateJavadoc(ontology, (OWLEntity)prop, (JDocCommentable)fv);
            if (comp.getCard().equals((Object)Card.SIMPLELIST)) {
                fv.annotate(Sequence.class).param("type", (Enum<?>)SequenceType.simple);
            }
            fv.annotate(OWLObjectProperty.class).param("iri", this.entities.get(prop));
            JAnnotationArrayMember use = null;
            for (ObjectParticipationConstraint ic : comp.getParticipationConstraints()) {
                if (use == null) {
                    use = fv.annotate(ParticipationConstraints.class).paramArray("value");
                }
                JAnnotationUse u = use.annotate(cz.cvut.kbss.jopa.model.annotations.ParticipationConstraint.class).param("owlObjectIRI", this.entities.get(ic.getObject()));
                JavaTransformer.setParticipationConstraintCardinality(u, ic);
            }
        }
    }

    private static JFieldVar addField(String name, JDefinedClass cls, JType fieldType) {
        Object newName = name;
        int i = 0;
        while (cls.fields().containsKey(newName)) {
            newName = name + ++i;
        }
        JFieldVar fvId = cls.field(2, fieldType, (String)newName);
        String fieldName = fvId.name().substring(0, 1).toUpperCase() + fvId.name().substring(1);
        JMethod mSetId = cls.method(1, Void.TYPE, "set" + fieldName);
        JVar v = mSetId.param(fieldType, fvId.name());
        mSetId.body().assign((JAssignmentTarget)JExpr._this().ref((JVar)fvId), (JExpression)v);
        JMethod mGetId = cls.method(1, fieldType, "get" + fieldName);
        mGetId.body()._return((JExpression)fvId);
        return fvId;
    }

    private static void setParticipationConstraintCardinality(JAnnotationUse u, ParticipationConstraint<?, ?> ic) {
        if (ic.getMin() != 0) {
            u.param("min", ic.getMin());
        }
        if (ic.getMin() != -1) {
            u.param("max", ic.getMax());
        }
    }

    private void generateDataProperty(OWLOntology ontology, JCodeModel cm, ContextDefinition context, OWLClass clazz, JDefinedClass subj, OWLDataProperty prop) {
        ClassDataPropertyComputer comp = new ClassDataPropertyComputer(clazz, prop, context.set, ontology);
        if (Card.NO != comp.getCard()) {
            JType obj = cm._ref(this.resolveFieldType((OWLDatatype)comp.getFiller()));
            String fieldName = this.nameGenerator.generateJavaNameForIri(prop.getIRI());
            JFieldVar fv = switch (comp.getCard()) {
                case Card.MULTIPLE -> JavaTransformer.addField(fieldName, subj, (JType)cm.ref(Set.class).narrow(obj));
                case Card.ONE -> JavaTransformer.addField(fieldName, subj, obj);
                default -> throw new OWL2JavaException("Unsupported data property cardinality type " + String.valueOf((Object)comp.getCard()));
            };
            this.generateJavadoc(ontology, (OWLEntity)prop, (JDocCommentable)fv);
            fv.annotate(cz.cvut.kbss.jopa.model.annotations.OWLDataProperty.class).param("iri", this.entities.get(prop));
            JAnnotationArrayMember use = null;
            for (DataParticipationConstraint ic : comp.getParticipationConstraints()) {
                if (use == null) {
                    use = fv.annotate(ParticipationConstraints.class).paramArray("value");
                }
                JAnnotationUse u = use.annotate(cz.cvut.kbss.jopa.model.annotations.ParticipationConstraint.class).param("owlObjectIRI", ((OWLDatatype)comp.getFiller()).getIRI().toString());
                JavaTransformer.setParticipationConstraintCardinality(u, ic);
            }
        }
    }

    private Class<?> resolveFieldType(OWLDatatype datatype) {
        Class cls = DatatypeTransformer.transformOWLType((OWLDatatype)datatype);
        if (MultilingualString.class.equals((Object)cls) && !this.configuration.shouldPreferMultilingualStrings()) {
            return String.class;
        }
        return cls;
    }

    private JDefinedClass ensureEntityClassExists(String pkg, JCodeModel cm, OWLClass clazz, OWLOntology ontology) {
        if (!this.classes.containsKey(clazz)) {
            this.classes.put(clazz, this.createEntityClass(pkg, cm, clazz, ontology));
        }
        return this.classes.get(clazz);
    }

    private JDefinedClass createEntityClass(String pkg, JCodeModel cm, OWLClass clazz, OWLOntology ontology) {
        JDefinedClass cls;
        String name = this.javaClassId(ontology, clazz, pkg, cm);
        try {
            cls = cm._class(name);
            cls.annotate(cz.cvut.kbss.jopa.model.annotations.OWLClass.class).param("iri", this.entities.get(clazz));
            cls._implements(Serializable.class);
            this.generateClassJavadoc(ontology, (OWLEntity)clazz, (JDocCommentable)cls);
        }
        catch (JClassAlreadyExistsException e) {
            LOG.trace("Class already exists. Using the existing version. {}", (Object)e.getMessage());
            cls = cm._getClass(name);
        }
        return cls;
    }

    private String javaClassId(OWLOntology rootOntology, OWLClass owlClass, String pkg, JCodeModel codeModel) {
        Optional<OWLOntology> containingOntology = JavaTransformer.resolveContainingOntology((OWLEntity)owlClass, rootOntology.getOWLOntologyManager());
        OWLOntology onto = containingOntology.orElse(rootOntology);
        Object className = this.resolveExplicitClassName(rootOntology, owlClass).orElseGet(() -> JavaNameGenerator.toCamelCaseNotation(this.nameGenerator.generateJavaNameForIri(owlClass.getIRI())));
        if (JavaTransformer.isClassNameUnique(pkg, (String)className, codeModel) && !this.isPrefixedVersionRequired(onto.getOntologyID())) {
            return JavaTransformer.fqn(pkg, (String)className);
        }
        className = JavaNameGenerator.toCamelCaseNotation(this.nameGenerator.generatePrefixedJavaNameForIri(owlClass.getIRI(), onto.getOntologyID()));
        while (!JavaTransformer.isClassNameUnique(pkg, (String)className, codeModel)) {
            className = (String)className + DISAMBIGUATION_SUFFIX;
        }
        return JavaTransformer.fqn(pkg, (String)className);
    }

    private Optional<String> resolveExplicitClassName(OWLOntology ontology, OWLClass owlClass) {
        return EntitySearcher.getAnnotations((OWLEntity)owlClass, (OWLOntology)ontology).filter(a -> this.isJavaClassNameAnnotation((OWLAnnotation)a) && a.getValue().isLiteral()).findFirst().map(a -> ((OWLLiteral)a.getValue().asLiteral().get()).getLiteral());
    }

    private boolean isJavaClassNameAnnotation(OWLAnnotation a) {
        String classNameProperty = (String)this.configuration.getCliParams().valueOf(Option.JAVA_CLASSNAME_ANNOTATION.arg);
        return a.getProperty().getIRI().equals((Object)IRI.create((String)(classNameProperty != null ? classNameProperty : "http://krizik.felk.cvut.cz/ontologies/2009/ic.owl#javaClassName")));
    }

    private static boolean isClassNameUnique(String pkg, String simpleName, JCodeModel cm) {
        return cm._getClass(JavaTransformer.fqn(pkg, simpleName)) == null;
    }

    private static String fqn(String pkg, String simpleName) {
        return pkg + "." + simpleName;
    }

    private boolean isPrefixedVersionRequired(OWLOntologyID ontologyId) {
        return this.configuration.shouldAlwaysUseOntologyPrefix() && (ontologyId.isAnonymous() || this.nameGenerator.hasPrefix((IRI)ontologyId.getOntologyIRI().get()));
    }

    private void generateClassJavadoc(OWLOntology ontology, OWLEntity owlEntity, JDocCommentable javaElem) {
        boolean generated = this.generateJavadoc(ontology, owlEntity, javaElem);
        if (generated) {
            javaElem.javadoc().add((Object)"\n\n");
        }
        JavaTransformer.generateAuthorshipDoc(javaElem);
    }

    private void addCommonClassFields(JCodeModel cm, JDefinedClass cls, PropertiesType propertiesType) {
        JClass ftId = cm.ref(String.class);
        JFieldVar fvId = JavaTransformer.addField("id", cls, (JType)ftId);
        JAnnotationUse a = fvId.annotate(Id.class);
        a.param("generated", true);
        JFieldVar fvLabel = null;
        if (this.configuration.shouldGenerateAnnotationFields()) {
            JClass ftLabel = cm.ref(String.class);
            fvLabel = JavaTransformer.addField("name", cls, (JType)ftLabel);
            fvLabel.annotate(OWLAnnotationProperty.class).param("iri", cm.ref(RDFS.class).staticRef("LABEL"));
            JClass ftDescription = cm.ref(String.class);
            JFieldVar fvDescription = JavaTransformer.addField("description", cls, (JType)ftDescription);
            fvDescription.annotate(OWLAnnotationProperty.class).param("iri", cm.ref(DC.Elements.class).staticRef("DESCRIPTION"));
        }
        JClass ftTypes = cm.ref(Set.class).narrow(String.class);
        JFieldVar fvTypes = JavaTransformer.addField("types", cls, (JType)ftTypes);
        fvTypes.annotate(Types.class);
        Class propertiesTypeC = propertiesType == PropertiesType.object ? Object.class : String.class;
        JClass ftProperties = cm.ref(Map.class).narrow(new JClass[]{cm.ref(String.class), cm.ref(Set.class).narrow(propertiesTypeC)});
        JFieldVar fvProperties = JavaTransformer.addField("properties", cls, (JType)ftProperties);
        fvProperties.annotate(Properties.class);
        JavaTransformer.generateToStringMethod(cls, fvId, fvLabel);
    }

    private static void generateToStringMethod(JDefinedClass cls, JFieldVar idField, JFieldVar labelField) {
        JMethod toString = cls.method(1, String.class, "toString");
        toString.annotate(Override.class);
        JBlock body = toString.body();
        JExpression expression = JExpr.lit((String)(cls.name() + " {"));
        if (labelField != null) {
            expression = expression.plus((JExpression)JExpr.ref((String)labelField.name()));
        }
        expression = expression.plus(JExpr.lit((String)"<")).plus((JExpression)JExpr.ref((String)idField.name())).plus(JExpr.lit((String)">"));
        expression = expression.plus(JExpr.lit((String)"}"));
        body._return(expression);
    }
}

