/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jopa.owl2java;

import cz.cvut.kbss.jopa.owl2java.Constants;
import cz.cvut.kbss.jopa.owl2java.OWL2JavaTransformer;
import cz.cvut.kbss.jopa.owl2java.cli.CliParams;
import cz.cvut.kbss.jopa.owl2java.cli.Command;
import cz.cvut.kbss.jopa.owl2java.cli.Option;
import cz.cvut.kbss.jopa.owl2java.config.TransformationConfiguration;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Optional;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OWL2Java {
    private static final Logger LOG = LoggerFactory.getLogger(OWL2Java.class);

    private static void printHelp(Command cc) {
        PrintStream os = System.out;
        os.print(cc.helpText);
        try {
            cc.parser.printHelpOn((OutputStream)os);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private static Optional<Command> getCommand(String s) {
        try {
            return Optional.of(Command.valueOf(s));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Syntax: OWL2Java <command> <args>. Run 'OWL2Java help' for more details");
            return;
        }
        Optional<Command> c = OWL2Java.getCommand(args[0]);
        if (c.isEmpty()) {
            System.err.println("Invalid command " + args[0] + ", try 'OWL2Java help' for the list of available commands");
            return;
        }
        OptionParser op = c.get().parser;
        OptionSet os = op.parse(args);
        CliParams input = new CliParams(os);
        switch (c.get()) {
            case help: {
                if (args.length != 1) {
                    Optional<Command> cc = OWL2Java.getCommand(args[1]);
                    if (cc.isPresent()) {
                        OWL2Java.printHelp(cc.get());
                        break;
                    }
                    System.err.println("Invalid command " + args[0] + " " + args[1] + ", try 'OWL2Java help' for the list of available commands.");
                    return;
                }
                System.out.println("Available commands : " + String.valueOf(Arrays.asList(Command.values())));
                break;
            }
            case list: {
                if (OWL2Java.invalidArgumentCount(input)) break;
                OWL2JavaTransformer oj = OWL2Java.getTransformer(input);
                System.out.println("Available contexts: " + String.valueOf(oj.listContexts()));
                break;
            }
            case transform: {
                if (OWL2Java.invalidArgumentCount(input)) break;
                OWL2Java.transformOwlToJava(input);
                break;
            }
            case vocabulary: {
                if (OWL2Java.invalidArgumentCount(input)) break;
                OWL2Java.generateVocabulary(input);
                break;
            }
            case version: {
                System.out.println("OWL2Java version " + Constants.VERSION);
                break;
            }
            default: {
                System.err.println("Unknown command '" + args[0] + "', try 'OWL2Java help'.");
            }
        }
    }

    private static OWL2JavaTransformer getTransformer(CliParams input) {
        OWL2JavaTransformer oj = new OWL2JavaTransformer();
        if (input.has(Option.MAPPING_FILE.arg)) {
            oj.setOntology(input.nonOptionArguments().get(1), input.valueOf(Option.MAPPING_FILE.arg).toString());
        } else {
            oj.setOntology(input.nonOptionArguments().get(1), null);
        }
        oj.ignoreMissingImports(input.is(Option.IGNORE_FAILED_IMPORTS.arg, false));
        return oj;
    }

    private static boolean invalidArgumentCount(CliParams input) {
        if (input.nonOptionArguments().size() != 2) {
            System.err.println("Exactly one ontology IRI has to be specified, got " + (input.nonOptionArguments().size() - 1) + ", try 'OWL2Java help' for the list of available commands");
            return true;
        }
        return false;
    }

    private static void transformOwlToJava(CliParams input) {
        boolean whole = input.is(Option.WHOLE_ONTOLOGY_AS_IC.arg, false);
        if (!whole && OWL2Java.invalidTransformationOptions(input)) {
            return;
        }
        TransformationConfiguration config = TransformationConfiguration.config(input);
        OWL2JavaTransformer transformer = OWL2Java.getTransformer(input);
        transformer.transform(config);
    }

    private static boolean invalidTransformationOptions(CliParams input) {
        if (OWL2Java.invalidArgumentCount(input)) {
            return true;
        }
        if (!input.has(Option.CONTEXT.arg)) {
            System.err.println("The parameter '-" + Option.CONTEXT.arg + "' is obligatory. Try the 'help' command for more details.");
            return true;
        }
        return false;
    }

    private static void generateVocabulary(CliParams input) {
        boolean whole = input.is(Option.WHOLE_ONTOLOGY_AS_IC.arg, false);
        if (!whole && OWL2Java.invalidTransformationOptions(input)) {
            return;
        }
        OWL2JavaTransformer transformer = OWL2Java.getTransformer(input);
        TransformationConfiguration config = TransformationConfiguration.config(input);
        transformer.generateVocabulary(config);
    }
}

