/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jopa.owl2java;

import cz.cvut.kbss.jopa.owl2java.ContextDefinition;
import cz.cvut.kbss.jopa.owl2java.JavaTransformer;
import cz.cvut.kbss.jopa.owl2java.ObjectModel;
import cz.cvut.kbss.jopa.owl2java.config.TransformationConfiguration;
import cz.cvut.kbss.jopa.owl2java.exception.OWL2JavaException;
import cz.cvut.kbss.jopa.util.MappingFileParser;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.MissingImportHandlingStrategy;
import org.semanticweb.owlapi.model.MissingImportListener;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitor;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologySetProvider;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.search.EntitySearcher;
import org.semanticweb.owlapi.util.OWLOntologyMerger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OWL2JavaTransformer {
    private static final Logger LOG = LoggerFactory.getLogger(OWL2JavaTransformer.class);
    private OWLOntology ontology;
    private final ValidContextAnnotationValueVisitor v = new ValidContextAnnotationValueVisitor();
    private final ContextDefinition defaultContext = new ContextDefinition();
    private final Map<String, ContextDefinition> contexts = new HashMap<String, ContextDefinition>();
    private boolean ignoreMissingImports;

    public Collection<String> listContexts() {
        return this.contexts.keySet();
    }

    public void ignoreMissingImports(boolean ignore) {
        this.ignoreMissingImports = ignore;
    }

    private OWLOntology getWholeOntology(String owlOntologyName, String mappingFile) {
        OWLOntologyManager m = OWLManager.createOWLOntologyManager();
        if (mappingFile != null) {
            LOG.info("Using mapping file '{}'.", (Object)mappingFile);
            Map map = MappingFileParser.getMappings((File)new File(mappingFile));
            m.getIRIMappers().add((OWLOntologyIRIMapper & Serializable)ontologyIRI -> {
                URI value = (URI)map.get(ontologyIRI.toURI());
                if (value == null) {
                    return null;
                }
                return IRI.create((URI)value);
            });
            LOG.info("Mapping file successfully parsed.");
        }
        LOG.info("Loading ontology {}... ", (Object)owlOntologyName);
        if (this.ignoreMissingImports) {
            m.getOntologyConfigurator().setMissingImportHandlingStrategy(MissingImportHandlingStrategy.SILENT);
            m.addMissingImportListener((MissingImportListener & Serializable)e -> {
                LOG.warn("Unable to import ontology {}.", (Object)e.getImportedOntologyURI());
                LOG.debug("Error: {}", (Object)e.getCreationException().getMessage());
            });
        }
        try {
            m.loadOntology(IRI.create((String)owlOntologyName));
            return new OWLOntologyMerger((OWLOntologySetProvider)m).createMergedOntology(m, null);
        }
        catch (OWLException | OWLRuntimeException e2) {
            LOG.error(e2.getMessage(), e2);
            throw new OWL2JavaException("Unable to load ontology " + owlOntologyName, e2);
        }
    }

    public void setOntology(String owlOntologyName, String mappingFile) {
        this.ontology = this.getWholeOntology(owlOntologyName, mappingFile);
        LOG.debug("Parsing integrity constraints");
        this.ontology.axioms().forEach(a -> {
            this.defaultContext.addAxiom((OWLAxiom)a);
            for (String icContextName : this.getContexts((OWLAxiom)a)) {
                ContextDefinition ctx = this.getContextDefinition(icContextName);
                ctx.addAxiom((OWLAxiom)a);
            }
        });
        this.registerEntitiesInContexts();
        this.defaultContext.parse();
        for (ContextDefinition ctx : this.contexts.values()) {
            ctx.parse();
        }
        LOG.debug("Integrity constraints successfully parsed.");
    }

    private void registerEntitiesInContexts() {
        Consumer<Stream> consumer = stream -> stream.forEach(e -> {
            this.defaultContext.add((OWLEntity)e);
            for (String context : this.getContexts((OWLEntity)e)) {
                this.getContextDefinition(context).add((OWLEntity)e);
            }
        });
        consumer.accept(this.ontology.classesInSignature());
        consumer.accept(this.ontology.objectPropertiesInSignature());
        consumer.accept(this.ontology.dataPropertiesInSignature());
        consumer.accept(this.ontology.annotationPropertiesInSignature());
    }

    private ContextDefinition getContextDefinition(String icContextName) {
        return this.contexts.computeIfAbsent(icContextName, name -> new ContextDefinition());
    }

    private List<String> getContexts(OWLAxiom a) {
        ArrayList<String> icContexts = new ArrayList<String>();
        a.annotations().filter(p -> p.getProperty().getIRI().toString().equals("http://krizik.felk.cvut.cz/ontologies/2009/ic.owl#isIntegrityConstraintFor")).forEach(p -> {
            LOG.trace("Processing axiom annotation: {}", p);
            p.getValue().accept((OWLAnnotationValueVisitor)this.v);
            String icContextName = this.v.getName();
            LOG.trace("CONTEXT: {}", (Object)icContextName);
            if (icContextName == null) {
                return;
            }
            LOG.debug("Found IC {} for context {}", (Object)a, (Object)icContextName);
            icContexts.add(icContextName);
        });
        return icContexts;
    }

    private List<String> getContexts(OWLEntity entity) {
        ArrayList<String> icContexts = new ArrayList<String>();
        EntitySearcher.getAnnotations((OWLEntity)entity, (OWLOntology)this.ontology).filter(p -> p.getProperty().getIRI().toString().equals("http://krizik.felk.cvut.cz/ontologies/2009/ic.owl#isIntegrityConstraintFor")).forEach(p -> {
            LOG.trace("Processing entity annotation: {}", p);
            p.getValue().accept((OWLAnnotationValueVisitor)this.v);
            String icContextName = this.v.getName();
            LOG.trace("CONTEXT: {}", (Object)icContextName);
            if (icContextName == null) {
                return;
            }
            LOG.debug("Found OWLEntity declaration {} for context {}", (Object)entity, (Object)icContextName);
            icContexts.add(icContextName);
        });
        return icContexts;
    }

    private void verifyContextExistence(String context) {
        if (!this.contexts.containsKey(context)) {
            throw new IllegalArgumentException("Context " + context + " not found. Existing contexts: " + String.valueOf(this.listContexts()));
        }
    }

    public void transform(TransformationConfiguration transformConfig) {
        ContextDefinition def = this.getValidContext(transformConfig);
        LOG.info("Transforming context ...");
        ObjectModel result = new JavaTransformer(transformConfig).generateModel(this.ontology, def);
        result.writeModel(transformConfig.getTargetDir());
        LOG.info("Transformation SUCCESSFUL.");
    }

    private ContextDefinition getValidContext(TransformationConfiguration configuration) {
        if (configuration.areAllAxiomsIntegrityConstraints()) {
            LOG.info(" - for all axioms");
            return this.defaultContext;
        }
        String context = configuration.getContext();
        this.verifyContextExistence(context);
        LOG.info(" - for context '{}'.", (Object)context);
        return this.contexts.get(context);
    }

    public void generateVocabulary(TransformationConfiguration transformConfig) {
        LOG.info("Generating vocabulary ...");
        ContextDefinition def = this.getValidContext(transformConfig);
        ObjectModel result = new JavaTransformer(transformConfig).generateVocabulary(this.ontology, def);
        result.writeModel(transformConfig.getTargetDir());
    }

    private static class ValidContextAnnotationValueVisitor
    implements OWLAnnotationValueVisitor {
        private String name;

        private ValidContextAnnotationValueVisitor() {
        }

        String getName() {
            return this.name;
        }

        public void visit(@Nonnull OWLLiteral literal) {
            this.name = literal.getLiteral();
        }
    }
}

