/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jopa.owl2java;

import cz.cvut.kbss.jopa.owl2java.exception.UnsupportedICException;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;

public class Utils {
    private Utils() {
        throw new AssertionError();
    }

    static OWLDatatype ensureDatatype(OWLDataRange r) {
        if (!r.isOWLDatatype()) {
            throw new UnsupportedICException("Data ranges not supported: " + String.valueOf(r));
        }
        if (!r.asOWLDatatype().isBuiltIn()) {
            throw new UnsupportedICException("Only built in datatypes are supported: " + String.valueOf(r));
        }
        return r.asOWLDatatype();
    }

    static OWLClass ensureClass(OWLClassExpression r) {
        if (!r.isAnonymous()) {
            return r.asOWLClass();
        }
        throw new UnsupportedICException("Only named classes are supported: " + String.valueOf(r));
    }

    static OWLDataProperty ensureDataProperty(OWLDataPropertyExpression e) {
        if (e.isAnonymous()) {
            throw new UnsupportedICException("Data property expressions not supported: " + String.valueOf(e));
        }
        return e.asOWLDataProperty();
    }

    static OWLObjectProperty ensureObjectProperty(OWLObjectPropertyExpression e) {
        if (e.isAnonymous()) {
            throw new UnsupportedICException("Object property expressions not supported: " + String.valueOf(e));
        }
        return e.asOWLObjectProperty();
    }
}

