/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jopa.owl2java.config;

import cz.cvut.kbss.jopa.owl2java.cli.CliParams;
import cz.cvut.kbss.jopa.owl2java.cli.Option;
import cz.cvut.kbss.jopa.owl2java.cli.PropertiesType;
import cz.cvut.kbss.jopa.owl2java.config.Defaults;
import cz.cvut.kbss.jopa.owl2java.prefix.PrefixCcRemotePrefixResolver;
import cz.cvut.kbss.jopa.owl2java.prefix.RemotePrefixResolver;

public class TransformationConfiguration {
    private final String context;
    private final String packageName;
    private final String targetDir;
    private final boolean generateOwlapiIris;
    private final boolean generateJavadoc;
    private final boolean preferMultilingualStrings;
    private final PropertiesType propertiesType;
    private final boolean generateAnnotationFields;
    private final boolean generateThing;
    private final String ontologyPrefixProperty;
    private final boolean alwaysUseOntologyPrefix;
    private final String prefixMappingFile;
    private final CliParams cliParams;
    private final RemotePrefixResolver remotePrefixResolver;

    private TransformationConfiguration(TransformationConfigurationBuilder builder) {
        this.context = builder.context;
        this.packageName = builder.packageName;
        this.targetDir = builder.targetDir;
        this.generateOwlapiIris = builder.owlapiIris;
        this.generateJavadoc = builder.generateJavadoc;
        this.preferMultilingualStrings = builder.preferMultilingualStrings;
        this.propertiesType = builder.propertiesType;
        this.generateAnnotationFields = builder.generateAnnotationFields;
        this.generateThing = builder.generateThing;
        this.ontologyPrefixProperty = builder.ontologyPrefixProperty;
        this.alwaysUseOntologyPrefix = builder.alwaysUseOntologyPrefix;
        this.prefixMappingFile = builder.prefixMappingFile;
        this.remotePrefixResolver = builder.remotePrefixResolver;
        this.cliParams = CliParams.empty();
    }

    private TransformationConfiguration(CliParams cliParams) {
        this.cliParams = cliParams;
        this.context = cliParams.is(Option.WHOLE_ONTOLOGY_AS_IC.arg) ? null : cliParams.valueOf(Option.CONTEXT.arg).toString();
        this.packageName = cliParams.valueOf(Option.PACKAGE.arg).toString();
        this.targetDir = cliParams.valueOf(Option.TARGET_DIR.arg).toString();
        this.generateOwlapiIris = cliParams.is(Option.WITH_IRIS.arg, false);
        this.generateJavadoc = cliParams.is(Option.GENERATE_JAVADOC_FROM_COMMENT.arg, true);
        this.preferMultilingualStrings = cliParams.is(Option.PREFER_MULTILINGUAL_STRINGS.arg, true);
        this.propertiesType = PropertiesType.fromParam(cliParams.valueOf(Option.PROPERTIES_TYPE.arg));
        this.generateAnnotationFields = cliParams.is(Option.GENERATE_ANNOTATION_FIELDS.arg, true);
        this.generateThing = cliParams.is(Option.GENERATE_THING.arg, true);
        this.ontologyPrefixProperty = cliParams.has(Option.ONTOLOGY_PREFIX_PROPERTY.arg) ? cliParams.valueOf(Option.ONTOLOGY_PREFIX_PROPERTY.arg).toString() : "http://purl.org/vocab/vann/preferredNamespacePrefix";
        this.alwaysUseOntologyPrefix = cliParams.is(Option.ALWAYS_USE_ONTOLOGY_PREFIX.arg, true);
        this.prefixMappingFile = cliParams.has(Option.PREFIX_MAPPING_FILE.arg) ? cliParams.valueOf(Option.PREFIX_MAPPING_FILE.arg).toString() : null;
        this.remotePrefixResolver = new PrefixCcRemotePrefixResolver();
    }

    public String getContext() {
        return this.context;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getTargetDir() {
        return this.targetDir;
    }

    public boolean areAllAxiomsIntegrityConstraints() {
        return this.context == null;
    }

    public boolean shouldGenerateOwlapiIris() {
        return this.generateOwlapiIris;
    }

    public boolean shouldGenerateJavadoc() {
        return this.generateJavadoc;
    }

    public boolean shouldPreferMultilingualStrings() {
        return this.preferMultilingualStrings;
    }

    public PropertiesType getPropertiesType() {
        return this.propertiesType;
    }

    public boolean shouldGenerateAnnotationFields() {
        return this.generateAnnotationFields;
    }

    public boolean shouldGenerateThing() {
        return this.generateThing;
    }

    public String getOntologyPrefixProperty() {
        return this.ontologyPrefixProperty;
    }

    public boolean shouldAlwaysUseOntologyPrefix() {
        return this.alwaysUseOntologyPrefix;
    }

    public String getPrefixMappingFile() {
        return this.prefixMappingFile;
    }

    public RemotePrefixResolver getRemotePrefixResolver() {
        return this.remotePrefixResolver;
    }

    public CliParams getCliParams() {
        return this.cliParams;
    }

    public static TransformationConfiguration config(CliParams cliParams) {
        return new TransformationConfiguration(cliParams);
    }

    public static TransformationConfigurationBuilder builder() {
        return new TransformationConfigurationBuilder();
    }

    public static class TransformationConfigurationBuilder {
        private String context;
        private String packageName = "generated";
        private String targetDir = "";
        private PropertiesType propertiesType = PropertiesType.valueOf(Defaults.PROPERTIES_TYPE);
        private boolean owlapiIris = false;
        private boolean generateJavadoc = true;
        private boolean preferMultilingualStrings = true;
        private boolean generateAnnotationFields = true;
        private boolean generateThing = true;
        private String ontologyPrefixProperty = "http://purl.org/vocab/vann/preferredNamespacePrefix";
        private boolean alwaysUseOntologyPrefix = true;
        private String prefixMappingFile = null;
        private RemotePrefixResolver remotePrefixResolver = new PrefixCcRemotePrefixResolver();

        public TransformationConfigurationBuilder context(String context) {
            this.context = context;
            return this;
        }

        public TransformationConfigurationBuilder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public TransformationConfigurationBuilder targetDir(String targetDir) {
            this.targetDir = targetDir;
            return this;
        }

        public TransformationConfigurationBuilder addOwlapiIris(boolean add) {
            this.owlapiIris = add;
            return this;
        }

        public TransformationConfigurationBuilder generateJavadoc(boolean javadoc) {
            this.generateJavadoc = javadoc;
            return this;
        }

        public TransformationConfigurationBuilder preferMultilingualStrings(boolean preferMultilingualStrings) {
            this.preferMultilingualStrings = preferMultilingualStrings;
            return this;
        }

        public TransformationConfigurationBuilder propertiesType(PropertiesType propertiesType) {
            this.propertiesType = propertiesType;
            return this;
        }

        public TransformationConfigurationBuilder generateAnnotationFields(boolean generateAnnotationFields) {
            this.generateAnnotationFields = generateAnnotationFields;
            return this;
        }

        public TransformationConfigurationBuilder generateThing(boolean generateThing) {
            this.generateThing = generateThing;
            return this;
        }

        public TransformationConfigurationBuilder ontologyPrefixProperty(String ontologyPrefixProperty) {
            if (ontologyPrefixProperty != null && !ontologyPrefixProperty.isBlank()) {
                this.ontologyPrefixProperty = ontologyPrefixProperty;
            }
            return this;
        }

        public TransformationConfigurationBuilder alwaysUseOntologyPrefix(boolean alwaysUseOntologyPrefix) {
            this.alwaysUseOntologyPrefix = alwaysUseOntologyPrefix;
            return this;
        }

        public TransformationConfigurationBuilder prefixMappingFile(String prefixMappingFile) {
            this.prefixMappingFile = prefixMappingFile;
            return this;
        }

        public TransformationConfigurationBuilder remotePrefixResolver(RemotePrefixResolver resolver) {
            this.remotePrefixResolver = resolver;
            return this;
        }

        public TransformationConfiguration build() {
            return new TransformationConfiguration(this);
        }
    }
}

